package odeToJava.functions;

import odeToJava.modules.*;

/*
   ODE function for a method of lines problem (cooling bar problem)
   *note that this problem should only be solved with a constant step
   method (not with one where the stepsize varies)
*/
public class Mol implements ODE
{
     // constructors
	
     public Mol(double h)   // this class has a constructor, because it needs
     {   // to store h, which the problem depends on, but it still properly
          this.h = h;   // implements Fv as it overloads the f and g methods
     }

     // methods

     public double[] f(double t, double[] x)   // ODE function
     {
          double[] xp = new double[x.length];

          xp[0] = 0;   // set the ends of the bar to 0
          xp[x.length -1] = 0;

          for(int i= 1; i< x.length -1; i++)   // large tri-diagonal matrix
          {
               xp[i] = (x[i-1] - 2*x[i] + x[i+1])/(h*h); 
          }

          return(xp);
     }

     public double[] g(double t, double[] x)   // event function
     {   // empty implementation of g because there are no events associated
          double[] event = new double[1];   // with this ODE
          return(event);
     }

     // instance variables

     /*
        this class has instance variables, but it still properly
        implements Fv as it overloads the f and g methods
     */

     private double h;   // stepsize that solver uses to solve this problem
}