package odeToJava.functions;

import odeToJava.modules.*;

/*
   ODE for the piecewise non-stiff F4 function of the DEtest testset
*/
public class F4 implements ODE
{
     // constructors

     public F4(int mode)   // constructor needed for piecewise function becuase it depends
     {   // on the mode, but it still properly overloads f and g, so this is legal
          this.mode = mode;
     }

     // methods

     public double[] f(double t, double[] x)   // ODE function
     {
          double[] x_prime = new double[x.length];

          switch(mode)
          {
               case 1:   // piece 1
                    x_prime[0] = -2.0/21.0 - 120.0*(t - 5.0)/(1.0 + 4.0*(t - 5.0)*(t - 5.0)); 
               break;
               case 2:   // piece 2
                    x_prime[0] = -2.0*x[0];
               break;
               default:   // if user inputs number other than 1 or 2, pass back 0
                    x_prime[0] = 0.0;
               break;
          }

          return(x_prime);
     }

     public double[] g(double t, double[] x)   // event function
     {
          double[] event = new double[x.length];

          event[0] = t - 10.0;   // event occurs at t = 10

          return(event);
     }

     // instance variables

     /*
        this class has instance variables, but it still properly
        implements Fv as it overloads the f and g methods
     */

     private int mode;   // which piece of the piecewise function to use
}