package odeToJava.functions;

import odeToJava.modules.*;

/*
   ODE for the Brusselator problem (an example can illustrate the
   Dormand-Prince interpolation scheme)
*/
public class Brusselator implements ODE
{
     // constructors

     // methods

     public double[] f(double t, double[] x)   // ODE function
     {
          double[] xp = new double[x.length];

          xp[0] = 1 + x[0]*x[0]*x[1] - 4*x[0];
          xp[1] = 3*x[0] - x[0]*x[0]*x[1];

          return(xp);
     }

     public double[] g(double t, double[] x)   // event function
     {   // empty implementation of g because there are no events associated
          double[] event = new double[1];   // with this ODE
          return(event);
     }

     // instance variables
}