/*
 * Decompiled with CFR 0.152.
 */
package odeToJava.ssCtrlModules;

import Jama.Matrix;
import odeToJava.modules.Btableau;
import odeToJava.modules.ODE;
import odeToJava.modules.StdMet;

public class Imex1S {
    private int s;
    private double[][] a;
    private double[] b;
    private double[][] ahat;
    private double[] bhat;
    private ODE f;
    private double t;
    private double h;
    private int n;
    private double[] uold;
    private double[] unew;
    private double[][] jacobian;
    private double[][] I;
    private double[][] k;
    private double[][] khat;
    private final double deltaMin = 1.0E-4;
    private final double deltaY = Math.sqrt(1.0E-4);

    public Imex1S(Btableau btableau) {
        this.s = btableau.getbl();
        this.a = new double[btableau.getah()][btableau.getal()];
        this.b = new double[btableau.getbl()];
        this.ahat = new double[btableau.getahath()][btableau.getahatl()];
        this.bhat = new double[btableau.getbhatl()];
        StdMet.matrixcpy(this.a, btableau.get_a());
        StdMet.arraycpy(this.b, btableau.get_b());
        StdMet.matrixcpy(this.ahat, btableau.get_ahat());
        StdMet.arraycpy(this.bhat, btableau.get_bhat());
    }

    public double[] doOneStep(ODE oDE, double d, double[] dArray, double d2) {
        int n;
        int n2;
        this.t = d;
        this.h = d2;
        this.n = dArray.length;
        this.f = oDE;
        this.uold = new double[this.n];
        this.unew = new double[this.n];
        this.jacobian = new double[this.n][this.n];
        this.I = new double[this.n][this.n];
        int n3 = 0;
        while (n3 < this.n) {
            int n4 = 0;
            while (n4 < this.n) {
                if (n3 == n4) {
                    this.I[n3][n4] = 1.0;
                }
                ++n4;
            }
            ++n3;
        }
        double[] dArray2 = new double[this.n];
        double[] dArray3 = new double[this.n];
        double[] dArray4 = new double[this.n];
        double[] dArray5 = new double[this.n];
        double[] dArray6 = new double[this.n];
        double[] dArray7 = new double[this.n];
        double[] dArray8 = new double[this.n];
        double[] dArray9 = new double[this.n];
        double[] dArray10 = new double[this.n];
        double[] dArray11 = new double[this.n];
        double[] dArray12 = new double[this.n];
        double[] dArray13 = new double[this.n];
        double[][] dArray14 = new double[this.n][this.n];
        double[][] dArray15 = new double[this.n][1];
        StdMet.arraycpy(this.uold, dArray);
        dArray2 = this.f.f(d, this.uold);
        int n5 = 0;
        while (n5 < this.n) {
            double d3 = this.deltaY * Math.abs(this.uold[n5]);
            if (d3 < 1.0E-4) {
                d3 = 1.0E-4;
            }
            StdMet.arraycpy(dArray4, this.uold);
            int n6 = n5;
            dArray4[n6] = dArray4[n6] + d3;
            dArray3 = this.f.f(d, dArray4);
            StdMet.arraydiff(dArray5, dArray3, dArray2);
            StdMet.stam(dArray6, 1.0 / d3, dArray5);
            n2 = 0;
            while (n2 < this.n) {
                this.jacobian[n2][n5] = dArray6[n2];
                ++n2;
            }
            ++n5;
        }
        this.k = new double[this.s][this.n];
        this.khat = new double[this.s + 1][this.n];
        dArray2 = this.f.f(d, this.uold);
        StdMet.mtam(dArray11, this.jacobian, this.uold);
        StdMet.arraydiff(dArray10, dArray2, dArray11);
        StdMet.arraycpy(this.khat[0], dArray10);
        n2 = 0;
        while (n2 < this.s) {
            StdMet.zero_out(dArray12);
            n = 0;
            while (n < n2) {
                StdMet.stam(dArray6, this.a[n2][n], this.k[n]);
                StdMet.stam(dArray7, this.ahat[n2 + 1][n], this.khat[n]);
                StdMet.arraysum(dArray8, dArray6, dArray7);
                StdMet.arraysum(dArray12, dArray12, dArray8);
                ++n;
            }
            StdMet.stam(dArray6, this.ahat[n2 + 1][n2], this.khat[n2]);
            StdMet.arraysum(dArray12, dArray12, dArray6);
            StdMet.stam(dArray12, d2, dArray12);
            StdMet.arraysum(dArray12, dArray12, this.uold);
            int n7 = 0;
            while (n7 < this.n) {
                StdMet.stam(dArray6, d2 * this.a[n2][n2], this.jacobian[n7]);
                StdMet.arraycpy(dArray14[n7], dArray6);
                ++n7;
            }
            int n8 = 0;
            while (n8 < this.n) {
                StdMet.arraydiff(dArray14[n8], this.I[n8], dArray14[n8]);
                ++n8;
            }
            StdMet.mtam(dArray9, this.jacobian, dArray12);
            Matrix matrix = new Matrix(dArray14);
            int n9 = 0;
            while (n9 < this.n) {
                dArray15[n9][0] = dArray9[n9];
                ++n9;
            }
            Matrix matrix2 = new Matrix(dArray15);
            Matrix matrix3 = matrix.solve(matrix2);
            dArray13 = matrix3.getColumnPackedCopy();
            StdMet.arraycpy(this.k[n2], dArray13);
            StdMet.stam(dArray6, d2 * this.a[n2][n2], this.k[n2]);
            StdMet.arraysum(dArray12, dArray12, dArray6);
            dArray2 = this.f.f(d, dArray12);
            StdMet.mtam(dArray11, this.jacobian, dArray12);
            StdMet.arraydiff(dArray10, dArray2, dArray11);
            StdMet.arraycpy(this.khat[n2 + 1], dArray10);
            ++n2;
        }
        StdMet.zero_out(dArray12);
        n = 0;
        while (n < this.s) {
            StdMet.stam(dArray6, this.b[n], this.k[n]);
            StdMet.stam(dArray7, this.bhat[n], this.khat[n]);
            StdMet.arraysum(dArray8, dArray6, dArray7);
            StdMet.arraysum(dArray12, dArray12, dArray8);
            ++n;
        }
        StdMet.stam(dArray6, this.bhat[this.s], this.khat[this.s]);
        StdMet.arraysum(dArray12, dArray12, dArray6);
        StdMet.stam(dArray12, d2, dArray12);
        StdMet.arraysum(this.unew, this.uold, dArray12);
        return this.unew;
    }
}

