/*
 * Decompiled with CFR 0.152.
 */
package odeToJava.plotter;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import javax.swing.JPanel;

public class PlotPanel
extends JPanel {
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private double[] x;
    private double[] y;
    private double domain;
    private double range;
    private double xStandard;
    private double yStandard;
    private final double RADIUS = 1.0;
    private final double DIAMETER = 2.0;
    private final double DEFAULT_WIDTH = 472.0;
    private final double DEFAULT_HEIGHT = 511.0;

    public PlotPanel(double[] dArray, double[] dArray2, double d, double d2, double d3, double d4) {
        this.xMin = d;
        this.xMax = d2;
        this.yMin = d3;
        this.yMax = d4;
        this.x = new double[dArray.length];
        this.y = new double[dArray2.length];
        int n = 0;
        while (n < this.x.length) {
            this.x[n] = dArray[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < this.y.length) {
            this.y[n2] = dArray2[n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.x.length) {
            if (this.x[n3] < this.xMin) {
                this.x[n3] = this.xMin;
            }
            if (this.x[n3] > this.xMax) {
                this.x[n3] = this.xMax;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.y.length) {
            if (this.y[n4] < this.yMin) {
                this.y[n4] = this.yMin;
            }
            if (this.y[n4] > this.yMax) {
                this.y[n4] = this.yMax;
            }
            ++n4;
        }
        this.domain = this.xMax - this.xMin;
        this.range = this.yMax - this.yMin;
        this.xStandard = 472.0;
        this.yStandard = 511.0;
        int n5 = 0;
        while (n5 < this.x.length) {
            int n6 = n5;
            this.x[n6] = this.x[n6] - this.xMin;
            int n7 = n5++;
            this.x[n7] = this.x[n7] * (this.xStandard / this.domain);
        }
        int n8 = 0;
        while (n8 < this.y.length) {
            int n9 = n8;
            this.y[n9] = this.y[n9] - this.yMin;
            int n10 = n8;
            this.y[n10] = this.y[n10] * (this.yStandard / this.range);
            this.y[n8] = this.yStandard - this.y[n8];
            ++n8;
        }
        this.setBackground(Color.white);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = 0;
        while (n < this.x.length) {
            int n2 = n++;
            this.x[n2] = this.x[n2] * ((double)this.getWidth() / this.xStandard);
        }
        int n3 = 0;
        while (n3 < this.y.length) {
            int n4 = n3++;
            this.y[n4] = this.y[n4] * ((double)this.getHeight() / this.yStandard);
        }
        int n5 = 0;
        while (n5 < this.x.length - 1) {
            if (!(this.x[n5] == (double)this.getWidth() && this.x[n5 + 1] == (double)this.getWidth() || this.x[n5] == 0.0 && this.x[n5 + 1] == 0.0 || this.y[n5] == (double)this.getHeight() && this.y[n5 + 1] == (double)this.getHeight() || this.y[n5] == 0.0 && this.y[n5 + 1] == 0.0)) {
                graphics2D.draw(new Line2D.Double(this.x[n5], this.y[n5], this.x[n5 + 1], this.y[n5 + 1]));
            }
            ++n5;
        }
        graphics2D.setColor(Color.blue);
        int n6 = 0;
        while (n6 < this.x.length) {
            if (this.x[n6] != (double)this.getWidth() && this.x[n6] != 0.0 && this.y[n6] != (double)this.getHeight() && this.y[n6] != 0.0) {
                graphics2D.draw(new Ellipse2D.Double(this.x[n6] - 1.0, this.y[n6] - 1.0, 2.0, 2.0));
            }
            ++n6;
        }
        graphics2D.setColor(Color.black);
        this.xStandard = this.getWidth();
        this.yStandard = this.getHeight();
    }
}

