/*
 * Decompiled with CFR 0.152.
 */
package odeToJava.plotter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import odeToJava.plotter.FileIntake;
import odeToJava.plotter.GraphPanel;
import odeToJava.plotter.GraphPaperLayout;

public class MainPanel
extends JPanel {
    private GraphPaperLayout mainLayout = new GraphPaperLayout(new Dimension(6, 1), 4, 4);
    private GraphPanel graphPanel;
    private JPanel paramPanel;
    private GraphPaperLayout paramLayout;
    private JLabel fileLabel;
    private JTextField fileField;
    private JButton fileButton;
    private JLabel tVectorLabel;
    private JTextField tVectorField;
    private JLabel yVectorLabel;
    private JTextField yVectorField;
    private JLabel titleLabel;
    private JTextField titleField;
    private JLabel xAxisLabel;
    private JTextField xAxisField;
    private JLabel yAxisLabel;
    private JTextField yAxisField;
    private JLabel xlBoundLabel;
    private JTextField xlBoundField;
    private JLabel xuBoundLabel;
    private JTextField xuBoundField;
    private JLabel xTickLabel;
    private JTextField xTickField;
    private JLabel ylBoundLabel;
    private JTextField ylBoundField;
    private JLabel yuBoundLabel;
    private JTextField yuBoundField;
    private JLabel yTickLabel;
    private JTextField yTickField;
    private JPanel radioButtonPanel;
    private JRadioButton linearButton;
    private JRadioButton semilogButton;
    private JRadioButton loglogButton;
    private ButtonGroup typeGroup;
    private JPanel buttonPanel;
    private JButton updateButton;
    private ActionListener listener;
    private String file;
    private String tVector;
    private String yVector;
    private String title;
    private String xAxis;
    private String yAxis;
    private String xlBound;
    private String xuBound;
    private String xTick;
    private String ylBound;
    private String yuBound;
    private String yTick;
    private FileIntake intake;
    private static final String UPDATE_EVENT = "UPDATE_EVENT";
    private static final String CHOOSE_FILE_EVENT = "CHOOSE_FILE_EVENT";

    public MainPanel() {
        this.setLayout(this.mainLayout);
        this.paramPanel = new JPanel();
        this.paramLayout = new GraphPaperLayout(new Dimension(5, 16), 4, 4);
        this.paramPanel.setLayout(this.paramLayout);
        this.add((Component)this.paramPanel, new Rectangle(0, 0, 2, 1));
        this.listener = new UIListener();
        this.fileLabel = new JLabel("file name");
        this.fileField = new JTextField(5);
        this.fileButton = new JButton("Choose...");
        this.fileButton.setActionCommand(CHOOSE_FILE_EVENT);
        this.fileButton.addActionListener(this.listener);
        this.tVectorLabel = new JLabel("Index for x (or t for time)");
        this.tVectorField = new JTextField(2);
        this.yVectorLabel = new JLabel("Index for y (or t for time)");
        this.yVectorField = new JTextField(2);
        this.titleLabel = new JLabel("title");
        this.titleField = new JTextField(5);
        this.xAxisLabel = new JLabel("x label");
        this.xAxisField = new JTextField(5);
        this.yAxisLabel = new JLabel("y label");
        this.yAxisField = new JTextField(5);
        this.xlBoundLabel = new JLabel("x axis        from");
        this.xlBoundField = new JTextField(2);
        this.xuBoundLabel = new JLabel("       to");
        this.xuBoundField = new JTextField(2);
        this.xTickLabel = new JLabel("x tick");
        this.xTickField = new JTextField(2);
        this.ylBoundLabel = new JLabel("y axis        from");
        this.ylBoundField = new JTextField(2);
        this.yuBoundLabel = new JLabel("       to");
        this.yuBoundField = new JTextField(2);
        this.yTickLabel = new JLabel("y tick");
        this.yTickField = new JTextField(2);
        this.paramPanel.add((Component)this.fileLabel, new Rectangle(0, 0, 3, 1));
        this.paramPanel.add((Component)this.fileField, new Rectangle(2, 0, 2, 1));
        this.paramPanel.add((Component)this.fileButton, new Rectangle(1, 1, 3, 1));
        this.paramPanel.add((Component)this.tVectorLabel, new Rectangle(0, 3, 4, 1));
        this.paramPanel.add((Component)this.tVectorField, new Rectangle(4, 3, 1, 1));
        this.paramPanel.add((Component)this.yVectorLabel, new Rectangle(0, 4, 4, 1));
        this.paramPanel.add((Component)this.yVectorField, new Rectangle(4, 4, 1, 1));
        this.paramPanel.add((Component)this.titleLabel, new Rectangle(0, 5, 2, 1));
        this.paramPanel.add((Component)this.titleField, new Rectangle(2, 5, 2, 1));
        this.paramPanel.add((Component)this.xAxisLabel, new Rectangle(0, 6, 2, 1));
        this.paramPanel.add((Component)this.xAxisField, new Rectangle(2, 6, 1, 1));
        this.paramPanel.add((Component)this.yAxisLabel, new Rectangle(0, 7, 2, 1));
        this.paramPanel.add((Component)this.yAxisField, new Rectangle(2, 7, 1, 1));
        this.paramPanel.add((Component)this.xlBoundLabel, new Rectangle(0, 9, 2, 1));
        this.paramPanel.add((Component)this.xlBoundField, new Rectangle(2, 9, 1, 1));
        this.paramPanel.add((Component)this.xuBoundLabel, new Rectangle(3, 9, 1, 1));
        this.paramPanel.add((Component)this.xuBoundField, new Rectangle(4, 9, 1, 1));
        this.paramPanel.add((Component)this.xTickLabel, new Rectangle(0, 10, 1, 1));
        this.paramPanel.add((Component)this.xTickField, new Rectangle(1, 10, 1, 1));
        this.paramPanel.add((Component)this.ylBoundLabel, new Rectangle(0, 11, 2, 1));
        this.paramPanel.add((Component)this.ylBoundField, new Rectangle(2, 11, 1, 1));
        this.paramPanel.add((Component)this.yuBoundLabel, new Rectangle(3, 11, 1, 1));
        this.paramPanel.add((Component)this.yuBoundField, new Rectangle(4, 11, 1, 1));
        this.paramPanel.add((Component)this.yTickLabel, new Rectangle(0, 12, 1, 1));
        this.paramPanel.add((Component)this.yTickField, new Rectangle(1, 12, 1, 1));
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("update");
        jButton.setActionCommand(UPDATE_EVENT);
        jButton.addActionListener(this.listener);
        jPanel.add(jButton);
        this.paramPanel.add((Component)jPanel, new Rectangle(0, 14, 5, 2));
    }

    public void upDateStatus() throws Exception {
        this.file = this.fileField.getText();
        this.tVector = this.tVectorField.getText();
        this.yVector = this.yVectorField.getText();
        if (this.file.trim().equals("")) {
            throw new Exception("Please enter a filename.");
        }
        int n = 0;
        int n2 = 0;
        try {
            n = this.tVector.trim().equalsIgnoreCase("t") ? 0 : Integer.parseInt(this.tVector) + 1;
            n2 = this.yVector.trim().equalsIgnoreCase("t") ? 0 : Integer.parseInt(this.yVector) + 1;
        }
        catch (Exception exception) {
            throw new Exception("Unknown variables. Enter variable index or t.");
        }
        this.title = this.titleField.getText();
        this.xAxis = this.xAxisField.getText();
        this.yAxis = this.yAxisField.getText();
        this.xlBound = this.xlBoundField.getText();
        this.xuBound = this.xuBoundField.getText();
        this.xTick = this.xTickField.getText();
        this.ylBound = this.ylBoundField.getText();
        this.yuBound = this.yuBoundField.getText();
        this.yTick = this.yTickField.getText();
        this.intake = new FileIntake(this.file);
        this.intake.vectorize(n, n2);
        if (this.graphPanel != null) {
            this.remove(this.graphPanel);
        }
        this.graphPanel = new GraphPanel(this.intake.getVectorX(), this.intake.getVectorY(), this.xlBound, this.xuBound, this.ylBound, this.yuBound, this.title, this.xAxis, this.yAxis, this.xTick, this.yTick);
        this.add((Component)this.graphPanel, new Rectangle(2, 0, 4, 1));
        this.graphPanel.updateUI();
    }

    public void chooseFileDialog() {
        JFileChooser jFileChooser;
        try {
            jFileChooser = new JFileChooser(this.fileField.getText());
        }
        catch (NullPointerException nullPointerException) {
            jFileChooser = new JFileChooser();
        }
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.selectFile(jFileChooser.getSelectedFile().getPath());
        }
    }

    public void selectFile(String string) {
        this.fileField.setText(string);
    }

    private class UIListener
    implements ActionListener {
        private UIListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(MainPanel.UPDATE_EVENT)) {
                try {
                    MainPanel.this.upDateStatus();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.getMessage(), "Alert", 0);
                }
            } else if (string.equals(MainPanel.CHOOSE_FILE_EVENT)) {
                MainPanel.this.chooseFileDialog();
            }
        }
    }
}

