/*
 * Decompiled with CFR 0.152.
 */
package odeToJava.plotter;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import javax.swing.JPanel;

public class CoordPanel
extends JPanel {
    private double min;
    private double max;
    private double tick;
    private String axis;
    private double range;
    private double increment;
    private double mid;
    private double high;
    private double low;
    private double cFactor;
    private double graphTick;
    private double graphMax;
    private double graphInc;
    private float stringEnd;
    private String temp;
    private double nTicks;
    private int skip;
    private int count;

    public CoordPanel(double d, double d2, double d3, String string) throws Exception {
        this.min = d;
        this.max = d2;
        this.tick = d3;
        this.axis = string.toString();
        if (!string.equals("x") && !string.equals("y")) {
            throw new Exception("Internal Error: Axis neither x or y.");
        }
        this.range = this.max - this.min;
        if (this.range / this.tick > 50.0) {
            this.tick = this.range / 50.0;
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.axis.equals("x")) {
            this.increment = this.min;
            this.mid = (double)this.getHeight() / 2.0;
            this.high = (double)this.getHeight() / 8.0;
            this.low = this.getHeight();
            this.cFactor = (double)this.getHeight() / 3.5;
            this.graphMax = (double)this.getWidth() * 0.999;
            this.graphTick = this.tick / this.range * (double)this.getWidth();
            this.graphInc = 0.0;
            this.stringEnd = (float)((double)this.getWidth() * 0.04);
            this.nTicks = Math.floor(this.range / this.tick) + 1.0;
            this.skip = (int)Math.ceil(this.nTicks / 8.0);
            this.count = 0;
            graphics2D.draw(new Line2D.Double(0.0, this.cFactor, this.graphMax, this.cFactor));
            graphics2D.draw(new Line2D.Double(this.graphMax, this.cFactor, this.graphMax, this.high));
            while (this.graphInc <= this.graphMax) {
                graphics2D.draw(new Line2D.Double(this.graphInc, this.cFactor, this.graphInc, this.high));
                this.temp = String.valueOf(this.increment);
                if (this.temp.length() > 5) {
                    this.temp = this.temp.substring(0, 4);
                }
                if (this.count % this.skip == 0) {
                    graphics2D.drawString(this.temp, (float)this.graphInc, (float)this.low);
                }
                this.graphInc += this.graphTick;
                this.increment += this.tick;
                ++this.count;
            }
            if (this.graphInc - this.graphTick < this.graphMax - (double)(2.0f * this.stringEnd)) {
                graphics2D.drawString(String.valueOf(this.max), (float)(this.graphMax - (double)this.stringEnd), (float)this.low);
            }
        } else {
            this.increment = this.min;
            this.mid = (double)this.getWidth() / 2.0;
            this.high = (double)this.getWidth() * 0.875;
            this.low = 0.0;
            this.cFactor = 3.0 * (double)this.getWidth() / 4.0;
            this.graphMax = (double)this.getHeight() * 0.999;
            this.graphTick = this.tick / this.range * (double)this.getHeight();
            this.graphInc = 0.0;
            this.stringEnd = (float)((double)this.getHeight() * 0.04);
            this.nTicks = Math.floor(this.range / this.tick) + 1.0;
            this.skip = (int)Math.ceil(this.nTicks / 10.0);
            this.count = 0;
            graphics2D.draw(new Line2D.Double(this.cFactor, 0.0, this.cFactor, this.graphMax));
            graphics2D.draw(new Line2D.Double(this.cFactor, this.graphMax, this.high, this.graphMax));
            while (this.graphInc <= this.graphMax) {
                graphics2D.draw(new Line2D.Double(this.cFactor, this.graphInc, this.high, this.graphInc));
                this.temp = String.valueOf(this.increment);
                if (this.temp.length() > 5) {
                    this.temp = this.temp.substring(0, 4);
                }
                if (this.count % this.skip == 0) {
                    graphics2D.rotate(4.71238898038469, this.mid, this.graphMax - this.graphInc);
                    graphics2D.drawString(this.temp, (float)this.mid, (float)(this.graphMax - this.graphInc));
                    graphics2D.rotate(1.5707963267948966, this.mid, this.graphMax - this.graphInc);
                }
                this.graphInc += this.graphTick;
                this.increment += this.tick;
                ++this.count;
            }
            if (this.graphInc - this.graphTick < this.graphMax - (double)(2.0f * this.stringEnd)) {
                graphics2D.rotate(4.71238898038469, this.mid, this.stringEnd);
                graphics2D.drawString(String.valueOf(this.max), (float)this.mid, this.stringEnd);
                graphics2D.rotate(4.71238898038469, this.mid, this.stringEnd);
            }
        }
    }
}

