/*
 * Decompiled with CFR 0.152.
 */
package odeToJava;

import odeToJava.modules.Btableau;
import odeToJava.modules.ODE;
import odeToJava.modules.ODEFileWriter;
import odeToJava.modules.Span;
import odeToJava.modules.StdMet;
import odeToJava.ssCtrlModules.ErrorEstimator;
import odeToJava.ssCtrlModules.Imex1S;

public class ImexSD {
    private ODE f;
    private Btableau butcher;
    private double t0;
    private double tf;
    private int n;
    private double[] unew;
    private double atol;
    private double rtol;
    private double h;
    private double hopt;
    private double told;
    private double[] uold_e1;
    private double[] uold_e2;
    private String fileName;
    private boolean stats_on;
    private boolean stats_intermediate;
    private final double alpha = 0.9;
    private final double amax = 5.0;
    private double p;
    private int nreject;
    private int naccept;
    private boolean done;
    private boolean lastStep;
    private double[] eta1;
    private double[] eta2;

    public static void imex_sd(ODE oDE, Span span, double[] dArray, double d, Btableau btableau, double d2, double d3, String string, String string2) {
        ImexSD imexSD = new ImexSD(oDE, span, dArray, d, btableau, d2, d3, string, string2);
        imexSD.routine();
    }

    public ImexSD(ODE oDE, Span span, double[] dArray, double d, Btableau btableau, double d2, double d3, String string, String string2) {
        if (!span.get_property()) {
            System.out.println("Improper span: times are out of order");
            System.exit(0);
        }
        this.f = oDE;
        this.butcher = btableau;
        this.t0 = span.get_t0();
        this.tf = span.get_tf();
        this.atol = d2;
        this.rtol = d3;
        this.h = d;
        this.n = dArray.length;
        this.eta1 = new double[this.n];
        this.eta2 = new double[this.n];
        if (d <= 0.0) {
            System.out.println("Initial stepsize must be greater than zero");
            System.exit(0);
        }
        if (d2 <= 0.0) {
            System.out.println("Abolute tolerance must be greater than zero");
            System.exit(0);
        }
        if (d3 <= 0.0) {
            System.out.println("Relative tolerance must be greater than zero");
            System.exit(0);
        }
        this.p = 3.0;
        this.nreject = 0;
        this.naccept = 0;
        this.told = this.t0;
        this.uold_e1 = new double[this.n];
        StdMet.arraycpy(this.uold_e1, dArray);
        this.uold_e2 = new double[this.n];
        StdMet.arraycpy(this.uold_e2, dArray);
        this.lastStep = false;
        this.done = false;
        if (string2.equals("Stats_On")) {
            this.stats_on = true;
            this.stats_intermediate = false;
        } else if (string2.equals("Stats_Intermediate")) {
            this.stats_on = true;
            this.stats_intermediate = true;
        } else if (string2.equals("Stats_Off")) {
            this.stats_on = false;
            this.stats_intermediate = false;
        } else {
            System.out.println("String parameter must be either: 1) \"Stats_On\" 2) \"Stats_Intermediate\" or 3) \"Stats_Off\"");
            System.exit(0);
        }
        this.fileName = string;
        if (span.get_timesLength() > 0) {
            System.out.println();
            System.out.println("note that this solver does not do interpolation . . .");
            System.out.println();
        }
    }

    public void routine() {
        System.out.println();
        System.out.println("Begin Implicit-Explicit Runge-Kutta /w Step Doubling Routine . . .");
        System.out.println();
        Imex1S imex1S = new Imex1S(this.butcher);
        double[] dArray = new double[this.n];
        double[] dArray2 = new double[this.n];
        double[] dArray3 = new double[this.n];
        ODEFileWriter oDEFileWriter = new ODEFileWriter();
        oDEFileWriter.openFile(this.fileName);
        while (!this.done) {
            if (this.lastStep) {
                this.done = true;
            }
            this.eta1 = imex1S.doOneStep(this.f, this.told, this.uold_e1, this.h);
            StdMet.arraycpy(dArray, this.uold_e1);
            StdMet.arraycpy(this.uold_e1, this.eta1);
            dArray2 = imex1S.doOneStep(this.f, this.told, this.uold_e2, this.h / 2.0);
            this.eta2 = imex1S.doOneStep(this.f, this.told + this.h / 2.0, dArray2, this.h / 2.0);
            StdMet.arraycpy(this.uold_e2, this.eta2);
            this.told += this.h;
            double[] dArray4 = ErrorEstimator.stepdoubling_estimate(this.h, this.eta1, this.eta2, dArray, this.atol, this.rtol, this.p, 5.0, 0.9);
            double d = dArray4[0];
            this.hopt = dArray4[1];
            double d2 = dArray4[2];
            if (d2 != d2) {
                System.out.println("unstable . . . aborting");
                System.out.println("accepted: " + this.naccept);
                System.out.println("rejected: " + this.nreject);
                oDEFileWriter.closeFile();
                return;
            }
            if (this.tf - this.told <= d) {
                d = this.tf - this.told;
                this.lastStep = true;
            }
            if (this.done) {
                if (this.h / this.hopt > 3.0) {
                    this.done = false;
                    this.lastStep = false;
                    ++this.nreject;
                    this.told -= this.h;
                    StdMet.arraycpy(this.uold_e1, dArray);
                    StdMet.arraycpy(this.uold_e2, dArray);
                    this.h /= 2.0;
                    if (!this.stats_on || this.stats_intermediate) continue;
                    System.out.println("rejected");
                    System.out.println("new h = " + this.h);
                    System.out.println();
                    continue;
                }
                ++this.naccept;
                System.out.println("done");
                System.out.println("final t = " + this.told);
                System.out.println("final u =");
                StdMet.arrayprt(this.uold_e2);
                System.out.println();
                System.out.println("# of rejections = " + this.nreject);
                System.out.println("# of accepted steps = " + this.naccept);
                oDEFileWriter.writeToFile(this.told, this.uold_e2);
                continue;
            }
            if (this.lastStep || this.h / this.hopt <= 3.0) {
                StdMet.arraycpy(this.uold_e1, this.uold_e2);
                this.h = d;
                ++this.naccept;
                oDEFileWriter.writeToFile(this.told, this.uold_e2);
                if (!this.stats_on) continue;
                if (!this.stats_intermediate) {
                    System.out.println("accepted");
                    System.out.println("new h = " + this.h);
                }
                System.out.println("t = " + this.told);
                if (!this.stats_intermediate) {
                    System.out.println("solution = ");
                    StdMet.arrayprt(this.uold_e2);
                }
                System.out.println();
                continue;
            }
            this.told -= this.h;
            StdMet.arraycpy(this.uold_e1, dArray);
            StdMet.arraycpy(this.uold_e2, dArray);
            this.h = d;
            ++this.nreject;
            if (!this.stats_on || this.stats_intermediate) continue;
            System.out.println("rejected");
            System.out.println("new h = " + this.h);
            System.out.println();
        }
        oDEFileWriter.closeFile();
    }
}

