/*
 * Decompiled with CFR 0.152.
 */
package odeToJava;

import Jama.Matrix;
import odeToJava.modules.Btableau;
import odeToJava.modules.ODE;
import odeToJava.modules.ODEFileWriter;
import odeToJava.modules.Span;
import odeToJava.modules.StdMet;

public class Imex {
    private ODE f;
    private double t0;
    private double tf;
    private double[] u0;
    private double h;
    private double told;
    private double[] uold;
    private double[] unew;
    private int n;
    private int s;
    private double[][] a;
    private double[] b;
    private double[][] ahat;
    private double[] bhat;
    private int steps;
    private int count;
    private String fileName;
    private boolean stats_on;
    private boolean stats_intermediate;
    private double[][] jacobian;
    private double[][] I;
    private double[][] k;
    private double[][] khat;
    private final double deltaMin = 1.0E-4;
    private final double deltaY = Math.sqrt(1.0E-4);
    private int nPoints;

    public static void imex(ODE oDE, Span span, double[] dArray, double d, Btableau btableau, String string, String string2) {
        Imex imex = new Imex(oDE, span, dArray, d, btableau, string, string2);
        imex.setNPoints(1000);
        imex.routine();
    }

    public static void imex(ODE oDE, Span span, double[] dArray, double d, Btableau btableau, String string, String string2, int n) {
        Imex imex = new Imex(oDE, span, dArray, d, btableau, string, string2);
        imex.setNPoints(n);
        imex.routine();
    }

    public void setNPoints(int n) {
        this.nPoints = n;
    }

    public Imex(ODE oDE, Span span, double[] dArray, double d, Btableau btableau, String string, String string2) {
        if (!span.get_property()) {
            System.out.println("Improper span: times are out of order");
            System.exit(0);
        }
        this.f = oDE;
        this.t0 = span.get_t0();
        this.tf = span.get_tf();
        this.h = d;
        this.s = btableau.getbl();
        if (d <= 0.0) {
            System.out.println("Stepsize must be greater than zero");
            System.exit(0);
        }
        if (this.tf - this.t0 < d) {
            System.out.println("Stepsize is larger than tspan");
            System.exit(0);
        }
        this.u0 = new double[dArray.length];
        StdMet.arraycpy(this.u0, dArray);
        this.n = dArray.length;
        this.a = new double[btableau.getah()][btableau.getal()];
        this.b = new double[btableau.getbl()];
        this.ahat = new double[btableau.getahath()][btableau.getahatl()];
        this.bhat = new double[btableau.getbhatl()];
        StdMet.matrixcpy(this.a, btableau.get_a());
        StdMet.arraycpy(this.b, btableau.get_b());
        StdMet.matrixcpy(this.ahat, btableau.get_ahat());
        StdMet.arraycpy(this.bhat, btableau.get_bhat());
        this.steps = (int)Math.floor((this.tf - this.t0) / d);
        this.count = 0;
        if (string2.equals("Stats_On")) {
            this.stats_on = true;
            this.stats_intermediate = false;
        } else if (string2.equals("Stats_Intermediate")) {
            this.stats_on = true;
            this.stats_intermediate = true;
        } else if (string2.equals("Stats_Off")) {
            this.stats_on = false;
            this.stats_intermediate = false;
        } else {
            System.out.println("String parameter must be either: 1) \"Stats_On\" 2) \"Stats_Intermediate\" or 3) \"Stats_Off\"");
            System.exit(0);
        }
        this.fileName = string;
        if (span.get_timesLength() > 0) {
            System.out.println();
            System.out.println("note that this solver does not do interpolation . . .");
            System.out.println();
        }
    }

    public void routine() {
        System.out.println();
        System.out.println("Begin Implicit-Explicit Runge-Kutta Routine . . .");
        System.out.println();
        this.told = this.t0;
        this.uold = new double[this.n];
        this.unew = new double[this.n];
        StdMet.arraycpy(this.uold, this.u0);
        this.jacobian = new double[this.n][this.n];
        this.I = new double[this.n][this.n];
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 < this.n) {
                if (n == n2) {
                    this.I[n][n2] = 1.0;
                }
                ++n2;
            }
            ++n;
        }
        double[] dArray = new double[this.n];
        double[] dArray2 = new double[this.n];
        double[] dArray3 = new double[this.n];
        double[] dArray4 = new double[this.n];
        double[] dArray5 = new double[this.n];
        double[] dArray6 = new double[this.n];
        double[] dArray7 = new double[this.n];
        double[] dArray8 = new double[this.n];
        double[] dArray9 = new double[this.n];
        double[] dArray10 = new double[this.n];
        double[] dArray11 = new double[this.n];
        double[] dArray12 = new double[this.n];
        double[][] dArray13 = new double[this.n][this.n];
        double[][] dArray14 = new double[this.n][1];
        boolean bl = false;
        ODEFileWriter oDEFileWriter = new ODEFileWriter();
        oDEFileWriter.openFile(this.fileName);
        while (!bl) {
            int n3;
            int n4;
            if (this.told + this.h > this.tf) {
                this.h = this.tf - this.told;
                bl = true;
            }
            dArray = this.f.f(this.told, this.uold);
            int n5 = 0;
            while (n5 < this.n) {
                double d = this.deltaY * Math.abs(this.uold[n5]);
                if (d < 1.0E-4) {
                    d = 1.0E-4;
                }
                StdMet.arraycpy(dArray3, this.uold);
                int n6 = n5;
                dArray3[n6] = dArray3[n6] + d;
                dArray2 = this.f.f(this.told, dArray3);
                StdMet.arraydiff(dArray4, dArray2, dArray);
                StdMet.stam(dArray5, 1.0 / d, dArray4);
                n4 = 0;
                while (n4 < this.n) {
                    this.jacobian[n4][n5] = dArray5[n4];
                    ++n4;
                }
                ++n5;
            }
            this.k = new double[this.s][this.n];
            this.khat = new double[this.s + 1][this.n];
            dArray = this.f.f(this.told, this.uold);
            StdMet.mtam(dArray10, this.jacobian, this.uold);
            StdMet.arraydiff(dArray9, dArray, dArray10);
            StdMet.arraycpy(this.khat[0], dArray9);
            n4 = 0;
            while (n4 < this.s) {
                StdMet.zero_out(dArray11);
                n3 = 0;
                while (n3 < n4) {
                    StdMet.stam(dArray5, this.a[n4][n3], this.k[n3]);
                    StdMet.stam(dArray6, this.ahat[n4 + 1][n3], this.khat[n3]);
                    StdMet.arraysum(dArray7, dArray5, dArray6);
                    StdMet.arraysum(dArray11, dArray11, dArray7);
                    ++n3;
                }
                StdMet.stam(dArray5, this.ahat[n4 + 1][n4], this.khat[n4]);
                StdMet.arraysum(dArray11, dArray11, dArray5);
                StdMet.stam(dArray11, this.h, dArray11);
                StdMet.arraysum(dArray11, dArray11, this.uold);
                int n7 = 0;
                while (n7 < this.n) {
                    StdMet.stam(dArray5, this.h * this.a[n4][n4], this.jacobian[n7]);
                    StdMet.arraycpy(dArray13[n7], dArray5);
                    ++n7;
                }
                int n8 = 0;
                while (n8 < this.n) {
                    StdMet.arraydiff(dArray13[n8], this.I[n8], dArray13[n8]);
                    ++n8;
                }
                StdMet.mtam(dArray8, this.jacobian, dArray11);
                Matrix matrix = new Matrix(dArray13);
                int n9 = 0;
                while (n9 < this.n) {
                    dArray14[n9][0] = dArray8[n9];
                    ++n9;
                }
                Matrix matrix2 = new Matrix(dArray14);
                Matrix matrix3 = matrix.solve(matrix2);
                dArray12 = matrix3.getColumnPackedCopy();
                StdMet.arraycpy(this.k[n4], dArray12);
                StdMet.stam(dArray5, this.h * this.a[n4][n4], this.k[n4]);
                StdMet.arraysum(dArray11, dArray11, dArray5);
                dArray = this.f.f(this.told, dArray11);
                StdMet.mtam(dArray10, this.jacobian, dArray11);
                StdMet.arraydiff(dArray9, dArray, dArray10);
                StdMet.arraycpy(this.khat[n4 + 1], dArray9);
                ++n4;
            }
            StdMet.zero_out(dArray11);
            n3 = 0;
            while (n3 < this.s) {
                StdMet.stam(dArray5, this.b[n3], this.k[n3]);
                StdMet.stam(dArray6, this.bhat[n3], this.khat[n3]);
                StdMet.arraysum(dArray7, dArray5, dArray6);
                StdMet.arraysum(dArray11, dArray11, dArray7);
                ++n3;
            }
            StdMet.stam(dArray5, this.bhat[this.s], this.khat[this.s]);
            StdMet.arraysum(dArray11, dArray11, dArray5);
            StdMet.stam(dArray11, this.h, dArray11);
            StdMet.arraysum(this.uold, this.uold, dArray11);
            this.told += this.h;
            double d = StdMet.rmsNorm(this.uold);
            if (d != d) {
                System.out.println("unstable . . . aborting");
                oDEFileWriter.closeFile();
                return;
            }
            if (this.steps <= this.nPoints) {
                oDEFileWriter.writeToFile(this.told, this.uold);
            } else if (this.count % (this.steps / this.nPoints) == 0) {
                oDEFileWriter.writeToFile(this.told, this.uold);
            }
            if (this.stats_on) {
                System.out.println("t = " + this.told);
                if (!this.stats_intermediate) {
                    System.out.println("soln = ");
                    StdMet.arrayprt(this.uold);
                }
                System.out.println();
            }
            ++this.count;
        }
        System.out.println("done");
        System.out.println("final t = " + this.told);
        System.out.println("final soln  =");
        StdMet.arrayprt(this.uold);
        oDEFileWriter.writeToFile(this.told, this.uold);
        oDEFileWriter.closeFile();
    }
}

