/*
 * Decompiled with CFR 0.152.
 */
package odeToJava;

import odeToJava.modules.Btableau;
import odeToJava.modules.ODE;
import odeToJava.modules.ODEFileWriter;
import odeToJava.modules.Span;
import odeToJava.modules.StdMet;

public class Erk {
    private ODE f;
    private double t0;
    private double tf;
    private double[] x0;
    private double h;
    private int s;
    private boolean FSALenabled;
    private double[][] a;
    private double[] b;
    private double[] c;
    private int n;
    private String fileName;
    private boolean stats_on;
    private boolean stats_intermediate;
    private long steps;
    private long count;
    private double told;
    private boolean firstStep;
    private boolean lastStep;
    private boolean done;
    private double[] xold;
    private double[] xnew;
    private double[][] K;
    private int nPoints;

    public static void erk(ODE oDE, Span span, double[] dArray, double d, Btableau btableau, String string, String string2) {
        Erk erk = new Erk(oDE, span, dArray, d, btableau, string, string2);
        erk.setNPoints(1000);
        erk.routine();
    }

    public static void erk(ODE oDE, Span span, double[] dArray, double d, Btableau btableau, String string, String string2, int n) {
        Erk erk = new Erk(oDE, span, dArray, d, btableau, string, string2);
        erk.setNPoints(n);
        erk.routine();
    }

    public void setNPoints(int n) {
        this.nPoints = n;
    }

    public Erk(ODE oDE, Span span, double[] dArray, double d, Btableau btableau, String string, String string2) {
        if (!span.get_property()) {
            System.out.println("Improper span: times are out of order");
            System.exit(0);
        }
        this.f = oDE;
        this.t0 = span.get_t0();
        this.tf = span.get_tf();
        this.x0 = dArray;
        this.h = d;
        this.s = btableau.getbl();
        this.a = new double[btableau.getal()][btableau.getal()];
        this.b = new double[btableau.getbl()];
        this.c = new double[btableau.getcl()];
        StdMet.matrixcpy(this.a, btableau.get_a());
        StdMet.arraycpy(this.b, btableau.get_b());
        StdMet.arraycpy(this.c, btableau.get_c());
        this.FSALenabled = btableau.get_FSALenabled();
        if (d <= 0.0) {
            System.out.println("Stepsize must be greater than zero");
            System.exit(0);
        }
        if (this.tf - this.t0 < d) {
            System.out.println("Stepsize is larger than tspan");
            System.exit(0);
        }
        this.n = dArray.length;
        this.steps = (long)Math.floor((this.tf - this.t0) / d);
        if (string2.equals("Stats_On")) {
            this.stats_on = true;
            this.stats_intermediate = false;
        } else if (string2.equals("Stats_Intermediate")) {
            this.stats_on = true;
            this.stats_intermediate = true;
        } else if (string2.equals("Stats_Off")) {
            this.stats_on = false;
            this.stats_intermediate = false;
        } else {
            System.out.println("String parameter must be either: 1) \"Stats_On\" 2) \"Stats_Intermediate\" or 3) \"Stats_Off\"");
            System.exit(0);
        }
        this.fileName = string;
        double d2 = (this.tf - this.t0) / d;
        if (d2 != Math.floor(d2)) {
            System.out.println();
            System.out.println("integration interval is not integer multiple of stepsize:");
            System.out.println("problem will only be integrated to " + Math.floor(d2));
            System.out.println();
        }
        if (span.get_timesLength() > 0) {
            System.out.println();
            System.out.println("note that this solver does not do interpolation . . .");
            System.out.println();
        }
    }

    public void routine() {
        System.out.println();
        System.out.println("Begin Explicit Runge-Kutta Routine . . .");
        System.out.println();
        this.count = 0L;
        this.told = this.t0;
        this.xold = new double[this.n];
        this.xnew = new double[this.n];
        this.K = new double[this.s][this.n];
        double[] dArray = new double[this.n];
        double[] dArray2 = new double[this.n];
        double[] dArray3 = new double[this.n];
        double[] dArray4 = new double[this.n];
        double[] dArray5 = new double[this.n];
        StdMet.arraycpy(this.xold, this.x0);
        this.firstStep = true;
        this.lastStep = false;
        this.done = false;
        ODEFileWriter oDEFileWriter = new ODEFileWriter();
        oDEFileWriter.openFile(this.fileName);
        while (!this.done) {
            int n;
            if (this.lastStep) {
                this.done = true;
            }
            int n2 = 0;
            while (n2 < this.s) {
                n = 0;
                while (n < n2) {
                    StdMet.stam(dArray4, this.a[n2][n], this.K[n]);
                    StdMet.arraysum(dArray, dArray, dArray4);
                    ++n;
                }
                if (n2 != 0 || this.firstStep || !this.FSALenabled) {
                    StdMet.stam(dArray4, this.h, dArray);
                    StdMet.arraysum(dArray3, this.xold, dArray4);
                    dArray5 = this.f.f(this.told + this.h * this.c[n2], dArray3);
                    StdMet.arraycpy(this.K[n2], dArray5);
                    StdMet.zero_out(dArray);
                } else {
                    StdMet.arraycpy(this.K[0], this.K[this.s - 1]);
                }
                ++n2;
            }
            n = 0;
            while (n < this.s) {
                StdMet.stam(dArray4, this.h * this.b[n], this.K[n]);
                StdMet.arraysum(dArray2, dArray2, dArray4);
                ++n;
            }
            StdMet.arraysum(this.xnew, this.xold, dArray2);
            StdMet.zero_out(dArray2);
            double d = StdMet.rmsNorm(this.xnew);
            if (d != d) {
                System.out.println("unstable . . . aborting");
                oDEFileWriter.closeFile();
                return;
            }
            if (this.steps <= (long)this.nPoints) {
                oDEFileWriter.writeToFile(this.told + this.h, this.xnew);
            } else if (this.count % (this.steps / (long)this.nPoints) == 0L) {
                oDEFileWriter.writeToFile(this.told + this.h, this.xnew);
            }
            if (this.stats_on) {
                if (!this.stats_intermediate) {
                    System.out.println("count: " + this.count);
                }
                System.out.println("stepping: " + this.told + " -> " + (this.told + this.h));
                if (!this.stats_intermediate) {
                    System.out.println("solution = ");
                    StdMet.arrayprt(this.xnew);
                }
                System.out.println();
            }
            StdMet.arraycpy(this.xold, this.xnew);
            this.told += this.h;
            ++this.count;
            this.firstStep = false;
            if (!(this.told + 2.0 * this.h > this.tf)) continue;
            this.lastStep = true;
        }
        System.out.println("done");
        System.out.println("final t = " + this.told);
        System.out.println("final solution =");
        StdMet.arrayprt(this.xold);
        oDEFileWriter.writeToFile(this.told, this.xold);
        oDEFileWriter.closeFile();
    }
}

