      IMPLICIT         NONE
      INTEGER          NEQ
      PARAMETER        (NEQ = 3)
*
      INTEGER          NumStep, WHICH, INFO, IWORK(NEQ), I, J
      REAL*16          H, TF, X0(NEQ), XIN(NEQ), XOUT(NEQ), 
     $                 WORK(NEQ*(NEQ+1))
*
      EXTERNAL          LRZJEX, LRZFEX
*
*     Common block that defines Lorenz Strange Attractor.
*
      REAL*16 SIGMA, R, B
      COMMON /LORENZ/SIGMA, R, B
*
*                                       Ren-Cang Li, June 1, 1996
*                                       na.rcli@na-net.ornl.gov
*
      REAL*16 DT2(2), DT3(3), DT4(3), DT5(4), DT6(5),
     $                 DT7(5), DT8(8), DT9(9), DT10(9), DT11(16),
     $                 DT12(16), DT13(17), DT14(17), DT15(17)
C
C     Arrays to define various Palindromic Schemes.
C
      COMMON /DELTAS/DT2, DT3, DT4, DT5, DT6, DT7, DT8, DT9, DT10,
     $              DT11, DT12, DT13, DT14, DT15
      open(22, file='s3odr4',status='old')
      open(23, file='s5odr4',status='old')
      open(24, file='s5odr4a',status='old')
      open(25, file='s7odr6',status='old')
      open(26, file='s9odr6a',status='old')
      open(27, file='s9odr6b',status='old')
      open(28, file='s15odr8',status='old')
      open(29, file='s17odr8a',status='old')
      open(30, file='s17odr8b',status='old')
      open(31, file='s31odr10a',status='old')
      open(32, file='s31odr10b',status='old')
      open(33, file='s33odr10a',status='old')
      open(34, file='s33odr10b',status='old')
      open(35, file='s33odr10c',status='old')
      READ(22,*) DT2
      READ(23,*) DT3
      READ(24,*) DT4
      READ(25,*) DT5
      READ(26,*) DT6
      READ(27,*) DT7
      READ(28,*) DT8
      READ(29,*) DT9
      READ(30,*) DT10
      READ(31,*) DT11
      READ(32,*) DT12
      READ(33,*) DT13
      READ(34,*) DT14
      READ(35,*) DT15
*
*     Open a file for output.
*
      OPEN(10, FILE='Results',STATUS='NEW')
*
      SIGMA = 10.0Q0
      R     = 28.0Q0
      B     = 8.0Q0/3.0Q0
*
*     Correspondence between WHICH (input) and Schemes.
*
      print*, '------------------------------------------'
      print*, ' '
      print*, '        WHICH                 The Scheme  '
      print*, ' '
      print*, '          1                      s1odr2 '
      print*, '          2                      s3odr4 '
      print*, '          3                      s5odr4 '
      print*, '          4                      s5odr4a '
      print*, '          5                      s7odr6 '
      print*, '          6                      s9odr6a '
      print*, '          7                      s9odr6b '
      print*, '          8                     s15odr8 '
      print*, '          9                     s17odr8a '
      print*, '         10                     s17odr8b '
      print*, '         11                    s31odr10a '
      print*, '         12                    s31odr10b '
      print*, '         13                    s33odr10a '
      print*, '         14                    s33odr10b '
      print*, '         15                    s33odr10c '
      print*, ' '
      print*, '------------------------------------------'
      print*, ' Input WHICH '
      read*, WHICH
*
*     Initial Values
*
      X0(1) = 10.0Q0
      X0(2) =-20.0Q0
      X0(3) = 20.0Q0
*
*     Stepsize
*
      H = 0.01Q0
*
*     Integrate from T=0 to T=1.
*
      TF = 1.0Q0
*
*     The Number of Steps
*
*     Add 0.5 to TF/H is to bring NumStep to its correct value 100
*     in this case; otherwise it would be 99! What a annoyance.
*
      NumStep = TF/H+0.5Q0
      print*, ' NumStep = ', NumStep
*
      DO 5 J=1,NEQ
	    XIN(J) = X0(J)
 5    CONTINUE
*
      WRITE(10,*) XIN
      DO 20 I = 1, NumStep
	 CALL ALLS1(WHICH, LRZJEX, LRZFEX, NEQ, H, XIN, XOUT,
     $              WORK, IWORK, INFO)
	 DO 10 J=1,NEQ
	    XIN(J) = XOUT(J)
 10      CONTINUE
      WRITE(10,*) XIN
 20   CONTINUE
*
      STOP
      END
