(* pairs is the number of couples (rational function,costant) *)

pairs=2;

(* prec is the precision to be used in the computation *)

prec=16;

(* eps is the precision to be used in computing if two zeros are different
or not *)

eps=10^(-8);


(* rf is an array containing the rational functions;it ALWAYS starts from
index  1 *)
(* The following are the rational functions needed to compute the interval
 of stability of the Runge-Kutta-Nystrom methods (4.5) of the paper
  Van der Houwen P.J., Sommeijer B.P.
   Diagonally implicit Runge--Kutta Nystr\"om methods for oscillatory
   problems,  SIAM J. Num. Anal.26, 414--429, 1989. *)


rf[1] = (1 + 1.259209835039239*z + 0.4957809495292686*z^2 + 
    0.0625692535968167*z^3 + 0.00002755088740603178*z^4)/
  (1 + 0.6296049175196199*z + 0.09910058804122188*z^2)^2

rf[2] = (-4.*z - 3.703506006823626*z^2 - 0.4819551291758656*z^3 + 
    0.1996031381209796*z^4)/
  (1 + 0.6296049175196199*z + 0.09910058804122188*z^2)^2

(* cv is an array containing the constants values; it ALWAYS starts from
index 1 *)

cv[1]=1;
cv[2]=0;


(* printing = 1 enable plotting the graph of the intervals of stability;  *)
(* printing = 0 disable plotting the graph of the intervals of stability;  *)
(* if the computation ends up with an unlimited interval, the graph is not
plotted  *)
(* the intervals ranges are printed anyway  *)



printing = 0;

(* the height  is a value such that the line y = height is the last line
used when plotting *)
(* the stability intervals; of course may be that the user chooses a value
which is     *)
(* lower than the actual maximum of the rational functions
            *)

height = 0;

(* stepx is the step along the x axe to be used when plotting; an higher
value *)
(* will produce a faster but less accurate plot, a lower value *)
(* will produce a slower but more accurate plot *)

stepx = 0;

(* stepy is the step along the x axe to be used when plotting; an higher
value *)
(* will produce a faster but less accurate plot, a lower value  *)
(* will produce a slower but more accurate plot *)


stepy = 0;


