(* pairs is the number of couples (rational function,costant) *)

pairs=1;

(* prec is the precision to be used in the computation *)

prec=16;

(* eps is the precision to be used in computing if two zeros are different
or not *)

eps=10^(-16);


(* rf is an array containing the rational functions;it ALWAYS starts from
index  1 *)
(* rf[1] is the Pade' approximation [16,16] of the cosine function,
  with the substitution x^2->z  *)

rf[1]=
(233733954452448617511531023645533493577768960000 -
    114269935241792828593210896950499417562675200000*z +
    8454928015291387732074266532904505548380672000*z^2 -
    223633513824454113690920636167756712697600000*z^3 +
    2768703405521362258317703470942604295097600*z^4 -
    18009237589434518277575370108385658736000*z^5 +
    63724438950432108761721583505233450080*z^6 -
    117071511329303129411051152664754000*z^7 +
    88555612088268453352055067469523*z^8)/
  (233733954452448617511531023645533493577768960000 +
    2597041984431480162554614872267329226209280000*z +
    14534238655102083704447983807607929078272000*z^2 +
    54015113519445709765268899260608496384000*z^3 +
    147364442364155066776323466153142457600*z^4 +
    305938843489986501963241647984009600*z^5 +
    478745282533904215906776562810080*z^6 +
    524970227826487957177863426960*z^7 + 315071778950855885168016323*z^8);




(* cv is an array containing the constants values; it ALWAYS starts from
index 1 *)

cv[1]=1;

(* printing = 1 enable plotting the graph of the intervals of stability;  *)
(* printing = 0 disable plotting the graph of the intervals of stability;  *)
(* if the computation ends up with an unlimited interval, the graph is not
plotted  *)
(* the intervals ranges are printed anyway  *)



printing = 1;

(* the height  is a value such that the line y = height is the last line
used when plotting *)
(* the stability intervals; of course may be that the user chooses a value
which is     *)
(* lower than the actual maximum of the rational functions
            *)

height = 5;

(* stepx is the step along the x axe to be used when plotting; an higher
value *)
(* will produce a faster but less accurate plot, a lower value *)
(* will produce a slower but more accurate plot *)

stepx = 0.5;

(* stepy is the step along the x axe to be used when plotting; an higher
value *)
(* will produce a faster but less accurate plot, a lower value  *)
(* will produce a slower but more accurate plot *)


stepy = 0.5;



