
C**********************************
C--DRIVER FOR GAUSS2.F, FOR SEVERAL PROBLEMS GIVEN IN
C  2ORDER_PROBLEMS.F
C**********************************
C LINK DR_GAUSS2 GAUSS2 2ORDER_PROBLEMS
C
       PROGRAM GAUSS_2STAGE ! modified March 5, 2006

C by SEVERIANO GONZALEZ PINTO, DPTO. ANALISIS MATEMATICO
C UNIVERSITY OF LA LAGUNA, 38200, TENERIFE, CANARY ISLANDS, SPAIN.
C   email: spinto@ull.es
C This program  integrates 
C
C y''(t)=f(t,y), y(t0)=y0, y'(t0)=yp0, t \in [t0,tf], tf>t0.
C
C be means of  GAUSS2.F, which makes use of the 
C 2 stage Gauss method (the second order version)
C implemented in an standard variable step-size way and 
C by using a local error estimator which is asymptotically correct. 
C A Single-Newton iteration is employed for solving the stage values
C with  predictors of orders 1,2,3,4 (a variable order strategy).
C 
C The test problems are included in 2ORDER_PROBLEMS.F, which contains the 
C following routines: 
C   PRESENTA (to show the problems)
C   INICIAL (for the initial conditions of the problems)
C  FNC (to evaluate F(T,Y))
C  JACOB (to evaluate dF/dy(T,Y))
C  SOLUCION (gives the exact solution at some end-points tf)
C
C********************************
C AS AN EXAMPLE WE NEXT GIVE THE RESULTS OBTAINED WITH THE CODE 
C FOR  A FERMI-PASTA-ULAM PROBLEM TAKEN FROM (P.17-18 HAIRER-LUBICH-
C WANNER, GEOMETRIC NUMERICAL INTEGRATION, SPRINGER, 2002).
C WHEN EXECUTING THE PROGRAM WE HAVE ENTERED THE INPUTS 
C (IPROB=27, ATOL=RTOL=1.D-7, T_END=1.D2) 
C THE RESULTS WITH THE CODE WERE: 
C********************************
C
C          ier= 0 iprob=  27 ndim=   6 atol=0.10D-06 rtol=0.10D-06
C                ilin=0   CPUtime=  0.88
C    nss= 15741  nrest=    38  nrdiv=     0
C njac=      1  nlu=    133  nls= 151592  nder= 135816
C               Itergood/Accepted_steps= 3.80
C     IBAND(1)=  0  IBAND(2)=  0  IBAND(3)=  0
C          predictors=       40      298    12224     3178
C
C          GlobalError_y= 0.825D-03   GlobalError_yp= 0.309D-01
C
C          Error_y_Estim= 0.101D-02   Error_yp_estim= 0.413D-01
C
C  h0_proposed= 0.66452D-02   h0_accepted= 0.66452D-02   T= 0.1000000D+03
C
C          NUMERICAL SOLUTION AT T=.1000000D+03
C
C     k=   1  y=-0.7661454737473880D+00  yp=-0.4481739537838390D+00
C     k=   2  y= 0.2256124625116037D+00  yp=-0.1008202088266408D+01
C     k=   3  y=-0.2518726506569109D+00  yp= 0.3157720681786508D+00
C     k=   4  y= 0.9096804837869532D-02  yp= 0.6441244538981891D-01
C     k=   5  y=-0.4132900705427742D-02  yp=-0.8949865629443102D+00
C     k=   6  y=-0.1893473687176087D-01  yp= 0.2357491423109569D+00
C
C********************************
C
C WE COMMENT A BIT THE RESULTS:
C
C IER: IS AN ERROR FLAG (IER=0) MEANS A SUCCESSFUL INTEGRATION.
C IPROB: IS AN INTEGER THAT IDENTIFIES THE PROBLEM.
C NDIM: IS THE DIMENSION OF THE PROBLEM.
C ATOL,RTOL: ARE THE TOLERANCES.
C ILIN: (ILIN=0, MEANS A NONLINEAR PROBLEM, ILIN=1 FOR LINEAR PROBLEMS).
C CPUtime: IS THE CPUtime IN SECONDS ON AN INTEL-PENTIUM (800 MHz).
C NSS: NUMBER OF SUCCESSFUL STEPS.
C NREST: NUMBER OF STEPS REJECTED BY THE LOCAL ERROR ESTIMATOR.
C NDIV: NUMBER OF STEPS REJECTED BY  DIVERGENCE IN THE ITERATIONS.
C NJAC: NUMBER OF JACOBIAN MATRICES EVALUATED.
C NLU: NUMBER OF LU-FACTORIZATIONS.
C NLS: NUMBER OF FORWARD-BACKWARD LINEAR SYSTEMS SOLVED.
C NDER: NUMBER OF F-EVALUATIONS.
C ITERGOOD/ACCEPTED_STEPS: IS THE AVERAGE OF ITERATIONS WITH CONVERGENCE 
C REGARDING THE NUMBER OF ACCEPTED STEPS.
C IBAND(1)=0: MEANS FULL JACOBIAN. IBAND(1)=1, FOR BANDED JACOBIANS
C IBAND(2) AND IBAND(3) ARE THE NUMBER OF STRICT LOWER
C AND UPPER BANDS RESPECTIVELY (ONLY FOR BANDED JACOBIANS).
C
C PREDICTORS: GIVES THE NUMBER OF TIMES EACH PREDICTOR WAS AUTOMATICALLY 
C CHOSEN.  40  298 12224 3178  INDICATES THAT THE PREDICTOR 
C OF ORDER ONE WAS TAKEN 40 TIMES, THE PREDICTOR OF 
C ORDER TWO 298 TIMES AND SO ON.
C 
C GlobalError_Y, GlobalError_YP: ARE THE GLOBAL ERRORS (WHEN KNOWN) AT 
C THE END-POINT FOR THE Y-COMPONENT AND Y'-COMPONENT RESPECTIVELY.
C
C Error_y_Estim, Error_yp_estim: ARE THE ESTIMATED ERRORS AT T=T_END
C FOR THE Y-COMPONENT AND Y'-COMPONENTS RESPECTIVELY.
C THIS APPROACH IS BASED IN CARRYING OUT A SECOND INTEGRATION
C WITH TOLERANCES ATOL2=2*ATOL AND RTOL=2*RTOL, AND BY
C ASSUMING THAT THE GLOBAL ERRRORS (GE) SATISIFY:
C GE_Y(T)=K_1(T)*(TOL)^(4/5), GE_Y'(T)=K_2(T)*(TOL)^(4/5).
C
C H0_PROPOSED: IS THE INITIAL STEP-SIZE PROPOSED BY THE CODE.
C H0_ACCEPTED: IS THE INITIAL STEP-SIZE ACCEPTED BY THE CODE.
C T: IS THE GRID-POINT WHERE THE NUMERICAL SOLUTION IS DELIVERED.
C K, Y, YP: ARE RESPECTIVELY THE COMPONENT, 
C THE Y-NUMERICAL SOLUTION AND THE Y'-NUMERICAL SOLUTION 
C AT THE POINT T.
***************************
C
C BY DEFINING THE ARRAYS AND ITS DIMENSIONS

      PARAMETER(ID=1000,LDIWORK=20+ID,LDWORK=100000,NSTEPMAX=40000)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION Y0(ID),YP0(ID),Y(ID),YP(ID),WORK(LDWORK)
      DIMENSION IWORK(LDIWORK),IBAND(3)
      DIMENSION SOL(ID),SOLP(ID),YY(ID),YYP(ID)
C WORK( ) IS A WORK VECTOR TO STORE REAL VARIABLES
C IWORK( ) IS A WORK VECTOR FOR INTEGERS
C NSTEPMAX IS THE MAXIMUM NUMBER OF STEPS TO BE TRIED

      CHARACTER*12 FICH1 !FILE FOR WRITING RESULTS 
      CHARACTER COMMENT*45,AUXI*7,AUXI2*14
      EXTERNAL FNC,JACOB !TO COMPUTE F(T,Y) AND ITS JACOBIAN MATRIX

      COMMON /BLOK1/IPROB !IPROB IS AN INTEGER  TO IDENTIFY THE PROBLEM

      DATA WORK/LDWORK*0.D0/
      DATA IWORK/LDIWORK*0/

C TO SHOW THE PROBLEMS
      CALL PRESENTA
      PRINT*, ' '
      PRINT*,'Enter the number which identifies the problem, IPROB=?'
      READ*,IPROB
      PRINT*,' '

C ENTERING THE TOLERANCES AND THE FILE FOR WRITING
      PRINT*,'ATOL=?, RTOL=?'
      READ*, ATOL,RTOL

      PRINT*,'Introduce the name of a file for writing results, File=?'
      READ(*,'(A)') FICH1

C ENTERING THE INITIAL CONDITIONS ASSOCIATED TO EACH PROBLEM
      CALL INICIAL (ID,NDIM,T0,TF,Y0,YP0,IBAND,ILIN)
      PRINT*,'This is the proposed T_end=',TF 
      PRINT*,'Enter  T_end=?' ! CONFIRMING END-POINT
      READ*,TF

      OPEN (1,file=FICH1)

C COMPUTING TOLERANCES TO ESTIMATE THE GLOBAL ERRORS (FIRST INTEGRATION) 
      Write(*,*) 'atol=',ATOL, '  rtol=',RTOL
      ATOL2=2*ATOL 
      RTOL2=2*RTOL
      IER=0 !ERROR FLAGS
      IER2=0

C LOOP FOR THE TWO INTEGRATIONS 
      DO ICONTA=1,2 
          t=t0 !initial point
         if (iconta.eq.1) then
               do k=1,ndim ! initial values for the first integration
                    YY(K)=Y0(K)
                    YYP(K)=YP0(K)
               enddo
         else 
               do k=1,ndim ! initial values for the required integration
                   Y(K)=Y0(K)
                   YP(K)=YP0(K)
               enddo
         endif

         if (iconta.eq.1) then
C THE  INTEGRATION FOR TOLERANCES: ATOL2, RTOL2 
               call gauss2 (NDIM,T,TF,YY,YYP,ATOL2,RTOL2,IER2,NSTEPMAX,
     # ILIN,IWORK,WORK,LDIWORK,LDWORK,IBAND,FNC,JACOB)
               IF (IER2.LT.0) THEN
                             AUXI2='NOT ESTIMATED'
                             GOTO 10
              ENDIF

         else 
               time=secnds(0.0d0) ! For CPU-time
               call gauss2 (NDIM,T,TF,Y,YP,ATOL,RTOL,IER,NSTEPMAX,
     # ILIN,IWORK,WORK,LDIWORK,LDWORK,IBAND,FNC,JACOB)
                time=secnds(0.0d0)-time
         endif

C BY CHECKING ERROR FLAGS FOR THE REQUIRED INTEGRATION
          if (ier.lt. 0) then !writing results for unsuccessful integ.
           print*, ' '
           print*, '       Unsuccessful Integration'
           print*, ' '
           write(1,100)  ier,iprob,ndim,atol,rtol,ilin,' CPUtime=',time
           write (1,200) t,'y(1)=',y(1),'yp(1)=',yp(1)
              if (ier.eq.-3) then 
                 COMMENT='TOO MUCH STEPS WITHOUT REACHING END-POINT!!'
              elseif (ier.eq.-2) then 
                  COMMENT='TOO SMALL STEP-SIZE!!'  
               endif
            write(1,150) COMMENT
             stop
          endif

C COMPUTING GLOBAL ERRORS AT T_END=TF, WHEN THEY ARE AVAILABLE
              CALL SOLUCION (ID,NDIM,TF,SOL,SOLP,AUXI)
              xMEG= 0.D0
              xMEGP=0.D0
             DO  K=1,NDIM
               xmeg=xmeg+(SOL(K)-y(K))**2
               xmegp=xmegp+(SOLP(K)-yp(K))**2
             ENDDO 
             xmeg=sqrt(xmeg/ndim)
             xmegp=sqrt(xmegp/ndim)

C COMPUTING ESTIMATED GLOBAL ERRORS
              xMEGEST= 0.D0
              xMEGPEST=0.D0
              DO  K=1,NDIM
                    xmegEST=xmegEST+(YY(K)-y(K))**2
                    xmegpEST=xmegpEST+(YYP(K)-yp(K))**2
              ENDDO 
              cte=1.d0/(2.d0**0.8 -1)
              xmegEST=cte*sqrt(xmegEST/ndim)
              xmegpEST=cte*sqrt(xmegpEST/ndim)
10       CONTINUE
      ENDDO !LOOP ICONTA
C WRITING STATISTICS 
      write(1,100)  ier,iprob,ndim,atol,rtol,ilin,' CPUtime=',time
      write (1,800) 'nss=',iwork(1),'nrest=',iwork(2),'nrdiv=',iwork(3)
      write(1,300)  (IWORK(J),J=4,7) 
      write(1,350) 1.*IWORK(12)/IWORK(1)
      write(1,370) 'IBAND(1)=',IBAND(1),'IBAND(2)=',IBAND(2),
     # 'IBAND(3)=',IBAND(3)
      write(1,400) (IWORK(J),J=8,11)
      IF (AUXI.NE.'UNKNOWN') THEN
           write(1,500) XMEG,XMEGP
      ELSE
           write(1,700) AUXI,AUXI
      ENDIF 
      IF (IER2.LT.0) THEN
              WRITE(1,780) AUXI2,AUXI2
      ELSE
             WRITE(1,750) XMEGEST,XMEGPEST
      ENDIF
      write(1,550) 'h0_proposed=',WORK(1),'h0_accepted=',WORK(2),'T=',T

C WRITING THE NUMERICAL SOLUTION AT T_END
      WRITE(1,'(10X,a,D12.7,/)') 'NUMERICAL SOLUTION AT T=',T
      do k=1,ndim
          write(1,600) k, y(k),yp(k)
       enddo

      close(1)
C*********
C FORMATS 
100   format(10x,'ier=',i2,1x,'iprob=',i4,' ndim=',i4,' atol=',d8.2,
     # ' rtol=',d8.2,/, 15x, ' ilin=',i1,2x,A,F6.2)
150   format (1x,/,10x,A)
200   format(1x,'t=',d10.3,2(2x,A,d17.10))
300   format(1x,'njac=',i7,2x,'nlu=',i7,2x,'nls=',i7,2x,'nder=',i7)
350   format (15x, 'Itergood/Accepted_steps=',f5.2)
370   format (5x,3(a,i3,2x))
400   format (10x,'predictors=', 4(2x,i7))
500   format (/,10x,'GlobalError_y=',d10.3,3x,'GlobalError_yp=',d10.3)
550   format(t3,2(a,d12.5,3x),A,D14.7,/)
600   format (5x,'k=',i4,2x,'y=',d23.16,2x,'yp=',d23.16)
700   format (/,10x,'GlobalError_y=',A,3x,'GlobalError_yp=',A)
750   format(/,10x,'Error_y_Estim=',d10.3,3x,'Error_yp_estim=',d10.3,/)
780   format (/,10x,'Error_y_Estim=',A,3x,'Error_yp_estim=',A,/)
800   format (t5,3(a,i6,2x))
      stop
      end
********************************* 
