
C***************************************************
C THIS IS A COLLECTION OF SECOND ORDER DIFFERENTIAL SYSTEMS 
C
C     Y''(T)=F(T,Y), Y(T0)=Y0, Y'(T0)=YP0, T \IN [T0,TF], TF>T0
C 
C BY SEVERIANO GONZALEZ PINTO AND ROGEL ROJAS BELLO, JUNE 2005.
C	DPTO. ANALISIS MATEMATICO, UNIVERSITY OF LA LAGUNA
C		38208, LA LAGUNA, TENERIFE, CANARY ISLANDS, SPAIN
C	EMAILS: SPINTO@ULL.ES,    RRROJAS@ULL.ES
C
C THE PROBLEMS ARE COLLECTED IN 5 SUBROUTINES 
C
C 1) SUBROUTINE PRESENTA 
C        SHOWS THE PROBLEMS AND THE REFERENCES FOR A FEW OF THEM
C
C 2) SUBROUTINE INICIAL (ID,NDIM,T0,TF,Y0,YP0,IBAND,ILIN)
C        GIVES THE INITIAL CONDITIONS FOR THE PROBLEMS
C
C 3) SUBROUTINE FNC (N,T,Y,F)
C        EVALUATES THE FUNCTION F(T,Y)
C
C 4) SUBROUTINE JACOB (ND,N,T,Y,YJAC,IBAND)
C        EVALUATES THE JACOBIAN MATRIX dF(T,Y)/dY
C
C 5) SUBROUTINE SOLUCION (ID,NDIM,T,Y,YP,AUXI)
C        GIVES THE EXACT SOLUTION AT T FOR SOME PROBLEMS
C
C********************************************
        SUBROUTINE PRESENTA

C SUBROUTINE GIVING A BRIEF INFORMATION ABOUT THE  PROBLEMS 
C y_{tt} below means second derivative regarding time.
      PRINT*,' Below, y_{tt} means second derivative regarding time'
      PRINT*,'IPROB=1: y_{tt}(t)=-1.E10*y, y(0)=1.E-8, y_t(0)=0'
      PRINT*,'IPROB=2: y_{tt}(t)=-1.E10*y, y(0)=0, y_t(0)=1.E-3'
      PRINT*,'IPROB=12: y_{tt}(t)+sinh(y)=0,y(0)=1,y_{t}(0)=0, taken'
      PRINT*,' from Gladwell-Thomas, IMA J Numer Anal, 10, p.201 (1990)'
      PRINT*,'IPROB=13 (Banded Jacobian), 130 (Full Jacobian) for:'
      PRINT*,' y_{tt}(t)=-200y_{xxxx} discret. via MOL, NDIM=90 lines'
      PRINT*,' from Howen-Sommeijer SIAM J.Numer Anal,26(2) p.427(1989)'
      PRINT*,'IPROB=16: Moderately stiff NDIM=2, taken'
      PRINT*,' from Gladwell-Thomas, IMA J Numer Anal, 10, p.201 (1990)'
      PRINT*,'IPROB=17: The two-body Kepler problem, eccentricity=0.5'
      PRINT*, ' '
      PRINT*,'IPROB=21: Outer solar system taken from p.11 in'
      PRINT*,' Hairer-Lubich-Wanner, Geom. Numer. Integrat, Springer'
      PRINT*,'IPROB=27: A Fermi-Pasta-Ulam model of NDIM=6, taken from'
      PRINT*,' Hairer-Lub-Wanner, p.17, Geometric Numer Integ, Springer'
      PRINT*,'IPROB=30:Wave Equation with friction, NDIM=10 taken from'
      PRINT*,' Houwen-Sommeijer, SIAM J.Numer Anal,24(3) p.610 (1987)'
      PRINT*,'IPROB=32:y_{tt}+(1+y^2)y_{xxxx}-(y/4)^3=0, x\in[-4Pi,4Pi]'
      PRINT*,' discretized in space via Method of Lines, NDIM=100'
      PRINT*,' with exact solution y(x,t)=cos(t/16)*cos(x/4)'
      RETURN
      END

*******************************************************************
C SUBROUTINE FOR THE INITIAL CONDITIONS OF THE PROBLEMS

      SUBROUTINE INICIAL (ID,NDIM,T0,TF,Y0,YP0,IBAND,ILIN)

C INPUT ARGUMENTS
C     IPROB: WHICH ENTER IN COMMON /BLOCK1/IPROB

C     OUTPUT ARGUMENTS
C         ID: IS THE MAXIMUM DIMENSION ALLOWED FOR THE PROBLEMS
C         NDIM: GIVES THE ACTUAL DIMENSION OF THE PROBLEM
C         T0,TF: INITIAL AND END POINTS OF INTEGRATION (TF>T0)
C         Y0(ID): VECTOR STORING THE INITIAL CONDITIONS FOR Y(T)
C         YP0(ID): VECTOR STORING THE INITIAL CONDITIONS FOR Y'(T)
C         IBAND(3): IS AN ARRAY OF DIMENSION 3. IBAND(1) INDICATES IF 
C         THE JACOBIAN MATRIX IS FULL (IBAND(1)=0) OR BANDED 
C               (IBAND(1)=1). IBAND(2) AND IBAND(3) GIVE RESPECTIVELY THE 
C               NUMBER OF STRICT LOWER BANDS AND UPPER BANDS FOR 
C               BANDED JACOBIANS ONLY
C              (FOR FULL JACOBIANS  IBAND(J),J=2,3 ARE NOT NEEDED)
C         ILIN=1 INDICATES THAT THE PROBLEM IS LINEAR F(T,Y)=J Y + G(T)
C         ILIN=0 SAYS THAT THE PROBLEM IS NONLINEAR

      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION Y0(ID),YP0(ID),IBAND(3)
      COMMON /BLOK1/IPROB


**********************
      IBAND(1)=0 ! full Jacobians
      ILIN=0 ! nonlinear problems

      IF (IPROB .EQ. 1) THEN
            ILIN=1
            T0 = 0.D0
            TF = 6.D0
            NDIM = 1
            Y0(1) = 1.D-8
            YP0(1) = 0.D0

      ELSE IF (IPROB .EQ. 2) THEN
               ILIN=1
               T0 = 0.D0
               TF = 6.D0
               NDIM = 1
               Y0(1) = 0.D0
               YP0(1) = 1.D-3

      ELSEIF(IPROB.EQ.12) THEN
                NDIM=1
               T0=0.D0
               TF=6.D0
               Y0(1) =1.D0
               YP0(1)=0.D0

        ELSE IF (IPROB .EQ. 13) THEN
               T0 = 0.D0
               TF = 1.D4
               NDIM = 90
               ILIN=1
               IBAND(1)=1
               IBAND(2)=2
               IBAND(3)=2
               cte = 0.852320012872625828D-1

              DO I=1,NDIM
                 X=cte*I*22.D0/NDIM
                Y0(I) =0.1D0*(Cosh(X)-Cos(X)-
     #                 0.73409551375891315D0*(Sinh(X)-Sin(X)))
                YP0(I) =  0.D0
              ENDDO

      ELSE IF (IPROB .EQ. 130) THEN !It is IPROB=13 with full Jacobian
              T0 = 0.D0
              TF = 1.D4
              NDIM = 90
              ILIN=1
            cte = 0.852320012872625828D-1
             DO I=1,NDIM
                 X=cte*I*22.D0/NDIM
                 Y0(I) =0.1D0*(Cosh(X)-Cos(X)-
     #               0.73409551375891315D0*(Sinh(X)-Sin(X)))
                 YP0(I) =  0.D0
             ENDDO

      ELSEIF(IPROB.EQ.16) THEN
               NDIM=2
              T0=0.D0
              TF=6.D0
              Y0(1) = 1.D0
              Y0(2) = 1.D-8
              YP0(1) = 0.D0
              YP0(2) = 0.D0


      ELSEIF(IPROB.EQ.17) THEN
                NDIM=2
               T0=0.D0
               TF=20.D0
               XLANDA=0.5D0
               Y0(1) =  1.D0-XLANDA
               Y0(2) =  0.D0
               YP0(1) = 0.D0
               YP0(2) = SQRT((1.d0+XLANDA)/(1.d0-XLANDA))

      ELSE IF (IPROB .EQ. 21) THEN
                T0 = 0.D0
                TF = 5.d5
                NDIM = 18
                Y0(1)=-3.5023653D0
                Y0(2)=-3.8169847D0
                Y0(3)=-1.5507963D0
                Y0(4)=9.0755314D0
                Y0(5)=-3.0458353D0
                Y0(6)=-1.6483708D0
                Y0(7)=8.3101420D0
                Y0(8)=-16.2901086D0
                Y0(9)=-7.2521278D0
                Y0(10)=11.4707666D0
                Y0(11)=-25.7294829D0
               Y0(12)=-10.8169456D0
               Y0(13)=-15.5387357D0
               Y0(14)=-25.2225594D0
               Y0(15)=-3.1902382D0
               Y0(16)=0.0D0
               Y0(17)=0.0D0
               Y0(18)=0.0D0

               YP0(1)=0.00565429D0
               YP0(2)=-0.00412490D0
               YP0(3)=-0.00190589D0
               YP0(4)=0.00168318D0
               YP0(5)=0.00483525D0
               YP0(6)=0.00192462D0
               YP0(7)=0.00354178D0
               YP0(8)=0.00137102D0
               YP0(9)=0.00055029D0
               YP0(10)=0.00288930D0
               YP0(11)=0.00114527D0
               YP0(12)=0.00039677D0
               YP0(13)=0.00276725D0
               YP0(14)=-0.00170702D0
               YP0(15)=-0.00136504D0
               YP0(16)=0.0D0
               YP0(17)=0.0D0
               YP0(18)=0.0D0

        ELSE IF (IPROB .EQ. 27) THEN
                T0 = 0.0D0
                TF = 1.d2
                NDIM = 6
                Y0(1) = 1.D0
                Y0(2) = 0.D0
                Y0(3) = 0.D0
                Y0(4) = 2.D-2
                Y0(5) = 0.D0
                Y0(6) = 0.D0

                YP0(1) = 1.D0
                YP0(2) = 0.D0
                YP0(3) = 0.D0
                YP0(4) = 1.D0
                YP0(5) = 0.D0
                YP0(6) = 0.D0

      ELSE IF (IPROB .EQ. 30) THEN
                 NDIM=10
                dx =100.D0/(NDIM-1.D0)
                PI=4*ATAN(1.D0)
                T0 = 0.D0
                TF = 1.D2

              DO  I = 1,NDIM
                 X=PI*(I-1)*DX/100
                 Y0(I)=SIN(X)
                 YP0(I)=-(PI/100.D0)*SQRT(98.1D0*(2.D0+Cos(2*X)))*Cos(X)
              ENDDO

 
      ELSE IF (IPROB .EQ. 32) THEN
             T0 = 0.D0
             TF = 2.d2
             NDIM=100
             pi=acos(-1.d0)
            dx=8.d0*pi/NDIM
            DO I = 1,NDIM
                  x=-4*pi+i*dx
                 Y0(I)=COS(x/4)
                 YP0(I)=0.D0
             ENDDO

      ENDIF

*******
      RETURN
      END

*******************************************************************
C SUBROUTINE FOR THE EVALUATION OF THE SECOND DERIVATIVE F(T,Y)

      SUBROUTINE FNC (N,T,Y,F)

C INPUT ARGUMENTS
C       IPROB: IDENTIFIES THE PROBLEM (ENTERING IN COMMON)
C       N: DIMENSION OF THE PROBLEM
C       T: T-POINT 
C       Y(N): VECTOR FOR THE Y-COMPONENT

C OUTPUT ARGUMENTS 
C       F(N): STORES THE VALUE OF F(T,Y) 

      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION Y(N),F(N)
      DIMENSION XM(6),D(6,6)
      COMMON /BLOK1/IPROB


**********
      IF (IPROB .EQ. 1) THEN
          F(1) = -1.d10*Y(1)

      ELSE IF (IPROB .EQ. 2) THEN
          F(1) = -1.d10*Y(1)

      ELSEIF(IPROB.EQ.12) THEN
          F(1)=-SINH(Y(1))

      ELSE IF ((IPROB .EQ. 13).or.(IPROB.EQ.130) ) THEN
            cte =-200.D0/((22.D0/N)**4)
            F(1)= cte*(7.D0*Y(1)-4.D0*Y(2)+ Y(3))
            F(2)= cte*(-4.D0*Y(1)+6.D0*Y(2)-4.D0*Y(3)+Y(4))

            DO I=3,N-2
             F(I)=cte*(Y(I-2)-4.D0*Y(I-1)+6.D0*Y(I)-4.D0*Y(I+1)+Y(I+2))
            ENDDO

            F(N-1)=cte*(Y(N-3)-4.D0*Y(N-2)+5.D0*Y(N-1)-2.D0*Y(N))
            F(N)=cte*(2.D0*Y(N-2)-4.D0*Y(N-1)+2.D0*Y(N))

      ELSEIF(IPROB.EQ.16) THEN
           F(1)=-(EXP(Y(1)+Y(2))-EXP(-(Y(1)+Y(2))))/2.D0
           F(2)=-1.D4*Y(2)

      ELSEIF(IPROB.EQ.17) THEN
          F(1)=-Y(1)/((SQRT(Y(1)**2+Y(2)**2))**3)
          F(2)=-Y(2)/((SQRT(Y(1)**2+Y(2)**2))**3)

      ELSEIF(IPROB.EQ.21) THEN
          AK=2.95912208286D-4
          XM(1)=0.000954786104043D0
          XM(2)=0.000285583733151D0
          XM(3)=0.0000437273164546D0
          XM(4)=0.0000517759138449D0
          XM(5)=1.0D0/1.3D8
          XM(6)=1.00000597682D0
          DO I=1,5
            I1=3*(I-1)+1
            DO J=I+1,6
                J1=3*(J-1)+1
               D(I,J)=(SQRT((Y(I1)-Y(J1))**2+(Y(I1+1)-Y(J1+1))**2+
     #              (Y(I1+2)-Y(J1+2))**2))**3
               D(J,I)=D(I,J)
            END DO
         END DO

         DO I=1,6
            I1=3*(I-1)+1
            F(I1)=0.0D0
            F(I1+1)=0.0D0
            F(I1+2)=0.0D0
            DO J=1,6
                     IF (J.NE.I) THEN
                          J1=3*(J-1)+1
                         F(I1)=F(I1)+XM(J)*(Y(J1)-Y(I1))/D(I,J)
                         F(I1+1)=F(I1+1)+XM(J)*(Y(J1+1)-Y(I1+1))/D(I,J)
                         F(I1+2)=F(I1+2)+XM(J)*(Y(J1+2)-Y(I1+2))/D(I,J)
                     END IF
            END DO
            F(I1)=AK*F(I1)
            F(I1+1)=AK*F(I1+1)
            F(I1+2)=AK*F(I1+2)
         END DO


      ELSEIF(IPROB.EQ.27) THEN
          F(1)= -(Y(1)-Y(4))**3+(Y(2)-Y(5)-Y(1)-Y(4))**3
          F(2)= -(Y(2)-Y(5)-Y(1)-Y(4))**3+(Y(3)-Y(6)-Y(2)-Y(5))**3
          F(3)= -(Y(3)-Y(6)-Y(2)-Y(5))**3-(Y(3)+Y(6))**3
          F(4)= -2500.D0*Y(4)+(Y(1)-Y(4))**3+(Y(2)-Y(5)-Y(1)-Y(4))**3
          F(5)= -2500.D0*Y(5)+(Y(2)-Y(5)-Y(1)-Y(4))**3
     +           +(Y(3)-Y(6)-Y(2)-Y(5))**3
          F(6)= -2500.D0*Y(6)+(Y(3)-Y(6)-Y(2)-Y(5))**3-(Y(3)+Y(6))**3


      ELSE IF (IPROB .EQ. 30) THEN
            dx =100.D0/(N-1.D0)
            cte =98.1D0/(dx**2)
            PI=4*ATAN(1.D0)

            F(1)=cte*3*(-(415.D0/72.D0)*Y(1)+8.D0*Y(2)
     +       -3.D0*Y(3)+(8.D0/9.D0)*Y(4)-0.125D0*Y(5))+
     +          4.27716000000000056D-9*Y(1)**3

            F(2)=cte*(2.D0+Cos(PI*dx/50.D0))*((257.D0/144.D0)*Y(1)-
     +            (10.D0/3.D0)*Y(2)+(7.D0/4.D0)*Y(3)-(2.D0/9.D0)*Y(4)+
     +     (1.D0/48.D0)*Y(5))+
     +         (3.84944400000000017D-8/((2.D0+COS(PI*dx/50.D0))**2))
     +             *Y(2)**3  

          DO I=3,N-2

           F(I)=cte*(2.D0+Cos(PI*(I-1)*dx/50.D0))*(-(1.D0/12.D0)*Y(I-2)
     +         +(4.D0/3.D0)*Y(I-1)
     +         -(5.D0/2.D0)*Y(I)
     +         +(4.D0/3.D0)*Y(I+1)
     +         -(1.D0/12.D0)*Y(I+2))+
     +        (3.84944400000000017D-8/((2.D0+COS(PI*(I-1)*dx/50.D0))
     +             **2))*Y(I)**3 

           ENDDO


           F(N-1)=cte*(2.D0+Cos(PI*(N-2)*dx/50.D0))*((1.D0/48.D0)*Y(N-4)
     +    -(2.D0/9.D0)*Y(N-3)+(7.D0/4.D0)*Y(N-2)-(10.D0/3.D0)*Y(N-1)
     +           +(257.D0/144.D0)*Y(N))+
     +        (3.84944400000000017D-8/((2.D0+COS(PI*(N-2)*dx/50.D0))
     +             **2))*Y(N-1)**3 

             F(N)=cte*(2.D0+Cos(PI*(N-1)*dx/50.D0))*(-0.125D0*Y(N-4)+
     +       (8.D0/9.D0)*Y(N-3)-3.D0*Y(N-2)+8.D0*Y(N-1)-
     +           (415.D0/72.D0)*Y(N))+
     +       (3.84944400000000017D-8/((2.D0+COS(PI*(N-1)*dx/50.D0))
     +             **2))*Y(N)**3 


      ELSE IF (IPROB .EQ. 32 ) THEN
          pi=acos(-1.d0)
         dx=8.d0*pi/N
         DX=(1.D0/DX)**4
         cte=0.25D0**4

       DO I = 3,N-2
       F(I)=DX*(1.D0+Y(I)**2)*(-Y(I-2)+4*Y(I-1)-6*Y(I)+4*Y(I+1)-Y(I+2))+
     # cte*Y(I)**3
       ENDDO	 
        F(2)=DX*(1.D0+Y(2)**2)*(-Y(N)+4*Y(1)-6*Y(2)+4*Y(3)-Y(4))+
     #  cte*Y(2)**3
        F(1)=DX*(1.D0+Y(1)**2)*(-Y(N-1)+4*Y(N)-6*Y(1)+4*Y(2)-Y(3))+
     #   cte*Y(1)**3
      F(N-1)=DX*(1.D0+Y(N-1)**2)*(-Y(N-3)+4*Y(N-2)-6*Y(N-1)+4*Y(N)-Y(1))
     #   + cte*Y(N-1)**3
        F(N)=DX*(1.D0+Y(N)**2)*(-Y(N-2)+4*Y(N-1)-6*Y(N)+4*Y(1)-Y(2))+
     #   cte*Y(N)**3

      ENDIF

**********
      RETURN
      END

*******************************************************************
*******************************************************************
C THIS ROUTINE IS FOR EVALUATING THE JACOBIAN MATRIX dF/dY(T,Y)

      SUBROUTINE JACOB (ND,N,T,Y,YJAC,IBAND)
C
C INPUT ARGUMENTS
C    IPROB: IDENTIFIES THE PROBLEM (ENTERING IN COMMON)
C    ND,N: DIMENSIONS FOR YJAC MATRIX
C    T: GRID-POINT
C    Y(N): VECTOR Y(T)
C    IBAND(3): ARRAY USED TO KNOW IF THE JACOBIAN MUST BE STORED 
C                 AS A FULL JACOBIAN  OR A BANDED JACOBIAN
C OUTPUT ARGUMENTS
C    YJAC(ND,N): ARRAY STORING THE JACOBIAN MATRIX
C    FOR FULL JACOBIANS IBAND(1)=0 AND FOR BANDED JACOBIANS IBAND(1)=1. 
C    IF IBAND(1)=0, THEN 
C         YJAC(I,J) STORES PARTIAL F(I)/PARTIAL Y(J), I=1,..,N, J=1,..,N.
C
C    IF IBAND(1)=1, THE JACOBIAN IS SUPPOSED TO BE BANDED WITH 
C            IBAND(2) LOWER DIAGONALS AND IBAND(3) UPPER DIAGONALS
C                  (THE MAIN DIAGONAL IS NOT COUNTED). 
C         FOR BANDED MATRICES THE DATA ARE ENTERED IN THE FOLLOWING FORM
C        YJAC(I-J+IBAND(3)+1,J)= PARTIAL F(I) / PARTIAL Y(J), FOR 
C          I=1,..,MDD; J=1,...,N, WITH MDD=IBAND(2)+IBAND(3)+1

      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER(ID=20)

      DIMENSION Y(N),YJAC(ND,N),IBAND(3)
      DIMENSION FAUX(ID),F(ID),Z(ID) !Auxiliary arrays for some problems

      COMMON /BLOK1/IPROB
*****************

      IF (IPROB .EQ. 1) THEN
           YJAC(1,1) = -1.D10

      ELSE IF (IPROB .EQ. 2) THEN
         YJAC(1,1) = -1.D10

      ELSEIF(IPROB.EQ.12) THEN
         YJAC(1,1)=-COSH(Y(1))

      ELSE IF (IPROB .EQ. 13) THEN !Banded Jacobian 
           cte =-200.D0/((22.D0/N)**4)
           CT1=2*CTE
           CT2=-4*CTE
           CT3=6*CTE

           DO I=3,N-1
              YJAC(5,I-2)=CTE
           ENDDO
           YJAC(5,N-2)=CT1

           DO I=2,N
             YJAC(4,I-1)=CT2
           ENDDO

           DO I=2,N-2
              YJAC(3,I)=CT3
           ENDDO
           YJAC(3,1)=7*CTE
           YJAC(3,N-1)=5*CTE
           YJAC(3,N)=CT1

           DO I=1,N-2
              YJAC(2,I+1)=CT2
           ENDDO
           YJAC(2,N)=-CT1

           DO I=1,N-2
              YJAC(1,I+2)=CTE
           ENDDO

      ELSE IF (IPROB .EQ. 130) THEN

          cte =-200.D0/((22.D0/N)**4)
          CT1=2*CTE
          CT2=-4*CTE
          CT3=6*CTE

          YJAC(1,1) = cte*7.D0
          YJAC(1,2) = CT2
          YJAC(1,3) = cte

          YJAC(2,1) =  CT2
          YJAC(2,2) =  CT3
          YJAC(2,3) =  CT2
          YJAC(2,4) =  cte

          DO I = 3,N-2
             YJAC(I,I-2) = cte
             YJAC(I,I-1) = CT2
             YJAC(I,I)   = CT3
             YJAC(I,I+1) = CT2
             YJAC(I,I+2) = cte
          ENDDO

          YJAC(N-1,N-3) = cte
          YJAC(N-1,N-2) = CT2
          YJAC(N-1,N-1) = cte*5.D0
          YJAC(N-1,N) =   -CT1

          YJAC(N,N-2) = CT1
          YJAC(N,N-1) = CT2
          YJAC(N,N) =   CT1


      ELSEIF(IPROB.EQ.16) THEN
          YJAC(1,1)=-COSH(Y(1)+Y(2))
          YJAC(1,2)=YJAC(1,1)
          YJAC(2,1)=0.D0
          YJAC(2,2)=-1.D4

      ELSEIF(IPROB.EQ.17) THEN
         YJAC(1,1)=(2.d0*Y(1)**2-Y(2)**2)/((SQRT(Y(1)**2+Y(2)**2))**5)
         YJAC(1,2)=(3.d0*Y(1)*Y(2))/((SQRT(Y(1)**2+Y(2)**2))**5)
         YJAC(2,1)=(3.d0*Y(1)*Y(2))/((SQRT(Y(1)**2+Y(2)**2))**5)
         YJAC(2,2)=(2.d0*Y(2)**2-Y(1)**2)/((SQRT(Y(1)**2+Y(2)**2))**5)

      ELSEIF(IPROB.EQ.21) THEN
        cte=1.d-6
        do k=1,18
           z(k)=y(k)
         enddo
         call FNC (18,T,Y,F)
         do i=1,18
             Z(I)=Y(I)+CTE
             call FNC (18,T,Z,FAUX)
            do k=1,18
               yjac(i,k)=(faux(k)-f(k))/cte
            enddo
            z(i)=y(i)
          enddo

      ELSE IF (IPROB .EQ. 27) THEN
         cte  = (Y(1)-Y(4))**2
         cte4 = (Y(2)-Y(5)-Y(1)-Y(4))**2
         cte5 = (Y(3)-Y(6)-Y(2)-Y(5))**2
         c2   = (Y(3)+Y(6))**2
         YJAC(1,1) = -3.D0*cte-3.D0*cte4
         YJAC(1,2) = 3.D0*cte4
         YJAC(1,3) = 0.D0
         YJAC(1,4) = 3.D0*cte-3.D0*cte4
         YJAC(1,5) = -3.D0*cte4
         YJAC(1,6) = 0.D0

         YJAC(2,1) = 3.D0*cte4
         YJAC(2,2) = -3.D0*cte4-3.D0*cte5
         YJAC(2,3) = 3.D0*cte5
         YJAC(2,4) = 3.D0*cte4
         YJAC(2,5) = 3.D0*cte4-3.D0*cte5
         YJAC(2,6) = -3.D0*cte5

         YJAC(3,1) = 0.D0
         YJAC(3,2) = 3.D0*cte5
          YJAC(3,3) = -3.D0*cte5-3.D0*c2
          YJAC(3,4) = 0.D0
          YJAC(3,5) = 3.D0*cte5
          YJAC(3,6) = 3.D0*cte5-3.D0*c2

          YJAC(4,1) = 3.D0*cte-3.D0*cte4
          YJAC(4,2) = 3.D0*cte4
          YJAC(4,3) = 0.D0
          YJAC(4,4) = -2500.D0-3.D0*cte-3.D0*cte4
          YJAC(4,5) = -3.D0*cte4
          YJAC(4,6) = 0.D0

          YJAC(5,1) = -3.D0*cte4
          YJAC(5,2) = 3.D0*cte4-3.D0*cte5
          YJAC(5,3) = 3.D0*cte5
          YJAC(5,4) = -3.D0*cte4
          YJAC(5,5) = -2500.D0-3.D0*cte4-3.D0*cte5
          YJAC(5,6) = -3.D0*cte5

          YJAC(6,1) = 0.D0
          YJAC(6,2) = -3.D0*cte5
          YJAC(6,3) = 3.D0*cte5-3.D0*c2
          YJAC(6,4) = 0.D0
          YJAC(6,5) = -3.D0*cte5
          YJAC(6,6) = -2500.D0-3.D0*cte5-3.D0*c2

      ELSE IF (IPROB .EQ. 30) THEN
        dx =100.D0/(N-1.D0)
        cte =98.1D0/(dx**2)
        PI=4*ATAN(1.D0)

        YJAC(1,1) = -cte*3*(415.D0/72.D0)+
     +                      1.28314800000000017D-8*Y(1)**2
        YJAC(1,2) = cte*3*8.D0
        YJAC(1,3) = -cte*3*3.D0
        YJAC(1,4) = cte*3*(8.D0/9.D0)
        YJAC(1,5) = -cte*3*0.125D0

        YJAC(2,1) = cte*(2.D0+Cos(PI*dx/50.D0))*(257.D0/144.D0)
        YJAC(2,2) = -cte*(2.D0+Cos(PI*dx/50.D0))*(10.D0/3.D0)+
     +         (1.15483320000000005D-7/((2.D0+COS(PI*dx/50.D0))**2))
     +             *Y(2)**2  
         YJAC(2,3) = cte*(2.D0+Cos(PI*dx/50.D0))*(7.D0/4.D0)
         YJAC(2,4) =-cte*(2.D0+Cos(PI*dx/50.D0))*(2.D0/9.D0)
         YJAC(2,5) = cte*(2.D0+Cos(PI*dx/50.D0))*(1.D0/48.D0)

          DO  I = 3,N-2
            YJAC(I,I-2) = -cte*(2.D0+Cos(PI*(I-1)*dx/50.D0))*
     +                           (1.D0/12.D0)
            YJAC(I,I-1) = cte*(2.D0+Cos(PI*(I-1)*dx/50.D0))*
     +                           (4.D0/3.D0)
            YJAC(I,I) = -cte*(2.D0+Cos(PI*(I-1)*dx/50.D0))*
     +                         (5.D0/2.D0)+
     +                     (1.15483320000000005D-7/((2.D0+
     +                         COS(PI*(I-1)*dx/50.D0))**2))*Y(I)**2
            YJAC(I,I+1) = cte*(2.D0+Cos(PI*(I-1)*dx/50.D0))*
     +                           (4.D0/3.D0)
            YJAC(I,I+2) = -cte*(2.D0+Cos(PI*(I-1)*dx/50.D0))*
     +                           (1.D0/12.D0)

          ENDDO
          YJAC(N-1,N-4)= cte*(2.D0+Cos(PI*(N-2)*dx/50.D0))*(1.D0/48.D0)
          YJAC(N-1,N-3)= -cte*(2.D0+Cos(PI*(N-2)*dx/50.D0))*(2.D0/9.D0)
          YJAC(N-1,N-2)= cte*(2.D0+Cos(PI*(N-2)*dx/50.D0))*(7.D0/4.D0)
         YJAC(N-1,N-1)=-cte*(2.D0+Cos(PI*(N-2)*dx/50.D0))*(10.D0/3.D0)+
     +   (1.15483320000000005D-7/((2.D0+COS(PI*dx*(N-2)/50.D0))**2))
     +             *Y(N-1)**2
          YJAC(N-1,N)= cte*(2.D0+Cos(PI*(N-2)*dx/50.D0))*(257.D0/144.D0)

          YJAC(N,N-4) = -cte*(2.D0+Cos(PI*(N-1)*dx/50.D0))*0.125D0
          YJAC(N,N-3) = cte*(2.D0+Cos(PI*(N-1)*dx/50.D0))*(8.D0/9.D0)
          YJAC(N,N-2) = -cte*(2.D0+Cos(PI*(N-1)*dx/50.D0))*3.D0
          YJAC(N,N-1) = cte*(2.D0+Cos(PI*(N-1)*dx/50.D0))*8.D0
         YJAC(N,N) = -cte*(2.D0+Cos(PI*(N-1)*dx/50.D0))*(415.D0/72.D0)+
     +    (1.15483320000000005D-7/((2.D0+COS(PI*(N-1)*dx/50.D0))
     +      **2))*Y(N)**2

      ELSE IF (IPROB .EQ. 32) THEN
          DX =8*ACOS(-1.D0)/N
          DX=(1.D0/DX)**4
          cte=0.25D0**4

          DO  I = 3,N-2
             X=-Y(I-2)+4*Y(I-1)-6*Y(I)+4*Y(I+1)-Y(I+2)
             YJAC(I,I)=3*cte*Y(I)**2+DX*(2*Y(I)*X-6*(1+Y(I)**2))
             YJAC(I,I+1)=4*DX*(1+Y(I)**2)
             YJAC(I,I+2)=-DX*(1+Y(I)**2)
             YJAC(I,I-1)=4*DX*(1+Y(I)**2)
             YJAC(I,I-2)=-DX*(1+Y(I)**2)
          ENDDO
*Partial derivatives for f(1)
           X=-Y(N-1)+4*Y(N)-6*Y(1)+4*Y(2)-Y(3)
           YJAC(1,1)=3*cte*Y(1)**2+DX*(2*Y(1)*X-6*(1+Y(1)**2))
           YJAC(1,2)=4*DX*(1+Y(1)**2)
           YJAC(1,3)=-DX*(1+Y(1)**2)
           YJAC(1,N-1)=-DX*(1+Y(1)**2)
           YJAC(1,N)=4*DX*(1+Y(1)**2)

*Partial derivatives for f(2)
           X=-Y(N)+4*Y(1)-6*Y(2)+4*Y(3)-Y(4)
           YJAC(2,2)=3*cte*Y(2)**2+DX*(2*Y(2)*X-6*(1+Y(2)**2))
           YJAC(2,1)=4*DX*(1+Y(2)**2)
           YJAC(2,3)=4*DX*(1+Y(2)**2)
           YJAC(2,4)=-DX*(1+Y(2)**2)
           YJAC(2,N)=-DX*(1+Y(2)**2)

*Partial derivatives for f(N-1)
          X=-Y(N-3)+4*Y(N-2)-6*Y(N-1)+4*Y(N)-Y(1)
          YJAC(N-1,N-1)=3*cte*Y(N-1)**2+DX*(2*Y(N-1)*X-6*(1+Y(N-1)**2))
          YJAC(N-1,N)=4*DX*(1+Y(N-1)**2)
          YJAC(N-1,N-2)=4*DX*(1+Y(N-1)**2)
          YJAC(N-1,N-3)=-DX*(1+Y(N-1)**2)
          YJAC(N-1,1)=-DX*(1+Y(N-1)**2)

*Partial derivatives for f(N)
          X=-Y(N-2)+4*Y(N-1)-6*Y(N)+4*Y(1)-Y(2)
          YJAC(N,N)=3*cte*Y(N)**2+DX*(2*Y(N)*X-6*(1+Y(N)**2))
          YJAC(N,N-1)=4*DX*(1+Y(N)**2)
          YJAC(N,N-2)=-DX*(1+Y(N)**2)
          YJAC(N,2)=-DX*(1+Y(N)**2)
          YJAC(N,1)=4*DX*(1+Y(N)**2)
	
	ENDIF
****************
      RETURN
      END

*******************************************************************
C THIS ROUTINE GIVES THE  SOLUTION OF THE PROBLEM AT SOME  Tend=TF
        SUBROUTINE SOLUCION (ID,NDIM,T,Y,YP,AUXI)

C INPUT ARGUMENTS
C    IPROB: IDENTIFIES THE PROBLEM (ENTERING IN COMMON)
C    ID,NDIM: MAXIMUM AND ACTUAL DIMENSIONS OF THE PROBLEMS RESPECTIVELY
C    T: GRID-POINT
C
C OUTPUT ARGUMENTS
C    Y(N): Y-COMPONENT
C    YP(N): Y'-COMPONENT 
C    AUXI: CHARACTER VARIABLE TO INDICATE WHETHER THE EXACT 
C         SOLUTION IS KNOWN OR UNKNOWN
C
C FOR SOME PDE PROBLEMS (IPROB=13,32) THE SOLUTION GIVEN IS THAT ONE 
C CORRESPONDING TO THE EXACT SOLUTION OF THE PDE (ALTHOUGH WE ARE 
C INTEGRATING INDEED AN ODE DISCRETIZED IN SPACE VIA MOL FROM THE PDE)

      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION Y(ID),YP(ID)
      CHARACTER AUXI*7
      COMMON /BLOK1/IPROB


      AUXI='KNOWN'
      IF (IPROB. EQ. 1) THEN
         Y(1) = 1.d-8*COS(1.d5*T)
         YP(1) = -1.d-3*SIN(1.d5*T)

      ELSE IF (IPROB. EQ. 2) THEN
          Y(1) = 1.d-8*SIN(1.d5*T)
          YP(1) = 1.d-3*COS(1.d5*T)

      ELSEIF(IPROB.EQ.12) THEN
         if (abs(t-6.d0).lt.1.d-12) then
             y(1)= 0.9954139409446862D+00
            yp(1)=-0.1036661333139567D+00
         else
            auxi='UNKNOWN'
         endif

      ELSE IF ((IPROB .EQ. 13).OR.(IPROB .EQ. 130)) THEN
         cte = 0.852320012872625828D-1*22.d0/Ndim
         xx=0.1027354644d0
         xy=0.73409551375891315D0
        DO I=1,NDIM
         x=i*cte
         Y(I) =0.1D0*(Cosh(x)-Cos(x)-xy*(Sinh(x)-sin(x)))*cos(xx*t)
         Yp(I) =-0.1D0*xx*(Cosh(x)-Cos(x)-xy*(Sinh(x)-sin(x)))*sin(xx*t)
        ENDDO

      ELSEIF(IPROB.EQ.16) THEN
         IF(DABS(T-6.D0) .LT. 1.D-12) THEN
            y(1)= 0.9954139400193356D+00
            yp(1)=-0.1036661471254364D+00
            Y(2)=1.D-8*COS(100*T)
            YP(2)=-1.D-6*SIN(100*T)
         else
              auxi='UNKNOWN'
         ENDIF

      ELSEIF(IPROB.EQ.17) THEN
         xx=t !Newton's method to compute the exact solution
         xlanda=0.5d0
         do k=1,30
           xy=(xx-XLANDA*sin(xx)-t)/(1.d0-XLANDA*cos(xx))
           xx=xx-xy
           if (abs(xy).lt. 1.d-10*max(1.d0,abs(t))) then
             y(1)=cos(xx)-XLANDA
             y(2)=sqrt(1-XLANDA**2)*sin(xx)
             yp(1)=-sin(xx)/(1-XLANDA*cos(xx))
             yp(2)=sqrt(1-XLANDA**2)*cos(xx)/(1-XLANDA*cos(xx))
             return
           endif
         enddo

      ELSEIF(IPROB.EQ.21) THEN

         IF(DABS(T-5.D5) .LT. 1.D-9) THEN
                 Y( 1)=   0.7766584086800482D+01
                 Y( 2)=   0.2531065754551048D+00
                 Y( 3)=  -0.9410571402013185D-01
                 Y( 4)=  -0.5564967162844037D+01
                 Y( 5)=   0.1674849740822012D+01
                 Y( 6)=   0.9767232069533176D+00
                 Y( 7)=   0.1963899572895227D+02
                 Y( 8)=   0.8958504552286460D+01
                 Y( 9)=   0.3611839157057347D+01
                 Y(10)=   0.2493570870305177D+02
                 Y(11)=   0.1769518676153705D+02
                 Y(12)=   0.6583785164549242D+01
                 Y(13)=   0.3178592511375764D+02
                 Y(14)=   0.3863618958160644D+02
                 Y(15)=   0.3192794169732889D+01
                 Y(16)=   0.3084118473380683D+01
                 Y(17)=  -0.1227726356581642D+01
                 Y(18)=  -0.6162537634647217D+00

                 YP( 1)=  -0.2495503201917009D-02
                 YP( 2)=   0.6896467194473328D-02
                 YP( 3)=   0.3007950247474123D-02
                 YP( 4)=  -0.2255335935351989D-02
                 YP( 5)=  -0.4905913854771086D-02
                 YP( 6)=  -0.1938473641716708D-02
                 YP( 7)=  -0.2186170231167942D-02
                 YP( 8)=   0.2817177012110666D-02
                 YP( 9)=   0.1262882639181183D-02
                 YP(10)=  -0.2148728705895163D-02
                 YP(11)=   0.2128650077635786D-02
                 YP(12)=   0.9248501411662923D-03
                 YP(13)=  -0.1675173186229401D-02
                 YP(14)=   0.1011833320388655D-02
                 YP(15)=   0.8231800038576520D-03
                 YP(16)=   0.9417379703028725D-05
                 YP(17)=  -0.7855256238249194D-05
                 YP(18)=  -0.3646926313230521D-05
            else
                 auxi='UNKNOWN'
            ENDIF

      ELSE IF (IPROB .EQ. 27) THEN

          IF (ABS(T-1.D2).LT.1.D-10) THEN !7-8 Significant figures 
                Y( 1) = -.7655725195987442E+00 
                Y( 2) = 0.2266734212070801E+00
                Y( 3) = -.2509222609812735E+00
                Y( 4) = 0.9166245547351664E-02
                Y( 5) = -.5388020893996983E-02
                Y( 6) = -.1855544734589299E-01
                YP(1) = -.4454284532792440E+00
                YP(2) = -.1009603985316031E+01
                YP(3) = 0.3143405243156206E+00
                YP(4) = 0.3276291303929657E-01
                YP(5) = -.8768822021474016E+00
                YP(6) = 0.3020297671776218E+00

         ELSEIF (ABS(T-2.D2).LT.1.D-10) THEN !5-6 Significant figures 
                Y( 1) = 0.5684582315138476E-01
                Y( 2) = 0.7979131890350972E+00
                Y( 3) = 0.2295264022682639E+00
                Y( 4) = 0.2519639350387062E-02
                Y( 5) = 0.1123542045599727E-01
                Y( 6) = -.9734581261814340E-02
                YP(1) = -.1543809020660490E+00
                YP(2) = 0.4314749857874077E+00
                YP(3) = -.1260400235685865E+01
                YP(4) = -.6783005277557333E-01
                YP(5) = 0.6269900903338223E-01
                YP(6) = 0.1197109296201555E+01

          ELSEIF (ABS(T-3.D2).LT.1.D-10) THEN !3-4 Significant figures 
                Y( 1) = 0.1329090126108688E+01
                Y( 2) = 0.5071920417458278E+00
                Y( 3) = 0.1886563090127082E+00
                Y( 4) = -.1350673034822814E-01
                Y( 5) = 0.1121590235614740E-01
                Y( 6) = -.1039616391035353E-02
                YP(1) = -.2378173443348830E+00
                YP(2) = 0.3314687786234629E+00
                YP(3) = -.2023714101797013E+00
                YP(4) = -.9378184308395282E+00
                 YP(5) = -.4072011169999175E+00
                 YP(6) = 0.3460068375624058E+00
          else
                 auxi='UNKNOWN'
          ENDIF

      ELSE IF (IPROB.EQ.30)THEN
               IF (ABS(T-100.D0).LT.1.D-7) THEN 
                   y(1)= 0.1448275487995700D+01  
                  yp(1)= 0.2704112452861246D+00
                  y(2)= 0.1370074663716080D+01  
                  yp(2)= 0.7762348236266524D+00
                  y(3)= 0.1334044239411184D+01  
                  yp(3)= 0.4116686200441235D+00
                  y(4)= 0.9802935028973631D+00  
                  yp(4)= 0.2351571930102934D+00
                  y(5)= 0.6048811588420929D+00  
                  yp(5)=-0.1409098638333260D+00
                  y(6)= 0.4847291130715936D+00  
                  yp(6)=-0.3121366491223131D+00
                  y(7)= 0.5558043443463065D+00  
                  yp(7)=-0.1988178312099942D+00
                  y(8)= 0.5910445437850007D+00  
                  yp(8)=-0.2105261548857420D+00
                  y(9)= 0.3944214748428257D+00  
                  yp(9)= 0.2373691792451849D-01
                  y(10)= 0.3882718577191689D+00  
                  yp(10)=-0.5305349994641415D+00
            else
                   auxi='UNKNOWN'
             endif

      ELSE IF (IPROB .EQ. 32) THEN
             pi=acos(-1.d0)
            dx=8.d0*pi/ndim
            DO I = 1,NDIM
                x=-4*pi+i*dx
               Y(I)=COS(x/4)*COS(T/16)
               YP(I)=-COS(x/4)*SIN(T/16)/16
             ENDDO

      ENDIF
**********************
      RETURN
      END

