import odeToJava.*;
import odeToJava.modules.*;
import odeToJava.functions.*;

/*
   class containing the main method that tests out the Implicit-Explicit
   Runge-Kutta solver, and several other modules of the package
*/
public class ImexTest
{
     public static void main(String[] args)
     {

          // the initial value(s)

          double[] u = new double[8];

          u[0] = 1.0;
          u[1] = 0.0;
          u[2] = 0.0;
          u[3] = 0.0;
          u[4] = 0.0;
          u[5] = 0.0;
          u[6] = 0.0;
          u[7] = 0.0057;

          // run an Imex scheme with the desired parameters

          /*
             Here we run an Imex scheme with the parameters we have created
             above.  Here is an explanation of the parameters/arguments:

             1) new Hires() -> the function (a stiff ODE)

             2) new Span(0.0, 321.8122) -> the Span object: the Imex solver can take in
             the 2 types of enhanced Span objects, but it will not do interpolation (so
             you might as well use only basic Span objects with this solver)

             3) u -> the initial value to the IVP (a stiff IVP)

             4) 1.0E-2 -> the constant stepsize for this solver, stepsize is constant (as
             this is a constant step solver).  Putting in a constant stepsize less than
             or equal to 0 will only cause an error, as there is no constant stepsize
             selection routine

             5) new Btableau("imex443") -> this is the pre-defined IMEX443 Butcher tableau,
             found in the Btableau module of the modules folder, which determines the scheme.
             This solver can only handle RK schemes in autonomous form that are not embedded
             and have no interpolant.  As this is a stiff solver it is recommended that
             it be used for stiff problems for maximum efficiency

             6) "" -> placeholder for a filename for solution to be written to

             7) "Stats_On" -> stats output is turned off

             Note that this solver does not take in a highOrder argument, tolerances or
             the String options for stiffness detection and event location.  This is
             because this is a very basic solver with no embedded schemes, no automatic
             stepsize control, and no stiffness detection or event location
          */

          Imex.imex(new Hires(), new Span(0.0, 321.8122), u, 1.0E-2, new Btableau("imex443"), "", "Stats_Off");
     }
}
