import odeToJava.*;
import odeToJava.modules.*;
import odeToJava.functions.*;
import odeToJava.plotter.*;

/*
   class containing the main method that tests out the Explicit Runge-Kutta
   solver, and several other modules of the package
*/
public class ErkTest
{
     public static void main(String[] args)
     {

          // the initial value(s)

          double[] x = new double[28];

          x[0] = 3.0;
          x[1] = 3.0;
          x[2] = -1.0;
          x[3] = -3.0;
          x[4] = 2.0;
          x[5] = -2.0;
          x[6] = 2.0;

          x[7] = 3.0;
          x[8] = -3.0;
          x[9] = 2.0;
          x[10] = 0.0;
          x[11] = 0.0;
          x[12] = -4.0;
          x[13] = 4.0;

          x[14] = 0.0;
          x[15] = 0.0;
          x[16] = 0.0;
          x[17] = 0.0;
          x[18] = 0.0;
          x[19] = 1.75;
          x[20] = -1.5;

          x[21] = 0.0;
          x[22] = 0.0;
          x[23] = 0.0;
          x[24] = -1.25;
          x[25] = 1.0;
          x[26] = 0.0;
          x[27] = 0.0;

          // run an Explicit Runge-Kutta scheme with the desired parameters

          /*
             Here we run an Explicit RK scheme with the parameters we've
             created above.  Here's an explanation of the parameters/arguments:

             1) new Pleiades() -> the function

             2) new Span(0.0, 3.0) -> the Span object: the Erk solver can take in the 2
             types of enhanced Span objects, but it will not do interpolation (so you
             might as well use only basic Span objects with this solver)

             3) x -> the initial value to the IVP

             4) 3.0E-4 -> the constant stepsize for this solver, stepsize is constant (as
             this is a constant step solver).  Putting in a constant stepsize less than
             or equal to 0 will only cause an error, as there is no constant stepsize
             selection routine

             5) new Btableau("erk4") -> this is the pre-defined classic ERK4 Butcher
             tableau, found in the Btableau module of the modules folder, which
             determines the scheme.  This solver can only handle RK schemes that are
             not embedded and have no interpolant

             6) "" -> placeholder for a filename for solution to be written to

             7) "Stats_On" -> stats output is turned off

             Note that this solver does not take in a highOrder argument, tolerances or
             the String options for stiffness detection and event location.  This is
             because this is a very basic solver with no embedded schemes, no automatic
             stepsize control, and no stiffness detection or event location
          */
      
          Erk.erk(new Pleiades(), new Span(0.0, 3.0), x, 3.0E-4, new Btableau("erk4"), "", "Stats_Off");
     }
}
