import odeToJava.*;
import odeToJava.modules.*;
import odeToJava.functions.*;

/*
   class containing the main method that tests out the DormandPrince
   solver, and several other modules of the package
*/
public class DoprTest
{
     public static void main(String[] args)
     {

          // the initial value(s)

          double[] x = new double[28];

          x[0] = 3.0;
          x[1] = 3.0;
          x[2] = -1.0;
          x[3] = -3.0;
          x[4] = 2.0;
          x[5] = -2.0;
          x[6] = 2.0;

          x[7] = 3.0;
          x[8] = -3.0;
          x[9] = 2.0;
          x[10] = 0.0;
          x[11] = 0.0;
          x[12] = -4.0;
          x[13] = 4.0;

          x[14] = 0.0;
          x[15] = 0.0;
          x[16] = 0.0;
          x[17] = 0.0;
          x[18] = 0.0;
          x[19] = 1.75;
          x[20] = -1.5;

          x[21] = 0.0;
          x[22] = 0.0;
          x[23] = 0.0;
          x[24] = -1.25;
          x[25] = 1.0;
          x[26] = 0.0;
          x[27] = 0.0;

          // the tolerance arrays

          double[] atol = new double[28];   // absolute tolerances all
          for(int i= 0; i< 28; i++)   // set to 1E-8
               atol[i] = 1.0E-8;

          double[] rtol = new double[28];   // relative tolerances all
          for(int i= 0; i< 28; i++)   // set to 1E-4
               rtol[i] = 1.0E-4;

          // run the DormandPrince scheme with the desired parameters

          /*
             Here we run a DormandPrince scheme with the parameters we've
             created above.  Here's an explanation of the parameters/arguments:

             1) new Pleiades() -> the function

             2) new Span(0.0, 3.0) -> the Span object: note that DormandPrince
             can take in the 2 types of enhanced Span objects as well, since it
             can deal with schemes that have interpolants

             3) x -> the initial value to the IVP

             4) -1.0 -> the initial stepsize (this solver also has an intial stepsize
             selection routine, which will be called since we've assigned the initial
             stepsize to a number less than or equal to 0)

             5) atol -> this is the absolute tolerance array

             6) rtol -> this is the relative tolerance array

             7) "" -> placeholder for a filename for solution to be written to

             8) "StiffDetect_Off" -> stiffness detection, a feature of the solver is
             turned off

             9) "EventLoc_Off" -> event location, a feature of the solver is turned
             off

             10) "Stats_On" -> stats output is turned off

             Note that this solver does not take in a Butcher tableau or a highOrder
             argument.  This is because they are hard coded into the solver as this
             solver only does the Dormand-Prince scheme
          */

          DormandPrince.dormand_prince(new Pleiades(), new Span(0.0, 3.0), x, -1.0, atol, rtol, "", "StiffDetect_Off", "EventLoc_Off", "Stats_Off");
     }
}
