import odeToJava.*;   // imports to allow use of package components
import odeToJava.functions.*;
import odeToJava.modules.*;
import odeToJava.plotter.*;

public class F4_dopr_locOn
{
     /*
        main
     */
     public static void main(String[] args)
     {

          // the initial value(s)

          double[] x = new double[1];

          x[0] = 1.0;

          // the tolerances

          double[] atol = new double[1];
          for(int i= 0; i< 1; i++)
               atol[i] = 1.0E-6;   // absolute tolerance 1E-6

          double[] rtol = new double[1];
          for(int i= 0; i< 1; i++)
               rtol[i] = 1.0E-4;   // relative tolerance 1E-4

          // solution interval

          double t0 = 0.0;
          double tf = 20.0;

          // here is where we start timing the solution

          double start = System.currentTimeMillis();   // start the timer

          // we do one call to the DormandPrince solver to solve the first
          // piece of the function over [t0, t*]

          double[] profile = DormandPrince.dormand_prince(new F4(1), new Span(t0, tf), x, -1.0, atol, rtol, "f4_dopr_locOn.txt", "StiffDetect_Off", "EventLoc_Halt", "Stats_Off");

          // we then get some stats from this scheme to use in the second call to dopr

          double hInit = profile[0];   // get h (average)
          double tStar = profile[1];   // get t*

          double[] x1 = new double[1];   // get y*
          x1[0] = profile[2];
          
          // we then do a small forward Euler step to avoid any event location discrepencies

          ODE function;   // function used for small forward Euler step
          double hfe = 1.0E-14;   // stepsize for small forward Euler step

          function = new F4(2);   // note that we do FE with the function that will
             // be used in the next DormandPrince call
               
          x[0] = x[0] + hfe * function.f(tStar, x)[0];   // update y* with y* + h*f(t*, y*)
                         
          tStar = tStar + hfe;   // update t* with t* + h

          // we make a second DormandPrince routine call to solve the second
          // piece of the function over [t*, tf]

          DormandPrince.dormand_prince(new F4(2), new Span(tStar, tf), x1, hInit, atol, rtol, "f4_dopr_locOn.txt", "StiffDetect_Off", "EventLoc_Off", "Stats_Off", "Append");

          double stop = System.currentTimeMillis();   // stop the timer

          System.out.println();
          System.out.println("time in milliseconds:");   // output the time
          System.out.println(stop - start);

          Plotter.showPlotter();
     }
}
