import odeToJava.*;   // imports to allow use of package components
import odeToJava.modules.*;
import odeToJava.functions.*;
import odeToJava.plotter.*;

public class F3_dopr_locOn
{
     /*
        main
     */
     public static void main(String[] args)
     {

          // the initial value(s)

          double[] x = new double[2];

          x[0] = 0.0;
          x[1] = 0.0;

          // the tolerances

          double[] atol = new double[2];
          for(int i= 0; i< 2; i++)
               atol[i] = 1.0E-6;   // absolute tolerance 1E-6

          double[] rtol = new double[2];
          for(int i= 0; i< 2; i++)
               rtol[i] = 1.0E-4;   // relative tolerance 1E-4

          // solution interval

          double t0 = 0.0;
          double tf = 20.0;

          // a few variables used in the loop, some initialized to prime the loop

          double hInit = -1.0;
          double tStar = t0;

          ODE function;   // function used for small forward Euler step
          double hfe = 1.0E-14;   // stepsize for small forward Euler step

          // here's where we start timing the solution

          double start = System.currentTimeMillis();   // start the timer

          for(int i= 0; i< 20; i++)
          {               
               // we do one call to the DormandPrince solver to solve the function
               // until we hit an event

               double[] profile = DormandPrince.dormand_prince(new F3(), new Span(tStar, tf), x, hInit, atol, rtol, "f3_dopr_locOn.txt", "StiffDetect_Off", "EventLoc_Halt", "Stats_Off", "Append");

               // we then get some stats from this scheme to use in the second call to dopr

               hInit = profile[0];   // get h (average)
               tStar = profile[1];   // get t*

               x[0] = profile[2];   // get y*
               x[1] = profile[3];

              // we then do a small forward Euler step to avoid any event location discrepencies

               function = new F3();   // note that we do FE with the function that will
                  // be used in the next Dormand Prince call
               
               x[0] = x[0] + hfe * function.f(tStar, x)[0];   // update y* with y* + h*f(t*, y*)
               x[1] = x[1] + hfe * function.f(tStar, x)[1];
               
               tStar = tStar + hfe;   // update t* with t* + h
          }

          double stop = System.currentTimeMillis();   // stop the timer

          System.out.println();
          System.out.println("time in milliseconds:");   // output the time
          System.out.println(stop - start);

          Plotter.showPlotter();
     }
}
