import odeToJava.*;   // imports to allow use of package components
import odeToJava.functions.*;
import odeToJava.modules.*;
import odeToJava.plotter.*;

public class Ball_ODE_dopr_locHit
{
     /*
        main
     */
     public static void main(String[] args)
     {

          // initialize and give the initial vector value(s)

          double[] x = new double[4];

          x[0] = 0.0;   // starting at x position 0
          x[1] = 10.0;   // starting at y postion 10 (10 meters above ground)
          x[2] = 40.0;   // ball has initial x velocity of 40 m/s
          x[3] = 0.0;   // ball has initial y velocity of 0 m/s (throwing sideways)

          // the tolerances

          double[] atol = new double[4];
          for(int i= 0; i< 4; i++)
               atol[i] = 1.0E-6;   // absolute tolerance 1E-6

          double[] rtol = new double[4];
          for(int i= 0; i< 4; i++)
               rtol[i] = 1.0E-4;   // absolute tolerance 1E-4

          // solution interval

          double t0 = 0.0;
          double tf = 60.0;   // tracking the ball for a minute

          // here's where we start timing the solution

          double start = System.currentTimeMillis();   // start the timer
              
          // we do one call to the DormandPrince solver to solve the function
          // until we hit an event (until the ball hits the floor)

          DormandPrince.dormand_prince(new Ball_ODE(), new Span(t0, tf, 0.01), x, -1.0, atol, rtol, "Ball_ODE_dopr_locHit.txt", "StiffDetect_Off", "EventLoc_Halt", "Stats_Off");

          double stop = System.currentTimeMillis();   // stop the timer

          System.out.println();
          System.out.println("time in milliseconds:");   // output the time
          System.out.println(stop - start);

          Plotter.showPlotter();   // call up the plotter to plot result
     }
}
