package odeToJava.plotter;

import javax.swing.*;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.*;
import java.lang.Double;
import java.awt.Color;

/*
   class is the panel that contains just the plot (without the labels
   or axes)
*/
public class PlotPanel extends JPanel
{
     // constructors
	
     public PlotPanel(double[] xV, double[] yV, double xmin, double xmax, double ymin, double ymax)
     {
          // initializations
		
		this.xMin = xmin;
		this.xMax = xmax;
		this.yMin = ymin;
		this.yMax = ymax;
      
          this.x = new double[xV.length];   // initilize arrays
          this.y = new double[yV.length];
      
          for(int i= 0; i< x.length; i++)   // fill arrays
               this.x[i] = xV[i];
      
          for(int i= 0; i< y.length; i++)      
               this.y[i] = yV[i];    

          // make arrays fall in domain and range dictated by minima and maxima
      
          for(int i= 0; i< x.length; i++)
          {
               if(x[i] < xMin)
                    x[i] = xMin;
               if(x[i] > xMax)
                    x[i] = xMax;
          }
      
          for(int i= 0; i< y.length; i++)
          {
               if(y[i] < yMin)
                    y[i] = yMin;
               if(y[i] > yMax)
                    y[i] = yMax;
          }

          this.domain = xMax - xMin;   // get domain and range
          this.range = yMax - yMin;

          this.xStandard = DEFAULT_WIDTH;   // set the standardization sizes to
          this.yStandard = DEFAULT_HEIGHT;   // the default to start with
                                         
          // standardize arrays                                  
                                                             
          for(int i= 0; i< x.length; i++)   // standardize array of x axis
          {
               x[i] -= xMin;   // make smallest element = 0
               x[i] *= xStandard/domain;   // fit set of points to domain
          }
       
          for(int i= 0; i< y.length; i++)   // standardize array of y axis
          {
               y[i] -= yMin;
               y[i] *= yStandard/range;
               y[i] = yStandard - y[i];   // flip set of points (as the Swing
                  // y axis is upside-down from conventional Cartesian y axis)
          }

          this.setBackground(Color.white);
     }

     // methods
   
     public void paintComponent(Graphics g)
     {
          super.paintComponent(g);   // override old version of graphics
          Graphics2D g2 = (Graphics2D)g;

          for(int i= 0; i< this.x.length; i++)   // re-standardize the arrays for the new
               this.x[i] *= this.getWidth()/xStandard;   // graph size
      
          for(int i= 0; i< this.y.length; i++)
               this.y[i] *= this.getHeight()/yStandard;   
   
          for(int i= 0; i< this.x.length - 1; i++)   // draw the graph
          {
               if(!(((this.x[i] == (double)this.getWidth()) && (this.x[i + 1] == (double)this.getWidth())) || ((this.x[i] == 0.0) && (this.x[i + 1] == 0.0)) || ((this.y[i] == (double)this.getHeight()) && (this.y[i + 1] == (double)this.getHeight())) || ((this.y[i] == 0.0) && (this.y[i + 1] == 0.0))))
               {   // only mark the lines that appear in the window and are not up against the window
                    g2.draw(new Line2D.Double(this.x[i], this.y[i], this.x[i + 1], this.y[i + 1])); 
               }
          }

          g2.setColor(Color.blue);   // mark the points in blue

          for(int i= 0; i< this.x.length; i++)   // mark the points
          {
               if(!((this.x[i] == (double)this.getWidth()) || (this.x[i] == 0.0) || (this.y[i] == (double)this.getHeight()) || (this.y[i] == 0.0 )))
               {   // only mark the points that fall in the window
                    g2.draw(new Ellipse2D.Double(this.x[i] - RADIUS, this.y[i] - RADIUS, DIAMETER, DIAMETER));
               }
          }

          g2.setColor(Color.black);   // set back to default black when done

          xStandard = (double)this.getWidth();   // the new standards according to the size
          yStandard = (double)this.getHeight();
     }

     // instance variables

     private double xMin;   // window range parameters
     private double xMax;
     private double yMin;
     private double yMax;
   
     private double[] x;   // the arrays to plot on the x and y axes
     private double[] y;   // respectively

     private double domain;   // range of x
     private double range;   // range of y

     private double xStandard;   // dynamic standardization values (which are just
     private double yStandard;   // the width and height of the window respectively)

     private final double RADIUS = 1;   // radius of ellipse that marks a point
     private final double DIAMETER = 2*RADIUS;   // diameter of above ellipse

     private final double DEFAULT_WIDTH = 472.0;   // default width and height that
     private final double DEFAULT_HEIGHT = 511.0;   // the window starts off at
}
