package odeToJava.plotter;

import javax.swing.*;
import java.awt.*;
import java.lang.Double;

public class NumberPanel extends JPanel
{
     // constructors

     /*
        class calculates and displays the numbers along each axis of the plot
     */
     public NumberPanel(String aMin, String aMax, String aTick, String axis) throws Exception
     {
          // initializations / calculations

          this.min = Double.parseDouble(aMin);
          this.max = Double.parseDouble(aMax);
          this.tick = Double.parseDouble(aTick);
      
          this.panelTicks = (int)Math.ceil((max - min)/tick) + 1;
      
          // the axis String parameter

          this.axis = axis.toString();
      
          if(!axis.equals("x") && !axis.equals("y"))
          {
			throw new Exception("Internal Error: Axis neither x or y.");
          }

          // the layout

          if(axis.equals("x"))
          {
               while(panelTicks > XMOD)
               {
                    panelTicks /= 2;
                    tick *= 2.0;   
               }

               this.increment = min + tick;

               this.npLayout = new GraphPaperLayout(new Dimension(panelTicks,1),0,0);        
               this.setLayout(npLayout);

               this.add(new JLabel(String.valueOf(min), SwingConstants.LEFT), new Rectangle(0,0,1,1));

               for(int i= 1; i< panelTicks - 1; i++)
               {
                    this.add(new JLabel(String.valueOf(increment), SwingConstants.CENTER), new Rectangle(i,0,1,1));
                    increment += tick;
               }

               this.add(new JLabel(String.valueOf(max), SwingConstants.RIGHT), new Rectangle(panelTicks - 1,0,1,1));
          }
          else
          {
               while(panelTicks > YMOD)
               {
                    panelTicks /= 2;
                    tick *= 2.0;
               }

               this.increment = max;
      
               this.npLayout = new GraphPaperLayout(new Dimension(1,panelTicks),0,0);
               this.setLayout(npLayout);

               for(int i= 0; i< panelTicks - 1; i++)
               {
                    this.add(new JLabel(String.valueOf(increment)), new Rectangle(0,i,1,1));
                    increment -= tick;
               }

               this.add(new JLabel(String.valueOf(min)), new Rectangle(0,panelTicks - 1,1,1));
          }
     }

     // methods
   
     public void paintComponent(Graphics g)
     {
          super.paintComponent(g);
     }
   
     // instance variables
   
     private double min;
     private double max;
     private double tick;
     private int panelTicks;

     private String axis;

     private double increment;
     private GraphPaperLayout npLayout;

     private final int XMOD = 8;
     private final int YMOD = 10;
}