package odeToJava.plotter;

import javax.swing.*;
import java.awt.*;

/*
   class creates all of the components of the graph: the plot, the
   coordinate panels, and the labels for the plotter, given the
   parameters it takes in
*/
public class GraphPanel extends JPanel
{
	public static final double BORDER_FRACTION = .05; // that is, 5% border
	public static final int DEFAULT_TICKS = 10; //actual number of ticks

     public GraphPanel(double[] xV, double[] yV, String xminString, String xmaxString, String yminString, String ymaxString, String title, String xAxis, String yAxis, String xTickString, String yTickString) throws Exception
     {
          double xmin, xmax, ymin, ymax;
		double xTick, yTick;
		boolean xmaxGenerated, xminGenerated, ymaxGenerated, yminGenerated;
		
		//defaults if left blank
		if(xminString.equals(""))
          {
               xmin = xV[0];
               for(int i= 0; i< xV.length; i++)
                    if(xV[i] < xmin)
                         xmin = xV[i];
			xminGenerated = true;
          }
		else
		{
			try
			{
				xmin = Double.parseDouble(xminString);
				xminGenerated = false;
			}
			catch(Exception e)
			{
				throw new Exception("Please enter a number for xMin, or leave blank.");
			}
		}

          if(xmaxString.equals(""))
          {
               xmax = xV[0];
               for(int i= 0; i< xV.length; i++)
                    if(xV[i] > xmax)
                         xmax = xV[i];
			xmaxGenerated = true;
          }
		else
		{
			try
			{
				xmax = Double.parseDouble(xmaxString);
				xmaxGenerated = false;
			}
			catch(Exception e)
			{
				throw new Exception("Please enter a number for xMax, or leave blank.");
			}
		}

          if(yminString.equals(""))
          {
               ymin = yV[0];
               for(int i= 0; i< yV.length; i++)
                    if(yV[i] < ymin)
                         ymin = yV[i];
			yminGenerated = true;
		}
		else
		{
			try
			{
				ymin = Double.parseDouble(yminString);
				yminGenerated = false;
			}
			catch(Exception e)
			{
				throw new Exception("Please enter a number for yMin, or leave blank.");
			}
		}

          if(ymaxString.equals(""))
          {
               ymax = yV[0];
               for(int i= 0; i< yV.length; i++)
                    if(yV[i] > ymax)
                         ymax = yV[i];
			ymaxGenerated = true;
          }
		else
		{
			try
			{
				ymax = Double.parseDouble(ymaxString);
				ymaxGenerated = false;
			}
			catch(Exception e)
			{
				throw new Exception("Please enter a number for yMax, or leave blank.");
			}
		}
		
		
		//Catch instances when min==max for generated points
		//move them out slightly to prevent an error
		if(xmax == xmin && xmaxGenerated)
		{
			if(xminGenerated)
				xmin--;
			xmax++;
		}
		else if(xmax == xmin && xminGenerated)
			xmin--;
		
		if(ymax == ymin && ymaxGenerated)
		{
			if(yminGenerated)
				ymin--;
			ymax++;
		}
		else if(ymax == ymin && yminGenerated)
			ymin--;
		
		
		if(xmax <= xmin)
		{
			throw new Exception("xMax should be greater than xMin, or both should be blank.");
		}
		
		if(ymax <= ymin)
		{
			throw new Exception("yMax should be greater than yMin, or both should be blank.");
		}
		
		double width = xmax - xmin;
		double xBorder = width * BORDER_FRACTION;
		if(xmaxGenerated)
			xmax += xBorder;
		if(xminGenerated)
			xmin -= xBorder;
		
		double height = ymax - ymin;
		double yBorder = height * BORDER_FRACTION;
		if(ymaxGenerated)
			ymax += yBorder;
		if(yminGenerated)
			ymin -= yBorder;
		
		if(xTickString.equals(""))
		{
			xTick = (width + 2 * xBorder)/DEFAULT_TICKS;
		}
		else
		{
			try
			{
				xTick = Double.parseDouble(xTickString);
			}
			catch(Exception e)
			{
				throw new Exception("Please enter a number for xTick, or leave blank.");
			}
		}
		
		if(yTickString.equals(""))
		{
			yTick = (height + 2 * yBorder)/DEFAULT_TICKS;
		}
		else
		{
			try
			{
				yTick = Double.parseDouble(yTickString);
			}
			catch(Exception e)
			{
				throw new Exception("Please enter a number for yTick, or leave blank.");
			}
		}
		
		if(xTick < 0)
			throw new Exception("xTick should be positive, zero or blank.");
		if(yTick < 0)
			throw new Exception("yTick should be positive, zero or blank.");
		
		

          GraphPaperLayout graphLayout = new GraphPaperLayout(new Dimension(20,20),0,0);
          this.setLayout(graphLayout);   // initialize and add layout to graph
             // panel

          // initialize plot panel and add it to graph panel

          PlotPanel plotPanel = new PlotPanel(xV, yV, xmin, xmax, ymin, ymax);
          this.add(plotPanel, new Rectangle(2,1,18,17));
      
          // initialize x coordinate panel and add it to graph panel
      
          CoordPanel xPanel = new CoordPanel(xmin, xmax, xTick, "x");
          this.add(xPanel, new Rectangle(2,18,18,1));
           
          // initialize y coordinate panel and add it to graph panel

          CoordPanel yPanel = new CoordPanel(ymin, ymax, yTick, "y");
          this.add(yPanel, new Rectangle(1,1,1,17));
 
          // initialize the title panel and add it to graph panel
      
          TPanel titlePanel = new TPanel(title);

          this.add(titlePanel, new Rectangle(2,0,18,1));
            
          // initialize the x label panel and add it to graph panel

          JPanel xLabelPanel = new JPanel();

          JLabel xLabel = new JLabel(xAxis);
          xLabelPanel.add(xLabel);

          this.add(xLabelPanel, new Rectangle(2,19,18,1));
      
          // initialize the y label panel and add it to graph panel
      
          YPanel yLabelPanel = new YPanel(yAxis);
      
          this.add(yLabelPanel, new Rectangle(0,1,1,17));      
     }
}
