package odeToJava.plotter;

import java.io.*;
import java.util.*;
import java.lang.Double;
import java.lang.Integer;

/*
   class plots any set of points (an array of points) against another set
   of points (another array of points).  This is particularily useful for
   plotting numerical solutions
*/
public class FileIntake
{
     // constructors
	
     /*
        constructor constructs plot data given the name of the file that contains
        the solution
     */
     public FileIntake(String file) throws Exception
     {
          int dimension = 0;   // dimension of solution (default to 0)
          String inputLine;   // String input variable
          double inputDbl;   // double to convert above String to 
          StringTokenizer tokenizer;   // used to tokenize an input line at a time

          // get solution dimension

		FileReader r0 = new FileReader(file);   // initialize reader and
		BufferedReader i0 = new BufferedReader(r0);   // buffered reader
		
		inputLine = i0.readLine();   // amount of tokens on first line will
		tokenizer = new StringTokenizer(inputLine, " ");   // be one less than
		dimension = tokenizer.countTokens() - 1;   // the dimension

          if(dimension < 1)   // if dimension is <1, there has to be an error:
          {
               throw new Exception("File has less than one dimension.");   // notify user
		}
		
          // get length of solution file

          boolean eof = false;   // whether it is end of file or not
          int solnTotal = 0;   // length of solution file to be calculated
          int solnLength = 0;   // length of solution array to be calculated


		FileReader r1 = new FileReader(file);   // initialize reader and
		BufferedReader i1 = new BufferedReader(r1);   // buffered reader

		while(!eof)   // keep looping until end of file
		{
			if(i1.readLine() != null)   // read a line, if it's not null
				solnLength++;   // (which means not at eof), count it
			else   // else it is eof, close the reader and halt the loop
			{
				r1.close();
				eof = true;
			}
		}

          soln = new double[dimension + 1][solnLength];   // initialize soln matrix
          String inputStr;   // a token from input line

          // use solution file to fill solution matrix
		
          try
          {
               FileReader reader = new FileReader(file);   // initialize readers
               BufferedReader in = new BufferedReader(reader);
		
               for(int i= 0; i< solnLength; i++)
               {
                    inputLine = in.readLine();
                    tokenizer = new StringTokenizer(inputLine, " ");

                    for(int j= 0; j< (dimension + 1); j++)
                    {
                         inputStr = tokenizer.nextToken();   // get next token from tokenizer
                         inputDbl = Double.parseDouble(inputStr);   // convert to double
                         soln[j][i] = inputDbl;   // put element in ith position of the jth row
                            // (each row is a solution array, the # of rows = dimension of
                            // the problem) of matrix
                    }
               }

               reader.close();   // close reader
          }
          catch(Exception n)   // if there is an error in tokenizing the file:
          {
               throw new Exception("The specified file is not in the correct format.");   // notify user
          }
     }

     // methods
	
     public void vectorize(int vX, int vY) throws Exception
     {
          // test the integer conditions

          if((vX < 0) || (vX > (soln.length - 1)) || (vY < 0) || (vY > (soln.length - 1)))
          {   // test to see if arrays specified exist (and are not out of range)
			if(soln.length == 2)
				throw new Exception("Specified variables don't exist. Please enter t or 0");
			else
				throw new Exception("Specified variables don't exist. Please enter t or an index from 0 to " + (soln.length - 2) + ".");
          }
   
          // initializations
   
          this.vectorX = new double[soln[0].length];   // initialize plot arrays
          this.vectorY = new double[soln[0].length];
   
          // array filling

          for(int i= 0; i< soln[0].length; i++)
               vectorY[i] = soln[vY][i];

          for(int i= 0; i< soln[0].length; i++)
               vectorX[i] = soln[vX][i];
     }

     public double[] getVectorX()
     {
          return(vectorX);
     }
   
     public double[] getVectorY()
     {
          return(vectorY);
     }

     // instance variables

     int vX;   // integers that correspond to certain arrays
     int vY;

     private double[][] soln;   // the solution matrix

     private double[] vectorX;   // temporary arrays
     private double[] vectorY;
}