package odeToJava.functions;

import odeToJava.modules.*;

/*
   ODE function for the Pleiades problem
*/
public class Pleiades implements ODE
{
     // constructors
	
     // methods
	
     public double[] f(double t, double[] x)   // ODE function
     {
          final int PRIME_OFFSET = 14;   // offsets for section partitions
          final int Y_OFFSET = 7;
		
          double[][] R = new double[Y_OFFSET][Y_OFFSET];   // the R matrix:
          for(int i= 0; i< Y_OFFSET; i++)   // (R[i][j] = r[i][j]^{3/2}), all values
               for(int j= 0; j< Y_OFFSET; j++)   // default to -1
                    R[i][j] = -1;

          double[] xp = new double[x.length];

          for(int i= 0; i< PRIME_OFFSET; i++)   // set up z' (x' and y')
          xp[i] = x[i + PRIME_OFFSET];
	
          for(int i= 0; i< Y_OFFSET; i++)   // set up x"
          {			
               double sum = 0.0;
               for(int j= 0; j< Y_OFFSET; j++)
               {
                    // for efficiency we only compute each R[i][j] once, then we just
                    // refer to R[i][j] in the R matrix if we need it again
                    if(R[i][j] == -1)
                         R[i][j] = Math.pow((Math.pow((x[i] - x[j]),2) + Math.pow((x[i + Y_OFFSET] - x[j + Y_OFFSET]),2)),((3.0)/(2.0)));
				
                    // f[i] = sigma{j=1:7;j!=i}{m[j]*(x[j] - x[i])/r[i][j]^{3/2}}
                    if(j != i)
                         sum += (j+1)*(x[j] - x[i])/R[i][j];
               }

               xp[i + PRIME_OFFSET] = sum;
               sum = 0.0;   // reset sum for the next term
          }

          for(int i= Y_OFFSET; i< PRIME_OFFSET; i++)   // set up y", very similar
          {   // setup as that for x''
               double sum = 0.0;
               for(int j= 0; j< Y_OFFSET; j++)
               {
                    if(R[i - Y_OFFSET][j] == -1)
                         R[i - Y_OFFSET][j] = Math.pow((Math.pow((x[i - Y_OFFSET] - x[j]),2) + Math.pow((x[i] - x[j + Y_OFFSET]),2)),((3.0)/(2.0)));
			
                    if(j != (i - Y_OFFSET))
                         sum += (j+1)*(x[j + Y_OFFSET] - x[i])/R[i - Y_OFFSET][j];
               }

               xp[i + PRIME_OFFSET] = sum;
               sum = 0.0;
          }
		
          return(xp);
     }

     public double[] g(double t, double[] x)   // event function
     {   // empty implementation of g because there are no events associated
          double[] event = new double[1];   // with this ODE
          return(event);
     }

     // instance variables
}