package odeToJava.functions;

import odeToJava.modules.*;

/*
   ODE for a falling mass problem (second order, 2 dimensions)
*/
public class Ball_ODE implements ODE
{
     // constructors
   
     // methods

     public double[] f(double t, double[] x)   // ODE function
     {
          double[] xp = new double[x.length];
		
          xp[0] = x[2];   // x' the velocities
          xp[1] = x[3];
          xp[2] = 0;   // x'' the accelerations
          xp[3] = -1.0*G;
		
          return(xp);
     }

     public double[] g(double t, double[] x)   // event function
     {
          double[] event = new double[x.length];

          event[0] = x[1];   // event when y position is zero (ball hits ground)
          event[1] = 300.0 - x[0];   // event when x position is 300 (ball hits a wall)

          return(event);
     }

     // instance variables

     /*
        this class has instance variables, but it still properly
        implements Fv as it overloads the f and g methods
     */
     
     private final double G = 9.80665;   // earth's gravity
}