      SUBROUTINE LRZFEX(NEQ, Y, YDOT)
      IMPLICIT         NONE
*
*     .. Scalar Arguments ..
      INTEGER           NEQ
*
*     .. Array Arguments ..
      DOUBLE PRECISION Y(NEQ), YDOT(NEQ)
*
*-------------------------------------------------------------------------
*
*  Purpose
*  =======
*
*  LRZFEX does the function evaluation at Y for the Lorenz Strange 
*  Attractor y'=f(y), where
*
*             [ -sigma (y1-y2)   ]
*      f(y) = [ -y1 y3+r y1 - y2 ]
*             [  y1 y2 - b y3    ]
*
*  Notice that each component of f(y) is qudratic in y.
*
*                                       Ren-Cang Li, June 1, 1996
*                                       na.rcli@na-net.ornl.gov
*
*  Arguments:
*  ==========
*
*  NEQ       (input) INTEGER scalar
*            The dimension of the system.
*
*  Y         (input) DOUBLE PRECISION array, dimension (NEQ)
*            At which f will be evaluated.
*
*  YDOT      (output) DOUBLE PRECISION array, dimension (NEQ)
*            The value of f at Y.
C
C--------------------------------------------------------------------
C
C  Common Block that defines Lorenz Strange Attractor.
C
      DOUBLE PRECISION SIGMA, R, B
      COMMON /LORENZ/SIGMA, R, B
C
      YDOT(1) = -SIGMA*(Y(1)-Y(2))
      YDOT(2) = -Y(1)*Y(3)+R*Y(1)-Y(2)
      YDOT(3) = Y(1)*Y(2)-B*Y(3)
C
      RETURN
      END
C
      SUBROUTINE LRZJEX(NEQ, Y, PD, LD)
      IMPLICIT         NONE
*
*     .. Scalar Arguments ..
      INTEGER           NEQ, LD
*
*     .. Array Arguments ..
      DOUBLE PRECISION PD(LD,NEQ), Y(NEQ)
*
*-------------------------------------------------------------------------
*
*  Purpose
*  =======
*
*  LRZFEX computes the jacobian matrix f'(y) at Y for the Lorenz Strange 
*  Attractor y'=f(y), where
*
*             [ -sigma (y1-y2)   ]
*      f(y) = [ -y1 y3+r y1 - y2 ]
*             [  y1 y2 - b y3    ]
*
*  Notice that each component of f(y) is qudratic in y.
*
*  Arguments:
*  ==========
*
*  NEQ       (input) INTEGER scalar
*            The dimension of the system.
*
*  Y         (input) DOUBLE PRECISION array, dimension (NEQ)
*            At which f'(y) will be evaluated.
*
*  PD        (output) DOUBLE PRECISION array, dimension ( LD, NEQ )
*            It stores f'(y) at Y.
*
*  LD        (input) INTEGER scalar
*            The leading dimension of PD.
C
C--------------------------------------------------------------------
C
C  Common Block that defines Lorenz Strange Attractor.
C
      DOUBLE PRECISION SIGMA, R, B
      COMMON /LORENZ/SIGMA, R, B
C
      PD(1,1) = -SIGMA
      PD(1,2) =  SIGMA
      PD(1,3) =  0.0D0
C
      PD(2,1) = -Y(3)+R
      PD(2,2) = -1.0D0
      PD(2,3) = -Y(1)
C
      PD(3,1) = Y(2)
      PD(3,2) = Y(1)
      PD(3,3) = -B
C
      RETURN
      END
