MODULE defines
  INTEGER, PARAMETER :: wp=KIND(1.d0)
  REAL(wp), PARAMETER :: eps=EPSILON(1.d0)

  ! *** ERROR CODES ***
  ! Allocation of iteration matrix failed.
  INTEGER, PARAMETER :: ERRITERALLOFAILED=-1 
  ! Allocation of jacobian matrix failed.
  INTEGER, PARAMETER :: ERRJACALLOFAILED=-2
  ! Iteration matrix was repeatedly singular.
  INTEGER, PARAMETER :: ERRITERSINGULAR=-3
  ! Step size became too small.
  INTEGER, PARAMETER :: ERRSTEPSIZETOOSMALL=-4
  ! Illegal method name specified.
  INTEGER, PARAMETER :: ERRILLEGALMETHODNAME=-5
  ! Illegal method order specified.
  INTEGER, PARAMETER :: ERRILLEGALMETHODORDER=-6
  ! Cholesky factorization of fitting matrix failed.
  INTEGER, PARAMETER :: ERRCHOLFACTFAILED=-7
  ! Backsolve of fitting matrix failed.
  INTEGER, PARAMETER :: ERRSOLVEFAILED=-8
  ! General MPI failure
  INTEGER, PARAMETER :: ERRMPIFAILED=-9
  ! MPI processors not eq. to no. of stages
  INTEGER, PARAMETER :: ERRMPIPROCS=-10
  ! MPI Allgather failed.
  INTEGER, PARAMETER :: ERRMPIGATHERFAILED=-11
  ! Undefined Matrix type.
  INTEGER, PARAMETER :: ERRMTYPEUNDEFINED=-12
  ! Tried to factorize unfactorizable matrix
  INTEGER, PARAMETER :: ERRUNFACTORIZABLE=-13
  ! Attempted operation on unconformable matrices.
  INTEGER, PARAMETER :: ERRUNCONFORMABLE=-14
  ! Specified working precision is not conform with MPI precisions.
  INTEGER, PARAMETER :: ERRMPIKINDUNAVAILABLE=-15
  ! The requested preconditioner is undefined.
  INTEGER, PARAMETER :: ERRPRECONDUNDEFINED=-16
  ! The requested (iterative) solver is undefined.
  INTEGER, PARAMETER :: ERRSOLVERUNDEFINED=-17
  ! Iterative solver failed to converge
  INTEGER, PARAMETER :: ERRCOULDNOTSOLVESYSTEM=-18
END MODULE defines
