MODULE blas
  INTERFACE gemv
     SUBROUTINE sgemv(trans,m,n,alpha,a,lda,x,incx,beta,y,incy)
       INTEGER, INTENT(IN) :: m,n,lda,incx,incy
       CHARACTER*1, INTENT(IN) :: trans
       REAL(KIND(1.e0)), INTENT(IN) :: alpha, beta
       REAL(KIND(1.e0)), DIMENSION(lda,*), INTENT(IN) :: a
       REAL(KIND(1.e0)), DIMENSION(*), INTENT(IN) :: x
       REAL(KIND(1.e0)), DIMENSION(*), INTENT(INOUT) :: y
     END SUBROUTINE sgemv
     SUBROUTINE dgemv(trans,m,n,alpha,a,lda,x,incx,beta,y,incy)
       INTEGER, INTENT(IN) :: m,n,lda,incx,incy
       CHARACTER*1, INTENT(IN) :: trans
       REAL(KIND(1.d0)), INTENT(IN) :: alpha, beta
       REAL(KIND(1.d0)), DIMENSION(lda,*), INTENT(IN) :: a
       REAL(KIND(1.d0)), DIMENSION(*), INTENT(IN) :: x
       REAL(KIND(1.d0)), DIMENSION(*), INTENT(INOUT) :: y
     END SUBROUTINE dgemv
     SUBROUTINE cgemv(trans,m,n,alpha,a,lda,x,incx,beta,y,incy)
       INTEGER, INTENT(IN) :: m,n,lda,incx,incy
       CHARACTER*1, INTENT(IN) :: trans
       COMPLEX(KIND(1.e0)), INTENT(IN) :: alpha, beta
       COMPLEX(KIND(1.e0)), DIMENSION(lda,*), INTENT(IN) :: a
       COMPLEX(KIND(1.e0)), DIMENSION(*), INTENT(IN) :: x
       COMPLEX(KIND(1.e0)), DIMENSION(*), INTENT(INOUT) :: y
     END SUBROUTINE cgemv
     SUBROUTINE zgemv(trans,m,n,alpha,a,lda,x,incx,beta,y,incy)
       INTEGER, INTENT(IN) :: m,n,lda,incx,incy
       CHARACTER*1, INTENT(IN) :: trans
       COMPLEX(KIND(1.d0)), INTENT(IN) :: alpha, beta
       COMPLEX(KIND(1.d0)), DIMENSION(lda,*), INTENT(IN) :: a
       COMPLEX(KIND(1.d0)), DIMENSION(*), INTENT(IN) :: x
       COMPLEX(KIND(1.d0)), DIMENSION(*), INTENT(INOUT) :: y
     END SUBROUTINE zgemv
  END INTERFACE
  INTERFACE gbmv
     SUBROUTINE sgbmv(trans,m,n,kl,ku,alpha,a,lda,x,incx,beta,y,incy)
       INTEGER, INTENT(IN) :: m,n,kl,ku,lda,incx,incy
       CHARACTER*1, INTENT(IN) :: trans
       REAL(KIND(1.e0)), INTENT(IN) :: alpha, beta
       REAL(KIND(1.e0)), DIMENSION(lda,*), INTENT(IN) :: a
       REAL(KIND(1.e0)), DIMENSION(*), INTENT(IN) :: x
       REAL(KIND(1.e0)), DIMENSION(*), INTENT(INOUT) :: y
     END SUBROUTINE sgbmv
     SUBROUTINE dgbmv(trans,m,n,kl,ku,alpha,a,lda,x,incx,beta,y,incy)
       INTEGER, INTENT(IN) :: m,n,kl,ku,lda,incx,incy
       CHARACTER*1, INTENT(IN) :: trans
       REAL(KIND(1.d0)), INTENT(IN) :: alpha, beta
       REAL(KIND(1.d0)), DIMENSION(lda,*), INTENT(IN) :: a
       REAL(KIND(1.d0)), DIMENSION(*), INTENT(IN) :: x
       REAL(KIND(1.d0)), DIMENSION(*), INTENT(INOUT) :: y
     END SUBROUTINE dgbmv
     SUBROUTINE cgbmv(trans,m,n,kl,ku,alpha,a,lda,x,incx,beta,y,incy)
       INTEGER, INTENT(IN) :: m,n,kl,ku,lda,incx,incy
       CHARACTER*1, INTENT(IN) :: trans
       COMPLEX(KIND(1.e0)), INTENT(IN) :: alpha, beta
       COMPLEX(KIND(1.e0)), DIMENSION(lda,*), INTENT(IN) :: a
       COMPLEX(KIND(1.e0)), DIMENSION(*), INTENT(IN) :: x
       COMPLEX(KIND(1.e0)), DIMENSION(*), INTENT(INOUT) :: y
     END SUBROUTINE cgbmv
     SUBROUTINE zgbmv(trans,m,n,kl,ku,alpha,a,lda,x,incx,beta,y,incy)
       INTEGER, INTENT(IN) :: m,n,kl,ku,lda,incx,incy
       CHARACTER*1, INTENT(IN) :: trans
       COMPLEX(KIND(1.d0)), INTENT(IN) :: alpha, beta
       COMPLEX(KIND(1.d0)), DIMENSION(lda,*), INTENT(IN) :: a
       COMPLEX(KIND(1.d0)), DIMENSION(*), INTENT(IN) :: x
       COMPLEX(KIND(1.d0)), DIMENSION(*), INTENT(INOUT) :: y
     END SUBROUTINE zgbmv
  END INTERFACE
  INTERFACE gemm
     SUBROUTINE sgemm(transa,transb,m,n,k,alpha,a,lda,b,ldb,beta,c,ldc)
       INTEGER, INTENT(IN) :: m,n,k,lda,ldb,ldc
       CHARACTER*1, INTENT(IN) :: transa, transb
       REAL(KIND(1.e0)), INTENT(IN) :: alpha, beta
       REAL(KIND(1.e0)), DIMENSION(lda,*), INTENT(IN) :: a
       REAL(KIND(1.e0)), DIMENSION(ldb,*), INTENT(IN) :: b
       REAL(KIND(1.e0)), DIMENSION(ldc,*), INTENT(INOUT) :: c
     END SUBROUTINE sgemm
     SUBROUTINE dgemm(transa,transb,m,n,k,alpha,a,lda,b,ldb,beta,c,ldc)
       INTEGER, INTENT(IN) :: m,n,k,lda,ldb,ldc
       CHARACTER*1, INTENT(IN) :: transa, transb
       REAL(KIND(1.d0)), INTENT(IN) :: alpha, beta
       REAL(KIND(1.d0)), DIMENSION(lda,*), INTENT(IN) :: a
       REAL(KIND(1.d0)), DIMENSION(ldb,*), INTENT(IN) :: b
       REAL(KIND(1.d0)), DIMENSION(ldc,*), INTENT(INOUT) :: c
     END SUBROUTINE dgemm
     SUBROUTINE cgemm(transa,transb,m,n,k,alpha,a,lda,b,ldb,beta,c,ldc)
       INTEGER, INTENT(IN) :: m,n,k,lda,ldb,ldc
       CHARACTER*1, INTENT(IN) :: transa, transb
       COMPLEX(KIND(1.e0)), INTENT(IN) :: alpha, beta
       COMPLEX(KIND(1.e0)), DIMENSION(lda,*), INTENT(IN) :: a
       COMPLEX(KIND(1.e0)), DIMENSION(ldb,*), INTENT(IN) :: b
       COMPLEX(KIND(1.e0)), DIMENSION(ldc,*), INTENT(INOUT) :: c
     END SUBROUTINE cgemm
     SUBROUTINE zgemm(transa,transb,m,n,k,alpha,a,lda,b,ldb,beta,c,ldc)
       INTEGER, INTENT(IN) :: m,n,k,lda,ldb,ldc
       CHARACTER*1, INTENT(IN) :: transa, transb
       COMPLEX(KIND(1.d0)), INTENT(IN) :: alpha, beta
       COMPLEX(KIND(1.d0)), DIMENSION(lda,*), INTENT(IN) :: a
       COMPLEX(KIND(1.d0)), DIMENSION(ldb,*), INTENT(IN) :: b
       COMPLEX(KIND(1.d0)), DIMENSION(ldc,*), INTENT(INOUT) :: c
     END SUBROUTINE zgemm
  END INTERFACE
END MODULE blas
