!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!         Computing planar curve intersections by means of Aberth method     !
!                         by Dario A. Bini and Ana Marco                     !
!                                  v. 1.0                                    !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! This program uses the module pci_mod (parametric curve intersection)
! for computing the real solutions (t,u) in the range [t1,t2]x[u1,u2] of the 
! nonlinear algebraic system
!                f(t,u)=0,  g(t,u)=0
! where 
!       f(t,u)=a1(t)b2(u)-a2(t)b1(u)
!       g(t,u)=a3(t)b4(u)-a4(t)b3(u)
! and a1,a2,a3,a4,b1,b2,b3,b4 are polynomials of degree na1,na2,na3,na4, 
! nb1,nb2,nb3,nb4, respectively.
! This system comes from the problem of intersecting two planar curves 
!       q1=(x1(t),y1(t)),  q2=(x2(u),y2(u))
! assigned in parametric form, where
! x1(t)=a1(t)/a2(t), y1(t)=a3(t)/a4(t),
! x2(u)=b1(u)/b2(u), y2(t)=b3(t)/b4(t),
! and a1,a2,a3,a4,b1,b2,b3,b4 are polynomials.
!
! The algorithm is based on the Ehrlic-Aberth iteration applied
! to the polynomial det(Sylv), where Sylv is the Sylvester matrix of 
! f(t,u) and g(t,u) as polynomials in u
!  ***************************************************************************
!  * All the software  contained in this library  is protected by copyright. *
!  * Permission  to use, copy, modify, and  distribute this software for any *
!  * purpose without fee is hereby granted, provided that this entire notice *
!  * is included  in all copies  of any software which is or includes a copy *
!  * or modification  of this software  and in all copies  of the supporting *
!  * documentation for such software.                                        *
!  ***************************************************************************
!  * THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED *
!  * WARRANTY. IN NO EVENT, NEITHER  THE AUTHORS, NOR THE PUBLISHER, NOR ANY *
!  * MEMBER  OF THE EDITORIAL BOARD OF  THE JOURNAL  "NUMERICAL ALGORITHMS", *
!  * NOR ITS EDITOR-IN-CHIEF, BE  LIABLE FOR ANY ERROR  IN THE SOFTWARE, ANY *
!  * MISUSE  OF IT  OR ANY DAMAGE ARISING OUT OF ITS USE. THE ENTIRE RISK OF *
!  * USING THE SOFTWARE LIES WITH THE PARTY DOING SO.                        *
!  ***************************************************************************
!  * ANY USE  OF THE SOFTWARE  CONSTITUTES  ACCEPTANCE  OF THE TERMS  OF THE *
!  * ABOVE STATEMENT.                                                        *
!  ***************************************************************************
!
!   CORRESPONDING AUTHOR:
!
!       DARIO ANDREA BINI
!       UNIVERSITY OF PISA, ITALY
!       E-MAIL: bini@dm.unipi.it
!
!   REFERENCE: D.A. Bini and A. Marco, "Computing curve intersection by 
!              means of simultaneous iterations"
!
! ----------------------------------------------------------------------------
! Main subroutine: SYSTEMSOLVE(t1, t2, u1, u2,                   
!                         na1, na2, na3, na4, nb1, nb2, nb3, nb4,
!                         a1, a2, a3, a4, b1, b2, b3, b4,       
!                         ub, nsol, t, u, status, it, avit)
! INPUT variables:
! t1,t2,u1,u2: bounds for the solutions: t1<=t<=t2, u1<=u<=u2
! na1,na2,na3,na4,nb1,nb2,nb3,nb4: degrees of the polynomials a1--a4, b1--b4
! a1,a2,a3,a4,b1,b2,b3,b4: coefficient vectors of the polynomials ordered
!   with increasing degree.  These vectors are indexed from 0. 
! 
! OUTPUT variables:
! ub:     upper bound to the number of the solutions
! nsol:   number of solutions in the range
! t,u:    complex vectors of length ub such that (t(i),u(i)), i=1:ub
!         are approximations to the solutions, and (t(i),u(i)), i=1:nsol are
!         approximations to the solutions in the range [t1,t2]x[u1,u2] 
! status: integer vector of length ub classifying the solutions as follows:
!                Bit                                  status:
!                0 stop: small residual error            1
!                1 stop: small Newton's correction       2
!                2 spurious solution                     4
!                3 Solution at infinity                  8
!                4 nonreal solution                     16
!                5 solution in the range                32 
!                6 nonisolated solution                 64
!                7 inclusion disk disjoint from range  128
!                8 collapsed approximation             256
!                9 multiple solution                   512
!               10 infinite Newton correction         1024
! it:     number of simultaneous iterations
! globit: overall number of iterations 
! ----------------------------------------------------------------------------
! Parameters used in the module:
! dp:       double precision identifyer
! nitbatch: maximum number of simultaneous iterations inside each batch
! nit:      maximum number of simultaneous batch iterations
! eps:      machine epsilon, used in the stop condition
! epsnewt:  error bound on the Newton correction, used in the stop condition
! dolog:    if .true. the program generates the file systemsolve.log with a 
!           log about the execution steps of the program
!-----------------------------------------------------------------------------
! The program reads data from a file. The file must contain:
! t1,t2,u1,u2
! na1,na2,na3,na4
! nb1,nb2,nb3,nb4
! the coefficient of the polynomials a1--a4, b1--b4 with increasing 
! degree, each coefficient on a different line
!-----------------------------------------------------------------------------
program main
  USE pci_mod  
  implicit none
  integer  :: i, j, nsol, na1, na2, na3, na4, nb1, nb2, nb3, nb4, it, ub
  real(dp),dimension(:),allocatable    :: a1, a2, a3, a4, b1, b2, b3, b4
  complex(dp),dimension(:),allocatable :: t, u
  integer,dimension(:),allocatable     :: status
  character(len=30)                    :: filename
  real(dp)                             :: t1, t2, u1, u2, avit, time

! INPUT DATA
!  write(*,*)'Type the file name with the input data'
!  read(*,*)filename
  filename='pol.pol'
  open(unit=20,file=filename)
  read(20,*)t1,t2,u1,u2  
  read(20,*)na1,na2,na3,na4
  read(20,*)nb1,nb2,nb3,nb4
  allocate(a1(0:na1),a2(0:na2),a3(0:na3),a4(0:na4))
  allocate(b1(0:nb1),b2(0:nb2),b3(0:nb3),b4(0:nb4))

  do i=0,na1
     read(20,*)a1(i)
  end do
  do i=0,na2
     read(20,*)a2(i)
  end do
  do i=0,na3
     read(20,*)a3(i)
  end do
  do i=0,na4
     read(20,*)a4(i)
  end do
  do i=0,nb1
     read(20,*)b1(i)
  end do
     do i=0,nb2
        read(20,*)b2(i)
     end do
  do i=0,nb3
     read(20,*)b3(i)
  end do
     do i=0,nb4
        read(20,*)b4(i)
     end do
! solve the system
  time=timing()
  call systemsolve(t1, t2, u1, u2, na1, na2, na3, na4, nb1,  &
       nb2, nb3, nb4, a1, a2, a3, a4, b1, b2, b3, b4 ,ub, nsol, t, u, &
       status, it, avit)
  write(*,*)"TIME=",timing()-time,"iter.=",it," average iter.=",avit,&
            "solutions=",nsol
  do i=1,nsol 
     write(*,*)"t=",real(t(i)),"u=",real(u(i)) ,"status=",status(i)
  end do
  if(it==nit*nitbatch)write(*,*)"Warning: reached the maximum number of iterations"
end program main

