##############################################################
# 
#     make.inc
# 
##############################################################
#
#   distributions tar name needs this string
#
DATESTRING=`date +"%Y.%m.%d-%H"`
#
#   Archiver for libxxx.a and ranlib, use echo if not present
#
ARCH     = ar
ARCHFLAGS= cr
#RANLIB   = echo
RANLIB = ranlib
#
#
# to use the included minimum set of blas, lapack and lapack95 routines
# use the following path for libraries and for modules directory:
#
BLAS_LAPACK_LIB_DIR=min_blas_lapack
BLAS_LAPACK_MOD_DIR=min_blas_lapack
# otherwise set these two values to the path where libraries and modules
# are stored, respectively
#
BLASLIB = $(BLAS_LAPACK_LIB_DIR)/libblas.a
LAPACKLIB =$(BLAS_LAPACK_LIB_DIR)/liblapack.a
LAPACK95LIB = $(BLAS_LAPACK_LIB_DIR)/liblapack95.a
LAPACKMOD = $(BLAS_LAPACK_MOD_DIR)/f77_lapack.mod  $(BLAS_LAPACK_MOD_DIR)/f95_lapack.mod \
	 $(BLAS_LAPACK_MOD_DIR)/la_auxmod.mod   $(BLAS_LAPACK_MOD_DIR)/la_precision.mod
#
############################## 
#   Lahey Fortran Compiler   #
##############################      
#FF=lf95 
#   choose optimization level
#FFOPT=
#FFOPT= --chk 
#FFOPT= --o2
#   staticlink links statically the Lahey Fortran Libraries
#FFLAGSM=--staticlink --warn $(FFOPT) 
#FFLAGSG= --staticlink --warn $(FFOPT) 
#   blas, lapack, lapack95, and its Fortran 95 modules 
#   must be compiled with the same  Fortran Compiler lf95.
#   
#FFLIBS=-I$(BLAS_LAPACK_MOD_DIR) -L$(BLAS_LAPACK_LIB_DIR) -llapack95 -llapack -lblas
#
############################################
#   G95 GNU Fortran Compiler               #
############################################
FF= g95 
#   choose optimization level
#FFOPT=
FFOPT=-O2 
#   -fzero to set up to 0 new variables
FFLAGSM= -Wall -fzero $(FFOPT)
FFLAGSG= -Wall -fzero $(FFOPT)
#   blas, lapack, lapack95, and its Fortran 95 modules 
#   must be compiled with the same Fortran Compiler g95.
#
FFLIBS= -I$(BLAS_LAPACK_MOD_DIR)  -L$(BLAS_LAPACK_LIB_DIR) -llapack95 -llapack -lblas 
#
##########################################
# Intel Fortran Compiler   (32 bits CPU) #
##########################################
#FF = ifort
#   choose optimization level
#FFOPT= -mp1 -O
#FFOPT= -check all
#FFOPT=-xP -O3
#   -nofor_main is required by ifort if the main program is in C and not in Fortran
#FFLAGSM = -nofor_main -reentrancy threaded  -static-libcxa  -warn all  $(FFOPT)
#FFLAGSG = -reentrancy threaded -static-libcxa  -warn all  $(FFOPT)
#   blas, lapack, lapack95, and its Fortran 95 modules 
#   must be compiled with the same Fortran Compiler ifort.
#
#FFLIBS= -I$(BLAS_LAPACK_MOD_DIR) -L$(BLAS_LAPACK_LIB_DIR) -llapack95 -llapack -lblas 
#
#########################################
# NAG Fortran Compiler   (32 bits CPU)  #
#########################################
#FF = f95
#   choose optimization level
#FFOPT=   -dusty -dcfuns -thread_safe  -unsharedf95
#FFOPT= -O4
#FFLAGSM =  $(FFOPT)
#FFLAGSG =  $(FFOPT)
#   blas, lapack, lapack95, and its Fortran 95 modules 
#   must be compiled with the same Fortran Compiler NAG.
#
#FFLIBS=  -I$(BLAS_LAPACK_MOD_DIR)/ -L$(BLAS_LAPACK_LIB_DIR)/  -llapack95 -llapack -lblas /usr/lib/gcc-lib/i386-redhat-linux/3.2/libg2c.a
#
#
