//demo file: Compare 3 algorithms to compute the
//Legendre-Fenchel conjugate. Each algorithm is
//timed on the computation of conjugate of the absolute value
//function on the grid N={1,2,3,...,n} for increasing 
//values of n=100, 300, 500, ..., 4000 The 3 algorithms compared //are lft_direct, lft_llt using fusion, and lft_llt 
//using fusionsci.
//Functions demoed: lft_direct, lft_llt

//Result: Except for small values of n, the direct
//algorithm is the loser. The llt algorithm with
//the option fusionsci is the winner for the range
//of values of n consider. For very large values
//of n (not shown on the graph), the llt algorithm
//with the option fusion will beat fusionsci.
mode(-1);

//increases the memory allocated to Scilab
s=stacksize();
if s(1) < 0.5 * 10^8
	stacksize(0.5 * 10^8);
end
clear time;
//Grid containing all the increasing values of n
N=[100:200:4000]';
//boolean to verify all algorithms return the same results
isEqual = %t;

printf("Looping till n=%i\n",N(length(N)));
for i=1:size(N,1)
	n=N(i);//size and upper-bound of the grid
	printf("n= %d\n",n);
	Xr=(1:1:n)';//primal grid is {1,2,...,n}
	Sr=Xr;//dual grid is equal to primal grid
	f=abs(Xr);//evalute the absolute value function on the primal grid
	//time the direct algorithm (quadratic complexity;for comparison only)
	timer();C1 = lft_direct(Xr, f, Sr);time(i, 1) = timer();
	//time the llt algorithm using the fusion internal function
	//fusion uses explicit loops to achieve a linear complexity
	timer();C2 = lft_llt(Xr,f,Sr,0);time(i, 2) = timer();
	//time the llt algorithm using the fusionsci internal function
	//fusionsci uses built-in functions but may not be linear-time
	timer();C3 = lft_llt(Xr,f,Sr,1);time(i, 3) = timer();
	isEqual = isEqual & isequal(C1,C2,C3);
end
//check that all 3 algorithms return the exact same results
if ~isEqual 
	printf("Error! For i=%i not all methods returned the same result",i);
end

//plot the time taken by each algorithm for each value of n
labels =["direct","fusion","fusionsci"];
xbasc;
plot2d(N,time);
p=get("hdl");
legends(labels,[1,2,3],opt="ul");
q=get("hdl");
thickness=[1;2;1];line_style=[1;2;4];
for i=1:3
	p.children(i).thickness=thickness(i);
	p.children(i).line_style=line_style(i);
	q.children(2*i).thickness=thickness(i);
	q.children(2*i).line_style=line_style(i);
end
xtitle('Comparison of lft_direct vs lft_llt[fusion] vs lft_llt[fusionsci]');
//reset the memory dedicated to Scilab to each previous size
stacksize(s(1));
clear s;
