/*
** RK2TRI.C
**
** AUTHORS: 
**
**   Maria MORANDI CECCHI               Stefano DE MARCHI,            
**   University of Padua, Italy         University of Udine, Italy
**   email: mcecchi@math.unipd.it       email: demarchi@dimi.uniud.it
**   
**                       Damiano FASOLI
**                       Verona Software Srl, Italy 
**                       email: vrsoft@sis.it
**
**
**
** REVISION DATE: May, 1999  
**
** MODULES CALLED: NONE
**
** -----------------------------------------------------------------------
**
** REFERENCES:
**
**    TRIPACK package ( that can be download at the internet address
**                      http://www.acm.org/calgo/contents/751.gz )
**
**
**
** -----------------------------------------------------------------------
**
** SYNOPSIS:
**
**          rk2tri file1 file2
**
** 'file1' is the triangulation file containing the output generated by
** the subroutine 'TRPRNT' of the TRIPACK package.
**
** 'file2' is the conversion of file1 into the
** triangulation file in the format generated by
** the program 'do_trian'.
**
** This file has three sections as explained in program 'do_trian'.
** The first, starting with a single capital letter `C' in the first row,
** lists in subsequent blocks separated by -1 the index of
** a node and those of its neighbours in a counterclockwise
** order.
** Note that file2 uses only this first section and the heading of the
** second section, that is a single capital letter `B' in the row.
**
** During the conversion the program removes the triangles belonging to 
** constrained regions in order to generate the triangulation only on the
** required domain.
**
** Note that this step is different from the corresponding one
** in the TRIPACK package.
**
**
-----------------------------------------------------------------------
**
** SUBROUTINES AND FUNCTIONS:
**
** geometric_side which_side(double xp,double yp,
**                           double xi,double yi,double xj,double yj)
**
** This function considers the vector (xj,yj)-(xi,yi) and the straight
line passing
** through them and returns 'dentro_weak' if the point (xp,yp) lies in
the closed
** half-plane on the left of the line, while it returns 'fuori_strong'
if
** the point (xp,yp) lies in the opened half-plane on the right of the
line.
**
** The function uses the sign of the third component of the cross
product
** of two vectors assuming it zero if its magnitude is smaller then
EPS_ALLIN.
**
** >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
**
** void permutations(long int* o_v,long int* a_v,long int* oa_v)
**
** The function requires as input the values 'o_v', 'a_v' and 'oa_v'.
** These values must satisfy the inequalities
**
**  lcc[I] <=  'o_v', 'a_v', 'oa_v' < lcc[I+1]
**
** It simply sorts them in ascending order.
**
*/

#include<stdio.h>
#include<string.h>
#include<math.h>
#include<stdlib.h>
#define EPS_ALLIN 1.e-13
#define MAX_NUM_NODI 100000  /* Maximum number of nodes */
#define MAXVIC 30         /* Maximum number of neighbouring nodes */
#define MAXCSTR 100       /* Maximum number of constraints */

typedef enum {dentro_weak, fuori_strong} geometric_side;
geometric_side which_side();
void permutations();

void main(argc,argv)
int argc;
char *argv[];
{
 FILE *in, *out;
 char buffer[50];
 double x[MAX_NUM_NODI],y[MAX_NUM_NODI];
 long int base_node, vic_rec[MAXVIC],o_v,a_v,oa_v,temp_index,
      cont_N,N /* number of nodes */;
 long int lcc[MAXCSTR];
 int continua,skip,new_base;
 int left,right,M,ncc,I /* active constraint */, cont_vic;
 int mode; /* 0 output -  1 handling closed cell -  2 handling open cell
*/
 int n_char_read;
 int state_for_new_base;

 if (argc==1)
 {
  printf("Launch the program with two parameters:\n");
  printf("1) Triangulation file name in RENKA format\n");
  printf("2) Triangulation file name in DO_TRIAN format\n");
  return;
 }
 if (argc<3)
 {
  printf("Launch only %s for instructions\n",argv[0]);
  return;
 }
 in=fopen(argv[1],"r");
 if (in==NULL) {printf("Cannot open file: %s\n",argv[1]); return;}
 out=fopen(argv[2],"w");
 if (out==NULL) {printf("Cannot open file: %s\n",argv[2]); return;}
 fprintf(out,"C\n");
 /* First reading : x-y data, N, NCC, LCC */
 while (!feof(in))
 {
  fscanf(in," %s",buffer);
  if (strcmp(buffer,"OF")==0 || strcmp(buffer,"of")==0)
  {
   fscanf(in," %s",buffer);
   break;
  }
 }
 if (feof(in))
   {
    printf("File %s in a no correct format\n",argv[1]);
    return;
   }
 /* beginning real reading */
 fscanf(in," %s",buffer);
 N=0;
 while(1)
 {
  fscanf(in," %lf",&(x[N]));
  fscanf(in," %lf",&(y[N]));
  new_base=0;
  state_for_new_base=0;
  while(new_base==0)
  {
    switch(state_for_new_base)
      {
 case 0: fscanf(in," %s",buffer);
                if (fgetc(in)=='\n') state_for_new_base=1; else
                                     state_for_new_base=10;
                n_char_read=1; /* anyway */
                break;

        case 1: if (fgetc(in)=='\n') state_for_new_base=20; else
                                     state_for_new_base=2;
                n_char_read=n_char_read+1; /* anyway */
                break;

 case 2: {
                 int loccounter;

                 fseek(in,-1,SEEK_CUR);
                 n_char_read=n_char_read-1;
                 loccounter=0;
                 do
            {
                    if (fgetc(in)!=' ') state_for_new_base=20;
                    n_char_read=n_char_read+1; /* anyway */
                    loccounter=loccounter+1;
                   }
                 while (loccounter<=10 && state_for_new_base==2);
                 if (loccounter>10) state_for_new_base=10;
         }
               break;

       case 10: /* success with the same base */
                fseek(in,-n_char_read,SEEK_CUR);
                state_for_new_base=0;
                break;

       case 20: /* success with a new base*/
                new_base=1;
                fseek(in,-n_char_read,SEEK_CUR);
                break;
      }
  }
  fscanf(in," %s",buffer); N++;
  if (strcmp(buffer,"NB")==0) break;
 }
 /* N is the number of nodes read */
 /* Searching for NCC string */
 while (!feof(in))
 {
  fscanf(in," %s",buffer);
  if (strcmp(buffer,"NCC")==0)
  {
   fscanf(in, " %s",buffer);
   break;
  }
 }
 /* Reading ncc */
 fscanf(in," %d",&ncc);
 /* Reading lcc */
 fscanf(in, " %s",buffer);
 fscanf(in, " %s",buffer);
 for (I=0;I<ncc;++I) fscanf(in," %ld",&lcc[I]);
 lcc[ncc]=N+1; /* Convention to work with last constraint */
 fclose(in);
 /* Second reading */
 in=fopen(argv[1],"r");
 if (in==NULL) {printf("Cannot open file: %s\n",argv[1]); return;}
 while (!feof(in))
 {
  fscanf(in," %s",buffer);
  if (strcmp(buffer,"OF")==0 || strcmp(buffer,"of")==0)
  {
   fscanf(in," %s",buffer);
   break;
  }
 }
 if (feof(in))
   {
    printf("File %s in a no correct format\n",argv[1]);
    return;
   }
 for (cont_N=0;cont_N<N;cont_N++)
 {
  fscanf(in," %ld",&base_node);
  M=0; /* Number of neighbours for 0-index node eventually
          with 0 value for open cells */
  fscanf(in," %s",buffer);
  fscanf(in," %s",buffer);
  new_base=0;
  state_for_new_base=0;
  while (new_base==0)
  {
   switch(state_for_new_base)
     {
        case 0: fscanf(in," %ld",&vic_rec[M]); M++;
                if (M>MAXVIC-1) /*Considering an eventual adding of 0
value too*/
                  {printf("Found node with too many neighbors\n");
exit(1);}
                if (fgetc(in)=='\n') state_for_new_base=1; else
                                     state_for_new_base=10;
                n_char_read=1; /* anyway */
                break;

        case 1: if (fgetc(in)=='\n') state_for_new_base=20; else
                                     state_for_new_base=2;
                n_char_read=n_char_read+1; /* anyway */
                break;

 case 2: {
                 int loccounter;

                 fseek(in,-1,SEEK_CUR);
                 n_char_read=n_char_read-1;
                 loccounter=0;
                 do
           {
                   if (fgetc(in)!=' ') state_for_new_base=20;
                   n_char_read=n_char_read+1; /* anyway */
                   loccounter=loccounter+1;
                 }
                 while (loccounter<=10 && state_for_new_base==2);
                 if (loccounter>10) state_for_new_base=10;
         }
                break;

       case 10: /* success with the same base */
                fseek(in,-n_char_read,SEEK_CUR);
                state_for_new_base=0;
                break;

       case 20: /* success with a new base*/
                new_base=1;
                fseek(in,-n_char_read,SEEK_CUR);
                break;
     }
  }
  /* M is the number of neighbours (eventually with 0 value included) */

  if (base_node<lcc[0]) mode=0; /* output */
   else
    {
     /* Setting active constraint */
     I=0; while (1)
    {
     if (base_node>=lcc[I] && base_node<lcc[I+1]) break;
     I++;
    }
     if (vic_rec[M-1]==0) mode=2; else mode=1;
    }
  /* Do not replace the following 'if' with 'switch'  */
  if (mode==0) left=0; /* For the segment to work with later */
  if (mode==1) /* Closed cell */
  {
   left=0;  /* Current pointer to the second vertex of the triangle */
   continua=1;
   while(continua)
   {
    if (continua==1) /* Standard triangle */
    {
     o_v=base_node;
     a_v=vic_rec[left];
     oa_v=vic_rec[left+1];
    }
    else /* Cyclical-Triangle as described when 'continua' == 2 */
    {
     o_v=base_node;
     a_v=vic_rec[left];
     oa_v=vic_rec[0];
    }
    skip=0; /* skip==1 if one among three current nodes
               does not belong to constraint I */
    if (o_v<lcc[I] || o_v>=lcc[I+1] ||
 a_v<lcc[I] || a_v>=lcc[I+1] ||
 oa_v<lcc[I] || oa_v>=lcc[I+1] ) skip=1;
    if (skip==0) /* All nodes belong to constraint I */
    {
     permutations(&o_v,&a_v,&oa_v);
     if (which_side(x[oa_v-1],y[oa_v-1],
      x[o_v-1],y[o_v-1],x[a_v-1],y[a_v-1])==
  dentro_weak)
       {
 do       /* left+1 left rotations */
  {
   temp_index=vic_rec[0];
   for (cont_vic=0;cont_vic<M-1;cont_vic++)
      vic_rec[cont_vic]=vic_rec[cont_vic+1];
   vic_rec[M-1]=temp_index;
   left--;
  } while (left>-1);
 M++;
 vic_rec[M-1]=0;
 mode=2; /* The cell becomes open */
 continua=0;
       }
      else left=left+1;
    } /* Fine if su skip */
    else left=left+1;
    if (mode!=2) /* If mode==2 there must exist a sure exit */
    {
     if (left==M-1) continua=2;
     /*
     ** Repeating again the loop remembering the particular case
     ** for the triangle closing the cell (closed cell) assigning
     ** the value 2 to 'continua'.
     ** The exit condition becomes then 'left>M-1' instead of
'left>=M-1'
     */
     if (left>M-1)
       {
 left=0;
 mode=0;
 /* Success.
           I shall handle the segment of 'vic_rec' going from
           'left' to 'M-1' */
 continua=0;
       }
    } /* ending the case where mode <> 2 */
   } /* end 'while' loop over 'continua' */
  } /* end case whre 'mode==1' */
  if (mode==2) /* Open cell */
  {
   /* RECURSIVE ELABORATION OF LEFT PART */
   left=0;  /* Left pointer to the second vertex of the triangle */
   continua=1;
   while(continua)
   {
    o_v=base_node;
    a_v=vic_rec[left];
    oa_v=vic_rec[left+1];
    skip=0; /* skip==1 if one among three current nodes
               does not belong to constraint I */
    if (o_v<lcc[I] || o_v>=lcc[I+1] ||
 a_v<lcc[I] || a_v>=lcc[I+1] ||
 oa_v<lcc[I] || oa_v>=lcc[I+1] ) skip=1;
    if (skip==0)  /* All nodes belong to constraint I */
     {
      permutations(&o_v,&a_v,&oa_v);
      if (which_side(x[oa_v-1],y[oa_v-1],
       x[o_v-1],y[o_v-1],x[a_v-1],y[a_v-1])==
   dentro_weak)
  {
   left=left+1;
   if (left>M-3)
     {
      printf("Error: probably there are nodes\n");
      printf("inside constraint regions.\n");
      exit(1);
     }
  }
       else {continua=0;} /* Success. Triangle to be accepted */
     } /* Fine if skip==0 */
    else {continua=0;} /* Success. Triangle to be accepted */
   } /* end 'while' loop over 'continua' */
   /* RECURSIVE ELABORATION OF RIGHT PART */
   right=M-3;  /* Right pointer to the second vertex of the triangle */
   continua=1;
   if (left>=right) mode=0;
    else while(continua)
   {
    o_v=base_node;
    a_v=vic_rec[right];
    oa_v=vic_rec[right+1];
    skip=0; /* skip==1 if one among three current nodes
               does not belong to constraint I */
    if (o_v<lcc[I] || o_v>=lcc[I+1] ||
 a_v<lcc[I] || a_v>=lcc[I+1] ||
 oa_v<lcc[I] || oa_v>=lcc[I+1] ) skip=1;
    if (skip==0)  /* All nodes belong to constraint I */
     {
      permutations(&o_v,&a_v,&oa_v);
      if (which_side(x[oa_v-1],y[oa_v-1],
       x[o_v-1],y[o_v-1],x[a_v-1],y[a_v-1])==
   dentro_weak)
  {
   vic_rec[M-2]=0;
   M=M-1;
   right=right-1;
   if (right<0)
     {
      printf("Error: probably there are nodes\n");
      printf("inside constraint regions.\n");
      exit(1);
     }
  }
       else {continua=0; mode=0;} /* Success. Triangle to be accepted */

     } /* Fine if skip==0 */
    else {continua=0; mode=0;} /* Successo. Triangle to be accepted */
   } /* end 'while' loop over 'continua' */
  }  /* end case where 'mode==2' */
  if (mode==0) /* output */
  {     /* Handling the segment of 'vic_rec'
           going from 'left' to 'M-1' */
   fprintf(out,"%7ld",base_node-1);
   for (cont_vic=left;cont_vic<=M-2;cont_vic++)
    fprintf(out,"%7ld",vic_rec[cont_vic]-1);
   if (vic_rec[M-1]!=0)
    {
     fprintf(out,"%7ld",vic_rec[M-1]-1);
     fprintf(out,"%7ld",vic_rec[left]-1);
    }
   fprintf(out,"%7ld\n",-1L);
  }
 } /* end main loop over 'cont_N' */
 fprintf(out,"B\n");
 fclose(out);
}

geometric_side which_side(xp,yp,xi,yi,xj,yj)
double xp,yp,xi,yi,xj,yj;
{
 if ( (xj-xi)*(yp-yi)-(xp-xi)*(yj-yi) >= -EPS_ALLIN) return
(dentro_weak);
      else return (fuori_strong);
}

void permutations(o_v,a_v,oa_v)
long int *o_v, *a_v, *oa_v;
    {
     long int temp_v;

     if (*o_v>*a_v)
       {temp_v=*a_v; *a_v=*o_v; *o_v=temp_v;}
     if (*o_v>*oa_v)
       {temp_v=*oa_v; *oa_v=*o_v; *o_v=temp_v;}
     if (*a_v>*oa_v)
       {temp_v=*oa_v; *oa_v=*a_v; *a_v=temp_v;}
    } /* end permutations */

