/*
** PWS_D_A.C 
**
** AUTHORS: 
**
**   Maria MORANDI CECCHI               Stefano DE MARCHI,            
**   University of Padua, Italy         University of Udine, Italy
**   email: mcecchi@math.unipd.it       email: demarchi@dimi.uniud.it
**   
**                       Damiano FASOLI
**                       Verona Software Srl, Italy 
**                       email: vrsoft@sis.it
**
**
**
** REVISION DATE: May, 1999  
**
** MODULES CALLED: None 
**
** ------------------------------------------------------------------------
**
** SUBROUTINES AND FUNCTIONS DESCRIPTION:
**
** >>>>>>>>>>>>>>>>>
**
** double derivecptpwsa_v(int i,int j)
**
** GLOBAL VARIABLES USED: u1,v1,u2,v2,u3,v3,u4,v4
**
** This function computes the derivative of the control point d_i 
** ('i' is in the range [0,18])
** of the Powell-Sabin element of A-Type as a function of the partial
** derivatives zu1,zv1,zu2,zv2,zu3,zv3 with respect to the 'j'-th partial
** derivative in the specified order from 0 to 5.
** The triangle over which the function operates is described by the
** vertices (u1,v1), (u2,v2), (u3,v3), while (u4,v4) is the center of the
** circumscribed circle.
**
** Inputs
**        i: the point index (between 0 and 18);
**        j: the derivative index (between 0 and 5);
**
** Output
**        derivecptpwsa_v: d d_i/ d^j .
**
**
** >>>>>>>>>>>>>>>>>
** 
** double compute_d_j_pwsa(int j,int i)
** 
** GLOBAL VARIABLES USED: u1,v1,u2,v2,u3,v3,z1,z2,z3,u4,v4
**
** This function computes the control point d_j ('j' is in the range [0,18])
** of the Powell-Sabin element of A-Type
** assigning to the unknown parameters zu1,zv1,zu2,zv2,zu3,zv3 the
** value given by the 'i'-th vector of the canonical basis of R^6.
** (In the body of the function the vectors of the canonical basis are
** described by e0,e1, ..., e5). 
** The triangle over which the function operates is described by the
** vertices (u1,v1), (u2,v2), (u3,v3), while (u4,v4) is the center of the
** circumscribed circle.
** The parameters z1,z2,z3 are the values of the triangular patch 
** relative to the vertices V1,V2,V3 that are, by end-point interpolation,
** the values of the control points d0,d4,d8.
**
** Inputs
**        j: the point index (between 0 and 18);
**        i: the index of the element of the canonical basis 
**           (between 0 and 5);
**
** Output
**        compute_d_j_pwsa: the value of d_j.
**
**
** >>>>>>>>>>>>>>>>>
**
** double compute_d_j_pwsa_null(int j)
**
** GLOBAL VARIABLES USED: u1,v1,u2,v2,u3,v3,u4,v4,z1,z2,z3.
** 
** This function computes the control point d_j ('j' is in the range [0,18]) 
** of the Powell-Sabin element of A-Type assigning to the unknown parameters
** zu1,zv1,zu2,zv2,zu3,zv3 the value 0.
** The triangle over which the function operates is described by the
** vertices (u1,v1), (u2,v2), (u3,v3), while (u4,v4) is the center of the
** circumscribed circle.
** The parameters z1,z2,z3 are the values of the triangular patch 
** corresponding to the vertices V1,V2,V3 that are, by end-point 
** interpolation, the values of the control points d0,d4,d8.
**
** Input
**        j: the point index (between 0 and 18);
** Output
**        compute_d_j_pwsa_null: the value of d_j at 0.
**
**
** -------------------------------------------------------------------------
*/

extern double u1,v1,u2,v2,u3,v3,z1,z2,z3,u4,v4;

double derivecptpwsa_v(i,j)
int i,j;
{
 /* Beginning of derivation by lookup table */
 if (i==0)     /* d0 */
 {
  return(0.);
 }
 else if (i==1)     /* d1 */
 {
  if (j==0) return((u2-u1)/4);
  if (j==1) return((v2-v1)/4);
 }
 else if (i==2)     /* d2 */
 {
  if (j==0) return((u2-u1)/8);
  if (j==1) return((v2-v1)/8);
  if (j==2) return((u1-u2)/8);
  if (j==3) return((v1-v2)/8);
 }
 else if (i==3)     /* d3 */
 {
  if (j==2) return((u1-u2)/4);
  if (j==3) return((v1-v2)/4);
 }
 else if (i==4)     /* d4 */
 {
  return(0.);
 }
 else if (i==5)     /* d5 */
 {
  if (j==2) return((u3-u2)/4);
  if (j==3) return((v3-v2)/4);
 }
 else if (i==6)     /* d6 */
 {
  if (j==2) return((u3-u2)/8);
  if (j==3) return((v3-v2)/8);
  if (j==4) return((u2-u3)/8);
  if (j==5) return((v2-v3)/8);
 }
 else if (i==7)     /* d7 */
 {
  if (j==4) return((u2-u3)/4);
  if (j==5) return((v2-v3)/4);
 }
 else if (i==8)     /* d8 */
 {
  return(0.);
 }
 else if (i==9)     /* d9 */
 {
  if (j==4) return((u1-u3)/4);
  if (j==5) return((v1-v3)/4);
 }
 else if (i==10)     /* d10 */
 {
  if (j==0) return((u3-u1)/8);
  if (j==1) return((v3-v1)/8);
  if (j==4) return((u1-u3)/8);
  if (j==5) return((v1-v3)/8);
 }
 else if (i==11)     /* d11 */
 {
  if (j==0) return((u3-u1)/4);
  if (j==1) return((v3-v1)/4);
 }
 else if (i==12)     /* d12 */
 {
  if (j==0) return((u4-u1)/2);
  if (j==1) return((v4-v1)/2);
 }
 else if (i==13)     /* d13 */
 {
  if (j==0) return((u4-u1)/4);
  if (j==1) return((v4-v1)/4);
  if (j==2) return((u4-u2)/4);
  if (j==3) return((v4-v2)/4);
 }
 else if (i==14)     /* d14 */
 {
  if (j==2) return((u4-u2)/2);
  if (j==3) return((v4-v2)/2);
 }
 else if (i==15)     /* d15 */
 {
  if (j==2) return((u4-u2)/4);
  if (j==3) return((v4-v2)/4);
  if (j==4) return((u4-u3)/4);
  if (j==5) return((v4-v3)/4);
 }
 else if (i==16)     /* d16 */
 {
  if (j==4) return((u4-u3)/2);
  if (j==5) return((v4-v3)/2);
 }
 else if (i==17)     /* d17 */
 {
  if (j==0) return((u4-u1)/4);
  if (j==1) return((v4-v1)/4);
  if (j==4) return((u4-u3)/4);
  if (j==5) return((v4-v3)/4);
 }
 else if (i==18)     /* d18 */
 {
  if (j==0) return((u2*(v3-v4)+u3*(v4-v2)+u4*(v2-v3))*(u4-u1)/
		   (2*(u1*(v2-v3)+u2*(v3-v1)+u3*(v1-v2))));
  if (j==1) return((v4-v1)*(u2*(v3-v4)+u3*(v4-v2)+u4*(v2-v3))/
		   (2*(u1*(v2-v3)+u2*(v3-v1)+u3*(v1-v2))));
  if (j==2) return((u2-u4)*(u1*(v3-v4)+u3*(v4-v1)+u4*(v1-v3))/
		   (2*(u1*(v2-v3)+u2*(v3-v1)+u3*(v1-v2))));
  if (j==3) return((v2-v4)*(u1*(v3-v4)+u3*(v4-v1)+u4*(v1-v3))/
		   (2*(u1*(v2-v3)+u2*(v3-v1)+u3*(v1-v2))));
  if (j==4) return((u4-u3)*(u1*(v2-v4)+u2*(v4-v1)+u4*(v1-v2))/
		   (2*(u1*(v2-v3)+u2*(v3-v1)+u3*(v1-v2))));
  if (j==5) return((v4-v3)*(u1*(v2-v4)+u2*(v4-v1)+u4*(v1-v2))/
		   (2*(u1*(v2-v3)+u2*(v3-v1)+u3*(v1-v2))));
 }
 /* security */
 return(0.);
}

double compute_d_j_pwsa(j,i)
int j,i;
{
 /* Beginning of answers by lookup table */
 if (i==0) /* Computation of dj(e0) */
 {
  if (j==0) return(z1);
  if (j==1) return(-(u1-u2-4*z1)/4);
  if (j==2) return(-(u1-u2-4*(z1+z2))/8);
  if (j==3) return(z2);
  if (j==4) return(z2);
  if (j==5) return(z2);
  if (j==6) return((z2+z3)/2);
  if (j==7) return(z3);
  if (j==8) return(z3);
  if (j==9) return(z3);
  if (j==10) return(-(u1-u3-4*(z1+z3))/8);
  if (j==11) return(-(u1-u3-4*z1)/4);
  if (j==12) return(-(u1-u4-2*z1)/2);
  if (j==13) return(-(u1-u4-2*(z1+z2))/4);
  if (j==14) return(z2);
  if (j==15) return((z2+z3)/2);
  if (j==16) return(z3);
  if (j==17) return(-(u1-u4-2*(z1+z3))/4);
  if (j==18) return(-(u1*(u2*(v3-v4)+u3*(v4-v2)+u4*(v2-v3)-2*(v2*z3-v3*z2+v4*(z2-z3)))+u2*(2*(v1*z3-v3*z1+v4*(z1-z3))-u4*(v3-v4))+u3*(u4*(v2-v4)-2*(v1*z2-v2*z1+v4*(z1-z2)))+u4*(2*(v1*(z2-z3)+v2*(z3-z1)+v3*(z1-z2))-u4*(v2-v3)))/(2*(u1*(v2-v3)+u2*(v3-v1)+u3*(v1-v2))));
  }
 else if (i==1) /* Computation of dj(e1) */
 {
  if (j==0) return(z1);
  if (j==1) return(-(v1-v2-4*z1)/4);
  if (j==2) return(-(v1-v2-4*(z1+z2))/8);
  if (j==3) return(z2);
  if (j==4) return(z2);
  if (j==5) return(z2);
  if (j==6) return((z2+z3)/2);
  if (j==7) return(z3);
  if (j==8) return(z3);
  if (j==9) return(z3);
  if (j==10) return(-(v1-v3-4*(z1+z3))/8);
  if (j==11) return(-(v1-v3-4*z1)/4);
  if (j==12) return(-(v1-v4-2*z1)/2);
  if (j==13) return(-(v1-v4-2*(z1+z2))/4);
  if (j==14) return(z2);
  if (j==15) return((z2+z3)/2);
  if (j==16) return(z3);
  if (j==17) return(-(v1-v4-2*(z1+z3))/4);
  if (j==18) return((2*u1*(v2*z3-v3*z2+v4*(z2-z3))-u2*(v1*(v3-v4+2*z3)-v3*(v4+2*z1)+v4*(v4+2*(z1-z3)))+u3*(v1*(v2-v4+2*z2)-v2*(v4+2*z1)+v4*(v4+2*(z1-z2)))-u4*(v1*(v2-v3+2*(z2-z3))-v2*(v4+2*(z1-z3))+v3*(v4+2*(z1-z2))))/(2*(u1*(v2-v3)+u2*(v3-v1)+u3*(v1-v2))));
 }
 else if (i==2) /* Computation of dj(e2) */
 {
  if (j==0) return(z1);
  if (j==1) return(z1);
  if (j==2) return((u1-u2+4*z1+4*z2)/8);
  if (j==3) return((u1-u2+4*z2)/4);
  if (j==4) return(z2);
  if (j==5) return(-(u2-u3-4*z2)/4);
  if (j==6) return(-(u2-u3-4*(z2+z3))/8);
  if (j==7) return(z3);
  if (j==8) return(z3);
  if (j==9) return(z3);
  if (j==10) return((z1+z3)/2);
  if (j==11) return(z1);
  if (j==12) return(z1);
  if (j==13) return(-(u2-u4-2*(z1+z2))/4);
  if (j==14) return(-(u2-u4-2*z2)/2);
  if (j==15) return(-(u2-u4-2*(z2+z3))/4);
  if (j==16) return(z3);
  if (j==17) return((z1+z3)/2);
  if (j==18) return((u1*(u2*(v3-v4)+u4*(v4-v3)+2*(v2*z3-v3*z2+v4*(z2-z3)))-u2*(u3*(v1-v4)+u4*(v3-v1)+2*(v1*z3-v3*z1+v4*(z1-z3)))+u3*(u4*(v1-v4)+2*(v1*z2-v2*z1+v4*(z1-z2)))-u4*(u4*(v1-v3)+2*(v1*(z2-z3)+v2*(z3-z1)+v3*(z1-z2))))/(2*(u1*(v2-v3)+u2*(v3-v1)+u3*(v1-v2))));
 }
 else if (i==3) /* Computation of dj(e3) */
 {
  if (j==0) return(z1);
  if (j==1) return(z1);
  if (j==2) return((v1-v2+4*z1+4*z2)/8);
  if (j==3) return((v1-v2+4*z2)/4);
  if (j==4) return(z2);
  if (j==5) return(-(v2-v3-4*z2)/4);
  if (j==6) return(-(v2-v3-4*(z2+z3))/8);
  if (j==7) return(z3);
  if (j==8) return(z3);
  if (j==9) return(z3);
  if (j==10) return((z1+z3)/2);
  if (j==11) return(z1);
  if (j==12) return(z1);
  if (j==13) return(-(v2-v4-2*(z1+z2))/4);
  if (j==14) return(-(v2-v4-2*z2)/2);
  if (j==15) return(-(v2-v4-2*(z2+z3))/4);
  if (j==16) return(z3);
  if (j==17) return((z1+z3)/2);
  if (j==18) return((u1*(v2*(v3-v4+2*z3)-v3*(v4+2*z2)+v4*(v4+2*(z2-z3)))-2*u2*(v1*z3-v3*z1+v4*(z1-z3))-u3*(v1*(v2-v4-2*z2)+v2*(2*z1-v4)+v4*(v4+2*(z2-z1)))+u4*(v1*(v2-v4+2*(z3-z2))-v2*(v3+2*(z3-z1))+v3*(v4+2*(z2-z1))))/(2*(u1*(v2-v3)+u2*(v3-v1)+u3*(v1-v2))));
 }
 else if (i==4) /* Computation of dj(e4) */
 {
  if (j==0) return(z1);
  if (j==1) return(z1);
  if (j==2) return((z1+z2)/2);
  if (j==3) return(z2);
  if (j==4) return(z2);
  if (j==5) return(z2);
  if (j==6) return((u2-u3+4*z2+4*z3)/8);
  if (j==7) return((u2-u3+4*z3)/4);
  if (j==8) return(z3);
  if (j==9) return((u1-u3+4*z3)/4);
  if (j==10) return((u1-u3+4*z1+4*z3)/8);
  if (j==11) return(z1);
  if (j==12) return(z1);
  if (j==13) return((z1+z2)/2);
  if (j==14) return(z2);
  if (j==15) return(-(u3-u4-2*(z2+z3))/4);
  if (j==16) return(-(u3-u4-2*z3)/2);
  if (j==17) return(-(u3-u4-2*(z1+z3))/4);
  if (j==18) return(-(u1*(u3*(v2-v4)+u4*(v4-v2)-2*(v2*z3-v3*z2+v4*(z2-z3)))-u2*(u3*(v1-v4)+u4*(v4-v1)-2*(v1*z3-v3*z1+v4*(z1-z3)))+u3*(u4*(v1-v2)-2*(v1*z2-v2*z1+v4*(z1-z2)))+u4*(2*(v1*(z2-z3)+v2*(z3-z1)+v3*(z1-z2))-u4*(v1-v2)))/(2*(u1*(v2-v3)+u2*(v3-v1)+u3*(v1-v2))));
 }
 else if (i==5) /* Computation of dj(e5) */
 {
  if (j==0) return(z1);
  if (j==1) return(z1);
  if (j==2) return((z1+z2)/2);
  if (j==3) return(z2);
  if (j==4) return(z2);
  if (j==5) return(z2);
  if (j==6) return((v2-v3+4*z2+4*z3)/8);
  if (j==7) return((v2-v3+4*z3)/4);
  if (j==8) return(z3);
  if (j==9) return((v1-v3+4*z3)/4);
  if (j==10) return((v1-v3+4*z1+4*z3)/8);
  if (j==11) return(z1);
  if (j==12) return(z1);
  if (j==13) return((z1+z2)/2);
  if (j==14) return(z2);
  if (j==15) return(-(v3-v4-2*(z2+z3))/4);
  if (j==16) return(-(v3-v4-2*z3)/2);
  if (j==17) return(-(v3-v4-2*(z1+z3))/4);
  if (j==18) return(-(u1*(v2*(v3-v4-2*z3)+v3*(2*z2-v4)+v4*(v4+2*(z3-z2)))-u2*(v1*(v3-v4-2*z3)+v3*(2*z1-v4)+v4*(v4+2*(z3-z1)))-2*u3*(v1*z2-v2*z1+v4*(z1-z2))+u4*(v1*(v3-v4+2*(z2-z3))-v2*(v3-v4+2*(z1-z3))+2*v3*(z1-z2)))/(2*(u1*(v2-v3)+u2*(v3-v1)+u3*(v1-v2))));
 }
 /* security */
 return(0.);
}

double compute_d_j_pwsa_null(j)
int j;
{
 /* Computation of dj(0) */
 {
  if (j==0) return(z1);
  if (j==1) return(z1);
  if (j==2) return((z1+z2)/2);
  if (j==3) return(z2);
  if (j==4) return(z2);
  if (j==5) return(z2);
  if (j==6) return((z2+z3)/2);
  if (j==7) return(z3);
  if (j==8) return(z3);
  if (j==9) return(z3);
  if (j==10) return((z1+z3)/2);
  if (j==11) return(z1);
  if (j==12) return(z1);
  if (j==13) return((z1+z2)/2);
  if (j==14) return(z2);
  if (j==15) return((z2+z3)/2);
  if (j==16) return(z3);
  if (j==17) return((z1+z3)/2);
  if (j==18) return((u1*(v2*z3-v3*z2+v4*(z2-z3))-u2*(v1*z3-v3*z1+v4*(z1-z3))+u3*(v1*z2-v2*z1+v4*(z1-z2))-u4*(v1*(z2-z3)+v2*(z3-z1)+v3*(z1-z2)))/(u1*(v2-v3)+u2*(v3-v1)+u3*(v1-v2)));
 }
  /* security */
  return(0.);
}

