/*
** LABSUP3D.H 
**
** AUTHORS: 
**
**         Damiano FASOLI and Maria MORANDI CECCHI
**         University of Padua, Italy
**         
**         Stefano DE MARCHI,
**         University of Udine, Italy
**
**
** REVISION DATE : July, 1998  
**
** MODULES CALLED: None 
**
** -------------------------------------------------------------------------
**
** HEADER FILE FOR LABSUP3D
**
** -------------------------------------------------------------------------
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include <malloc.h>
#include <GL/gl.h>
#include <GL/glu.h>
#ifdef LABSUP3D_AUX
	#include <GL/aux.h>
#endif
#ifdef LABSUP3D_GLUT
	#include <GL/glut.h>
#endif

#define PI 3.14159265358979323846
#define MAXDIM 3
#define MAXCALC 10000
/* Maximum number of control points per triangle (micro-triangle) */ 
#define EPS_ALLIN 1.e-13 
/* it is like zero (used to test for collinear points) */              
#define MAXORD 51
#define MINAMPBOX 1.e-7 /* Lowest bound for 'minmaxbox' widths */
#define NAME_FILE_BUFFER_LEN 100
#define MAX_NUM_NODI 100000
#define MAX_CPT_NUMBER_C1 31
#define WIDTH 20   /* Format width of real number written to files */
#define PREC 10    /* Decimal precision of real number written to files */

#define LEN_STRING_BUFFER 50

/*
** The constant MAXORD is the maximum number of interpolation points
** used by a computed Bezier patch (I need a MAXORD*MAXORD matrix)
*/

/* Global variables */

 #ifdef LABSUP3D_AUX
   Display *MainDisplay;
   Window MainWindow; 
 #endif

 char MainName[NAME_FILE_BUFFER_LEN];
 char nome_tri_file[NAME_FILE_BUFFER_LEN];
 char output_ris_nome[NAME_FILE_BUFFER_LEN];
 FILE *output_ris;
 double x[MAX_NUM_NODI],y[MAX_NUM_NODI],z[MAX_NUM_NODI];
 double zx[MAX_NUM_NODI], zy[MAX_NUM_NODI],
	zxx[MAX_NUM_NODI], zxy[MAX_NUM_NODI], zyy[MAX_NUM_NODI];
 long int numero_punti,numero_triangoli;
 long int numero_triangoli_glob, numero_triangoli_loc; 
 /* Drr Triangolazione_Glob and Triangolazione_Loc */  
 int dim=3,numln,n,l,err,numpt;
 float zoomfactor=1.,
       zoomscalefactor=1.5; /* Zoom factor per step */
 int generalfactlist[MAXORD];
 double (*calcpt)=NULL;
 double u[MAXORD],v[MAXORD],itpt[MAXORD][MAXDIM],cpt[MAXORD][MAXDIM];
 double minbox[MAXDIM],maxbox[MAXDIM]; /* for Bezier */
 double minbox_t[3],maxbox_t[3];       /* for C1 interpolation */
 double minbox_t_glob[2],maxbox_t_glob[2];
 double minbox_t_loc[2],maxbox_t_loc[2];
 /* 
 ** The actual 'minmaxbox' is defined by minbox_t and maxbox_t.
 ** After reading the data, minbox_t_glob and maxbox_t_glob are setted,
 ** minbox_t and maxbox_t are initialized to minbox_t_glob and maxbox_t_glob.
 ** Any eventual request to work with subtriangulations will make use of
 ** minbox_t_loc and maxbox_t_loc, later copied to minbox_t and maxbox_t.
 ** The third component (the 'z' coordinate), that does not appear in minbox_t_glob 
 ** and maxbox_t_glob, minbox_t_loc and maxbox_t_loc, is only used for computations by 
 ** minbox_t and maxbox_t.
 */  
 double tri_left,tri_right,tri_down,tri_up; /* Triangulation window */
 double surf_left,surf_right,surf_down,surf_up; /* Window bezier-C1 */
 double ucalcpar[MAXCALC],vcalcpar[MAXCALC];
 GLdouble vrp[3],vpn[3],vuv[3];
 GLdouble parsize=0.;

 struct indextype {int i; int j; int k;};
 struct indextype cptindex,lista_ass[MAXORD];
 int itptbpresenza=0, cptbpresenza=0; /* security */
 int itpttpresenza=0, cpttpresenza=0; /* security */
 int draw_flag=0;
 /* draw_flag:
    0 don't draw
    1 Bezier drawing
    2 triangulation
    3 C1 Bezier patches over a triangolation */
 int depth_flag,light_flag=0,drawminmaxbox_flag=1;

 int WINWIDTH=500,WINHEIGHT=500;

 int amp=10,prec=5;
 float rgb_red_line=0., rgb_green_line=1. ,rgb_blue_line=1.,
       rgb_red_fill=0. ,rgb_green_fill=0. , rgb_blue_fill=1. ,
       rgb_red_sfondo=0.4, rgb_green_sfondo=0.5, rgb_blue_sfondo=0.5; 

 /* structures for triangulation and convex hull */
 typedef enum {dentro_weak, fuori_strong} geometric_side;
 typedef enum {Delaunay_triang,sigma_triang} triang_type;
 typedef struct {long int v1; long int v2;} edge;
 typedef struct {long int v1; long int v2; long int v3;
		triang_type tipo;} triang;
 struct edge_list {edge bordo;
		   struct triang_list *source_triang;
		   struct edge_list *next;};
 struct triang_list {triang triangolo;
		     struct triang_list *confine_v1v2;
		     struct triang_list *confine_v2v3;
		     struct triang_list *confine_v3v1;
		     struct triang_list *next;};

 struct triang_list *Triangolazione, *Triangolazione_Glob, *Triangolazione_Loc;
 struct edge_list *Inviluppo_convesso; 
 /* 
 ** The data declared here are globals for the triangulation.
 ** The program, when reading data, reads the whole triangulation and stores it in the
 ** the list pointed by 'Triangolazione_Glob', while 'Triangolazione' (which defines 
 ** the active triangulation) is set to it.
 ** Later, each time one wishes to work with a subtriangulation, the program creates
 ** (before it cleans the memory) the triangulation pointed by 'Triangolazione_Loc' 
 ** visiting the one pointed by 'Triangolazione_Glob', 
 ** while it sets 'Triangolazione' to 'Triangolazione_Loc'.
 ** All these pointers are set to NULL at the beginning. 
 */

 /* structures for storing control points per patch */
 typedef struct {int itpmethod; double points[MAX_CPT_NUMBER_C1];} cptt_type;
  /* itpmethod:
  ** 1 Clough-Tocher with normal linear derivatives.
  ** 2 Powell-Sabin (A-type) (A-PS)
  ** 3 Q18
  ** 4 Powell-Sabin (B-type) (B-PS)
  ** MAX_CPT_NUMBER_C1 instead is the maximum number of points (case of B-PS)
  **
  ** cpttpresenza (if not zero)
  ** 1 Clough-Tocher with linear normal derivatives.
  ** 2 Powell-Sabin (both types)
  ** 3 Q18
  */
 struct cptt_list {cptt_type cptt; struct cptt_list *next;};
 
 struct cptt_list *Punti_controllo; /* Set to NULL when program begins */
 struct indextype lista_ass_t[31];
 /* end of definition for structures for storing control points per patch */

/* Prototypes of functions used */
int getmat(),putmat(),fputmat(),
    copymatrix(),triitpbez(),trihornbez(),minmaxbox(),
    listindex(),gsspvt(),circoscrivi();
double piano(), triangle_max_angle();
void minandmax();
void genfact(),gengeneralfact(),ass();
void writemenu(),read_triang(),set_ucalcpar_vcalcpar(),
     tribezier(),tricloughtocher(),tripowellsabin(),triq18(),
     triinputitptb(),trimodificaitptb(),
     trioutputitptb(),trioutputcptb(),
     triinputitptt(),trimagnify(),
     trioutputitptt(),trioutputcptt(),selectsubtriang(),
     settridisegno(),settriang(),free_triang_list(),free_edge_list(),
     tridisegno(),options(),free_cptt_list(),
     output_file_itptb(),output_file_cptb(), 
     output_file_itptt(),output_file_cptt(),
     output_file_calcpt();

void glinitmygraph(),glsetmyoptions(),setmyglcolor(),
     glmyrotate(),glvbez3d(),glvtriang(),
	 drawminmaxbox(),computeNormal(),
     glswitchdepth(),glswitchlight(),glswitchbox(),
	 glvbezt3d(),setlightparameter(),
     increase_zoom(),decrease_zoom(),compute_view_points(),
     printbezt3d(),printselectionborder();
static void glmyreshape();
static GLenum glmouseaction();

#ifdef LABSUP3D_GLUT
	/* Glut Callbacks  */
	void KeyboardFuncCallBack_glut(unsigned char, int, int);
	void SpecialFuncCallBack_glut(int,int,int);
	void MouseFuncCallBack_glut(int,int,int,int);
#endif
