/*
** GRAPHSUP.C
**
** AUTHORS: 
**
**   Maria MORANDI CECCHI               Stefano DE MARCHI,            
**   University of Padua, Italy         University of Udine, Italy
**   email: mcecchi@math.unipd.it       email: demarchi@dimi.uniud.it
**   
**                       Damiano FASOLI
**                       Verona Software Srl, Italy 
**                       email: vrsoft@sis.it
**
**
** REVISION DATE: May, 1999
**
** MODULES CALLED: None 
**
** -------------------------------------------------------------------------
** SUBROUTINES AND FUNCTIONS DESCRIPTION:
**
** >>>>>>>>>>>>>>>
**
** static void glmyreshape(int width,int height)
**
** Sets the viewport of graphic window to the new window size after a resize event
**
** >>>>>>>>>>>>>>>
**
** void glinitmygraph()
**
** Initializes graphic window
**
** >>>>>>>>>>>>>>>
**
** void glswitchdepth()
**
** Switches on or switches off depth buffer (Z-buffer) in graphic window
**
** >>>>>>>>>>>>>>>
**
** void glswitchlight()
** 
** Switches on or switches off directional light in graphic window. 
** When it switches on the light it asks the user to input x,y,z positions for the
** the light source.
**
** >>>>>>>>>>>>>>>>>
**
** void glswitchbox()
**
** Switches on or switches off the drawing of the box surrounding the surface.
**
** >>>>>>>>>>>>>>>>>
**
** void glsetmyoptions(GLdouble parsize, GLdouble[] vrp,
**                     GLdouble[] vpn,GLdouble[] vuv,int mode)
**
** GLOBALS USED: surf_left, surf_right, surf_down, surf_up which define the clipping
** of the graphic window over the viewing plane (with axes parallel to the graphic
** window ones).
** When mode==0 the function works in a 'strong' way restoring graphic window saved bounds
** regardless active zoom windows.
** When mode==1 the function works in a 'weak' way setting the bounds for the
** viewing window using globals surf_left, surf_right, surf_down, surf_up.
**
** >>>>>>>>>>>>>>>>>>>>>>>
**
** void setlightparameter()
**
** It sets light parameters.
**
** >>>>>>>>>>>>>>>>>>>>>>>
**
** void setmyglcolor()
**
** Sets colors using globals 
**
** >>>>>>>>>>>>>>>>>>>>>>>
**
** void glvbez3d(double[][MAXDIM] calcpt)
**
** Draws a Bezier patch connecting by lines with the same barycentric coordinates the
** points computed for the patch in the array parameter calcpt.
** This function uses colors for the background of graphic window, for lines onto
** the surface and for filling the surface as specified by the program options
** which can be changed by the user.
**
** >>>>>>>>>>>>>>>>>>>>>>>
**
** void glvbezt3d(double[][MAXDIM] calcpt)
**
** Draws a C1 surface made up of Bezier patches (piecewise Bezier patches) calling
** the function glvbez3d() for each patch involved.
** This function uses colors for the background of graphic window, for lines onto
** the surface and for filling the surface as specified by the program options
** which can be changed by the user.
**
** >>>>>>>>>>>>>>>>>>>>>>>
**
** static GLenum glmouseaction(int mouseposx, int mouseposy, GLenum pulsante)
**
** This function handles mouse events of graphic window.
**  
** >>>>>>>>>>>>>>>>>>>>>>>
**
** void increase_zoom()
**
** Performs a central zoom-in in graphic window using the ratio
** specified by the program options which can be changed by the user. 
**
** >>>>>>>>>>>>>>>>>>>>>>>
**
** void decrease_zoom()
**
** Performs a central zoom-out in graphic window using the ratio
** specified by the program options which can be changed by the user. 
**
** >>>>>>>>>>>>>>>>>>>>>>>
**
** void glvtriang()
**
** Draws the triangulation previously read during input stage.
** This function uses colors for the background of graphic window, for lines of
** triangulation edges as specified by the program options
** which can be changed by the user.
**
** >>>>>>>>>>>>>>>>>>>>>>
**
** void drawminmaxbox(double minb[], double maxb[])
** 
** Draws the smallest box containing all control points for the surface being
** rendered.
**
** >>>>>>>>>>>>>>>>>>>>>>
**
** void computeNormal(double calcpt[][MAXDIM],int s1,int s2,int s3,GLfloat nrm[])
**
** Computes in nrm the normal vector for the triangle having for vertices
** the three points calcpt[s1], calcpt[s2] and calcpt[s3]. 
** The normal vector is computed by the normalized cross-product between
** (calcpt[s3]-calcpt[s1]) and (calcpt[s2]-calcpt[s1]).
**
** >>>>>>>>>>>>>>>>>>>>>>
*/

#ifdef LABSUP3D_AUX
	#define LABSUP3D_LEFT_BUTTON AUX_LEFTBUTTON
	#define LABSUP3D_MIDDLE_BUTTON AUX_MIDDLEBUTTON
	#define LABSUP3D_RIGHT_BUTTON AUX_RIGHTBUTTON
	#define LABSUP3D_SWAPBUFFERS auxSwapBuffers()
#endif
#ifdef LABSUP3D_GLUT
	#define LABSUP3D_LEFT_BUTTON GLUT_LEFT_BUTTON
	#define LABSUP3D_MIDDLE_BUTTON GLUT_MIDDLE_BUTTON
	#define LABSUP3D_RIGHT_BUTTON GLUT_RIGHT_BUTTON
	#define LABSUP3D_SWAPBUFFERS glutSwapBuffers()
#endif

static void glmyreshape(width,height)
int width,height;
{
 WINWIDTH=width;
 WINHEIGHT=height;
 glViewport(0, 0, WINWIDTH-1, WINHEIGHT-1);
}
 

void glinitmygraph()
  {
	#ifdef LABSUP3D_AUX
		auxInitPosition(0, 0, WINWIDTH, WINHEIGHT);
		auxInitDisplayMode((GLenum) AUX_DEPTH|AUX_DOUBLE|AUX_RGB);

		if (auxInitWindow("LABSUP3D: Graphic window") == GL_FALSE) {
		auxQuit();
		}
		MainDisplay=(Display*)auxXDisplay(); 
		MainWindow=auxXWindow(); 
	#endif

	#ifdef LABSUP3D_GLUT
		glutInitWindowPosition(0,0);
		glutInitWindowSize(WINWIDTH,WINHEIGHT);
		glutInitDisplayMode((unsigned int) GLUT_DEPTH|GLUT_DOUBLE|GLUT_RGB);

		if (glutCreateWindow("LABSUP3D: Graphic window") == GL_FALSE) {
		exit(0);
		}
	#endif

    glViewport(0, 0, WINWIDTH-1, WINHEIGHT-1);
    glLoadIdentity();
    glDisable(GL_DEPTH_TEST); depth_flag=0;   
    glDisable(GL_LINE_SMOOTH);  
  }

void glswitchdepth()
{
 /* float ThickFactor; */

 if ((draw_flag!=1) && (draw_flag!=3)) return;
 if (depth_flag==0)
   {
    glDepthFunc(GL_LEQUAL);
    glEnable(GL_DEPTH_TEST);
    depth_flag=1;
    glClearDepth(1.0);
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);  
    glsetmyoptions(parsize,vrp,vpn,vuv,1); 
    printf("Depth-buffer on.\n\n");
    writemenu();
    return;
   }
 /* return given to exit if buffer is enabled */
 if (depth_flag==1)
   {
    glDisable(GL_DEPTH_TEST);
    depth_flag=0;
    glLineWidth(1.0);
    printf("Depth-buffer off.\n\n");
    writemenu();
    return;
   }
}

void glswitchlight()
{
 if ((draw_flag!=1) && (draw_flag!=3)) return;
 if (light_flag==0) 
  {
   light_flag=1; 
   printf("Light on.\n");
   writemenu();
  }
 else
 if (light_flag==1) 
  { 
   light_flag=0;
   printf("Light off.\n");
   writemenu();
  }
}

void glswitchbox()
{
	drawminmaxbox_flag = ! drawminmaxbox_flag;
}

void glsetmyoptions(parsize,vrp,vpn,vuv,mode)
GLdouble parsize,vrp[],vpn[],vuv[];
int mode;
  {
	GLdouble temp=5./4.*parsize;
    GLfloat LightDir[4];

    glLoadIdentity();

    switch(mode)
    {
     case 0:
      surf_left=-parsize*zoomfactor;
      surf_right=parsize*zoomfactor;
      surf_down=-parsize*zoomfactor;
      surf_up=parsize*zoomfactor;      
      break;
     case 1:
       /* Using surf_left, surf_right, surf_down, surf_up current values */       
      break;
    }  
	glOrtho(surf_left,surf_right,surf_down,surf_up,parsize/4.,9.*parsize/4.);
    gluLookAt(vrp[0]+temp*vpn[0],vrp[1]+temp*vpn[1],vrp[2]+temp*vpn[2],
	          vrp[0],vrp[1],vrp[2],vuv[0],vuv[1],vuv[2]);
	/* Setting light direction looking at 'vrp' from the eye point 
	   (opposite of z axis direction) */
	LightDir[0]=0.;
	LightDir[1]=0.;
	LightDir[2]=-1.;
	LightDir[3]=0.;
	glLightfv(GL_LIGHT0,GL_POSITION,LightDir); 
  } 

void setlightparameter()
{     
    if (cptbpresenza==0 && cpttpresenza==0) return;
    if (light_flag==1)
    {   
      glEnable(GL_LIGHTING);
      glEnable(GL_LIGHT0); 
      glEnable(GL_COLOR_MATERIAL);   
    }   
    else 
    { 
      glDisable(GL_LIGHTING);
      glDisable(GL_LIGHT0);	  
      glDisable(GL_COLOR_MATERIAL);
    }
}

void setmyglcolor()
  {  
   if (depth_flag==1) { glClearDepth(1.0); glClear(GL_DEPTH_BUFFER_BIT); }
   glClearColor(rgb_red_sfondo, rgb_green_sfondo, rgb_blue_sfondo, 0.0);  
   glClear(GL_COLOR_BUFFER_BIT);
   glColor3f(rgb_red_line,rgb_green_line,rgb_blue_line);
  }
 
void glvbez3d(calcpt)
double calcpt[][MAXDIM];
{
 int s1,s2,s3,i,j;
 GLfloat nrm[4];

 if (dim!=3) return;
 /*
 ** I use GL_FRONT_BACK to avoid triangles not drawn in relation with the
 ** view-point. For example, using GL_FRONT, a plane should 
 ** be drawn or not depending on the view-point half-space.
 */ 
 if (cptbpresenza==1) 
 {
   setmyglcolor(); 
   setlightparameter(); 
   drawminmaxbox(minbox,maxbox);
 }
 for (j=0;j<=numln;j++)
  for (i=0;i<=numln-j;i++)
    {
     s1=listindex(numln+1,i,j);
     s2=listindex(numln+1,i+1,j);
     s3=listindex(numln+1,i,j+1);
     glPolygonMode(GL_FRONT_AND_BACK,GL_FILL); 
     glColor3f(rgb_red_fill,rgb_green_fill,rgb_blue_fill);
     glBegin(GL_TRIANGLES); 
      glEdgeFlag(GL_FALSE); 
	  if (light_flag==1) {
		computeNormal(calcpt,s1,s2,s3,nrm);
		glNormal3fv(nrm);
	  }
      glVertex3d(calcpt[s1][0],calcpt[s1][1],calcpt[s1][2]);
      glVertex3d(calcpt[s2][0],calcpt[s2][1],calcpt[s2][2]);   
      glVertex3d(calcpt[s3][0],calcpt[s3][1],calcpt[s3][2]);
     glEnd();
     if (light_flag==0) {
	    glPolygonMode(GL_FRONT_AND_BACK,GL_LINE); 
        glColor3f(rgb_red_line,rgb_green_line,rgb_blue_line);
        glBegin(GL_POLYGON);
          glEdgeFlag(GL_TRUE);
          glVertex3d(calcpt[s1][0],calcpt[s1][1],calcpt[s1][2]);
          glVertex3d(calcpt[s2][0],calcpt[s2][1],calcpt[s2][2]);   
          glVertex3d(calcpt[s3][0],calcpt[s3][1],calcpt[s3][2]);
        glEnd();
     }
     if (i<numln-j)
      {
       s1=s3;
       s3=listindex(numln+1,i+1,j+1);
       glPolygonMode(GL_FRONT_AND_BACK,GL_FILL); 
       glColor3f(rgb_red_fill,rgb_green_fill,rgb_blue_fill);
       glBegin(GL_TRIANGLES);
	    glEdgeFlag(GL_FALSE);  
		if (light_flag==1) {
			computeNormal(calcpt,s1,s2,s3,nrm);
			glNormal3fv(nrm);
		}
	    glVertex3d(calcpt[s1][0],calcpt[s1][1],calcpt[s1][2]);
	    glVertex3d(calcpt[s2][0],calcpt[s2][1],calcpt[s2][2]);   
	    glVertex3d(calcpt[s3][0],calcpt[s3][1],calcpt[s3][2]);
       glEnd();
       if (light_flag==0) {         
         glPolygonMode(GL_FRONT_AND_BACK,GL_LINE);            
		 glColor3f(rgb_red_line,rgb_green_line,rgb_blue_line);
         glBegin(GL_POLYGON);           
	       glEdgeFlag(GL_TRUE);        
	       glVertex3d(calcpt[s1][0],calcpt[s1][1],calcpt[s1][2]);
	       glVertex3d(calcpt[s2][0],calcpt[s2][1],calcpt[s2][2]);   
	       glVertex3d(calcpt[s3][0],calcpt[s3][1],calcpt[s3][2]);
         glEnd();
       }
      }         
    } /* end for */
 if (cptbpresenza==1) LABSUP3D_SWAPBUFFERS;
}

void glvbezt3d(calcpt)
double calcpt[][MAXDIM];
{
 struct cptt_list *Cptt_Pt;
 struct triang_list *Triang_Pt;
 long int CurrentTriangleNumber;
 int i;

  setmyglcolor(); setlightparameter(); drawminmaxbox(minbox_t,maxbox_t);
  
  Cptt_Pt=Punti_controllo;
  Triang_Pt=Triangolazione;
  CurrentTriangleNumber=0;
  while (Cptt_Pt!=NULL)
  {
   CurrentTriangleNumber=CurrentTriangleNumber+1;
   switch(Cptt_Pt->cptt.itpmethod)
   {
    case 1: /* Clough-Tocher with linear normal derivatives  */
     {
       for (i=0;i<3;++i)
          glvbez3d(&calcpt[numpt*((CurrentTriangleNumber-1)*3+i)]);
       break;
     }
    case 2: /* Powell-Sabin - A Subdivision */
     {
      /* Considering again 12 triangles to
         index the array 'calcpt' since declaration has been done
         for that case (the worst one) */
       for (i=0;i<6;++i)
          glvbez3d(&calcpt[numpt*((CurrentTriangleNumber-1)*12+i)]);
      break;
     }
    case 3: /* Q18 */
     {
       glvbez3d(&calcpt[numpt*((CurrentTriangleNumber-1)*1+0)]);
      break;
     }
    case 4: /* Powell-Sabin - B Subdivision */
     {
       for (i=0;i<12;++i)
          glvbez3d(&calcpt[numpt*((CurrentTriangleNumber-1)*12+i)]);
      break;
     }
   } /* end switch */
   Cptt_Pt=Cptt_Pt->next;
   Triang_Pt=Triang_Pt->next;
  }   /* fine while */
 LABSUP3D_SWAPBUFFERS;
}

static GLenum glmouseaction(mouseposx, mouseposy, pulsante)
int mouseposx,mouseposy;
GLenum pulsante;
/* restituisce GL_TRUE se OK, GL_FALSE se non agisce */
{
    static int WaitTriangZoom=0;
    static int WaitSurfZoom=0; 
    /* The zoom for the triangulation requires to press twice right 
    ** mouse button in order to define lower left and upper right corners.
    ** After the first hitting WaitTriangZoom becomes 1 and it will be 1 again
    ** (static) at the next execution of the function.
    ** Zoom for surfaces works in a simular way using WaitSurfZoom */
    static double tri_left_temp, tri_down_temp;
    static double surf_left_temp, surf_down_temp;
    double lambdavpn,phivpn,temp;
    char scelta;

    /* null function if there is no graphic mode */
    if (draw_flag!=1 && draw_flag!=2 && draw_flag!=3) return(GL_FALSE);
 
   if (draw_flag!=2) WaitTriangZoom=0; /* As initialization */
    else if (draw_flag!=1 && draw_flag!=3) WaitSurfZoom=0; /* As initialization */
    switch(draw_flag)
    {
     case 2:  /* Triangulation */
      if (pulsante==LABSUP3D_LEFT_BUTTON)  /* Printing point to terminal window */
        {
         printf("%*.*f %*.*f\n",
               WIDTH,PREC,
               tri_left+(double)(mouseposx)/(double)(WINWIDTH-1)*(tri_right-tri_left),
               WIDTH,PREC,
               tri_up-(double)(mouseposy)/(double)(WINHEIGHT-1)*(tri_up-tri_down));
         return(GL_FALSE);
        }
      else if (pulsante==LABSUP3D_MIDDLE_BUTTON) /* Selection of a subtriangulation */
        {
         printf("Current triangulation window bounds\n");
         printf("Horizontal: %*.*f %*.*f\n",WIDTH,PREC,tri_left,WIDTH,PREC,tri_right);
         printf("Vertical:   %*.*f %*.*f\n\n",WIDTH,PREC,tri_down,WIDTH,PREC,tri_up);
         /* Choosing between restoring initial triangulation or defining a 
            subtriangulation */
         if (Triangolazione!=Triangolazione_Glob) /* Test has a meaning */
          {
           printf("Restore initial triangulation (y/n)? ");
           scanf(" %c",&scelta);           
          }
         else scelta='n';
         switch(scelta)
         {
          case 'y': 
           minbox_t[0]=minbox_t_glob[0]; maxbox_t[0]=maxbox_t_glob[0];
           minbox_t[1]=minbox_t_glob[1]; maxbox_t[1]=maxbox_t_glob[1];
           Triangolazione=Triangolazione_Glob;
           numero_triangoli=numero_triangoli_glob;
           break;
          default:  /* 'n' and other values */
           selectsubtriang(); 
           /* Definisce Triangolazione_Loc, numero_triangoli_loc, 
              minbox_t_loc, maxbox_t_loc */
           minbox_t[0]=minbox_t_loc[0]; maxbox_t[0]=maxbox_t_loc[0];
           minbox_t[1]=minbox_t_loc[1]; maxbox_t[1]=maxbox_t_loc[1];
           Triangolazione=Triangolazione_Loc;    
           numero_triangoli=numero_triangoli_loc;      
           break;
         }
         itpttpresenza=1;
         cptbpresenza=0;
         cpttpresenza=0;
         draw_flag=0;
         /* Calling settriang() and returning GL_TRUE */
         settriang();  
         return(GL_TRUE);
        } 
      else if (pulsante==LABSUP3D_RIGHT_BUTTON)  /* zoom handling */
        {
         switch(WaitTriangZoom)
         {
          case 0: 
           tri_left_temp=tri_left+(double)(mouseposx)/(double)(WINWIDTH-1)*
                         (tri_right-tri_left);
           tri_down_temp=tri_up-(double)(mouseposy)/(double)(WINHEIGHT-1)*
                         (tri_up-tri_down);
           WaitTriangZoom=1;
          break;
          case 1:
           /* Non invertire l'ordine */ 
           tri_right=tri_left+(double)(mouseposx)/(double)(WINWIDTH-1)*
                     (tri_right-tri_left);
           tri_up=tri_up-(double)(mouseposy)/(double)(WINHEIGHT-1)*
                  (tri_up-tri_down);
           tri_left=tri_left_temp;
           tri_down=tri_down_temp;
           WaitTriangZoom=0;                 
          break; 
         }
         if (WaitTriangZoom==0)
         {
          /* setting for the window */
	  glLoadIdentity();
          gluOrtho2D(tri_left,tri_right,tri_down,tri_up);
	  return(GL_TRUE);
         }
         else return(GL_FALSE);
        } /* end if for button pressed */
     break;
     case 1:  /* Bezier surfaces */
     case 3:  /* C1 surfaces */
      if (pulsante==LABSUP3D_LEFT_BUTTON)
        {
         lambdavpn=PI/2.-(PI*mouseposy)/(WINHEIGHT-1);
	     phivpn=(2*PI*mouseposx)/(WINWIDTH-1);
	     vpn[0]=cos(lambdavpn)*cos(phivpn);
	     vpn[1]=cos(lambdavpn)*sin(phivpn);
	     vpn[2]=sin(lambdavpn);
	     temp= fabs(vpn[1]*vuv[2]-vpn[2]*vuv[1])
	          +fabs(vpn[2]*vuv[0]-vpn[0]*vuv[2])
	          +fabs(vpn[0]*vuv[1]-vpn[1]*vuv[0]);
	     if (temp<EPS_ALLIN) return GL_FALSE; /* vpn and vuv are parallel vectors */
	     /* rotation */
	     glsetmyoptions(parsize,vrp,vpn,vuv,0);
	     return(GL_TRUE);
        }
      else if (pulsante==LABSUP3D_MIDDLE_BUTTON)
        {  
         glsetmyoptions(parsize,vrp,vpn,vuv,0); /* Disabling current zoom */
         return(GL_TRUE);        
        }
      else if (pulsante==LABSUP3D_RIGHT_BUTTON)
       {
        switch(WaitSurfZoom)
        {
         case 0: 
          surf_left_temp=surf_left+(double)(mouseposx)/(double)(WINWIDTH-1)*
                         (surf_right-surf_left);
          surf_down_temp=surf_up-(double)(mouseposy)/(double)(WINHEIGHT-1)*
                         (surf_up-surf_down);
          WaitSurfZoom=1;
         break;
         case 1:
          /* Do not alter the order */ 
          surf_right=surf_left+(double)(mouseposx)/(double)(WINWIDTH-1)*
                     (surf_right-surf_left);
          surf_up=surf_up-(double)(mouseposy)/(double)(WINHEIGHT-1)*
                  (surf_up-surf_down);
          surf_left=surf_left_temp;
          surf_down=surf_down_temp;
          WaitSurfZoom=0;                 
         break; 
        } /* end switch WaitSurfZoom */
        if (WaitSurfZoom==0)
        {
         /* zoom action */
         glsetmyoptions(parsize,vrp,vpn,vuv,1);
         return(GL_TRUE); 
        }
        else return(GL_FALSE);
       } /* end 'if' right button */
     break; 
    } /* end switch over 'draw_flag' */
 return(GL_FALSE); /* Security */
}

void increase_zoom()
{
 if ((cptbpresenza==0 && cpttpresenza==0) || draw_flag==2) return;
 zoomfactor=zoomfactor/zoomscalefactor;
 glsetmyoptions(parsize,vrp,vpn,vuv,0); 
}

void decrease_zoom()
{
 if ((cptbpresenza==0 && cpttpresenza==0) || draw_flag==2) return;
 zoomfactor=zoomfactor*zoomscalefactor;
 glsetmyoptions(parsize,vrp,vpn,vuv,0);
}
  
void glvtriang()
{
 long int iv1,iv2,iv3;
 struct triang_list *Triang_Pt;
 
 /* Depht-buffer already disabled */
 /* setting colors */
 setmyglcolor();
 glDisable(GL_LIGHTING); light_flag=0; /* Disabling light */
 /* beginning drawing */
 Triang_Pt=Triangolazione; 
 glLineWidth(1.0);
 glBegin(GL_LINES);
 while (Triang_Pt!=NULL)
   {
    iv1=Triang_Pt->triangolo.v1;
    iv2=Triang_Pt->triangolo.v2;
    iv3=Triang_Pt->triangolo.v3;   
    {glVertex2d(x[iv1],y[iv1]); glVertex2d(x[iv2],y[iv2]); };
    {glVertex2d(x[iv2],y[iv2]); glVertex2d(x[iv3],y[iv3]); };
    {glVertex2d(x[iv3],y[iv3]); glVertex2d(x[iv1],y[iv1]); };
    Triang_Pt=Triang_Pt->next;
   } /* end while */
 glEnd();
 LABSUP3D_SWAPBUFFERS;    
 /* No light */
}

void drawminmaxbox(minb,maxb)
double minb[],maxb[];
{
 if (drawminmaxbox_flag==1) {
  if (light_flag==1) glDisable(GL_LIGHTING);
   glBegin(GL_LINE_LOOP);
   glVertex3d(minb[0],minb[1],minb[2]);
   glVertex3d(maxb[0],minb[1],minb[2]);
   glVertex3d(maxb[0],maxb[1],minb[2]); 
   glVertex3d(minb[0],maxb[1],minb[2]); 
  glEnd();
  glBegin(GL_LINE_LOOP);
   glVertex3d(minb[0],minb[1],maxb[2]);
   glVertex3d(maxb[0],minb[1],maxb[2]);
   glVertex3d(maxb[0],maxb[1],maxb[2]); 
   glVertex3d(minb[0],maxb[1],maxb[2]); 
  glEnd();    
  glBegin(GL_LINES);
   glVertex3d(minb[0],minb[1],minb[2]);
   glVertex3d(minb[0],minb[1],maxb[2]);
   glVertex3d(maxb[0],minb[1],minb[2]);
   glVertex3d(maxb[0],minb[1],maxb[2]);
   glVertex3d(maxb[0],maxb[1],minb[2]); 
   glVertex3d(maxb[0],maxb[1],maxb[2]); 
   glVertex3d(minb[0],maxb[1],minb[2]); 
   glVertex3d(minb[0],maxb[1],maxb[2]); 
  glEnd();
  if (light_flag==1) glEnable(GL_LIGHTING);
 }
}

void computeNormal(calcpt,s1,s2,s3,nrm)
double calcpt[][MAXDIM];
int s1,s2,s3;
GLfloat nrm[];
{
	   GLfloat u[3],v[3],nnorm;

 	   u[0]=calcpt[s3][0]-calcpt[s1][0];
	   u[1]=calcpt[s3][1]-calcpt[s1][1];
	   u[2]=calcpt[s3][2]-calcpt[s1][2];
	   v[0]=calcpt[s2][0]-calcpt[s1][0];
	   v[1]=calcpt[s2][1]-calcpt[s1][1];
	   v[2]=calcpt[s2][2]-calcpt[s1][2];

	   /* cross product u^v */
	   nrm[0]=u[1]*v[2]-u[2]*v[1];
	   nrm[1]=u[2]*v[0]-u[0]*v[2];
	   nrm[2]=u[0]*v[1]-u[1]*v[0];
	   nnorm=sqrt(nrm[0]*nrm[0]+nrm[1]*nrm[1]+nrm[2]*nrm[2]);
	   nrm[0]/=nnorm;
	   nrm[1]/=nnorm;
	   nrm[2]/=nnorm;
}
