      PROGRAM EXAM3
c
c This program is a template which creates a triangulation
c file and its plot by using the TRIPACK packages. 
c
c Compilation (automatically done by the Makefile) :
c 
c (Linux)   fort77 exam3.f src.f -o exam3
c (Unix)       f77 exam3.f src.f -o exam3
c
c In order to use this program on different examples 
c change the constants N, NCC, LCC, NMAX and the variables
c MYFILENAME, TITLE and the filenames where to store 
c the triangulation data and its plot. 
c
c       N    = number of points
c       NCC  = number of constrained curves
c       LCC  = constraint curve starting indices
c       NMAX = maximum number of points
c
c Input format reading string is handled by the code at 
c     label 210 FORMAT
c
      PARAMETER (N=147, L=6*N, LWK=2*N, NCC=2, NMAX=200)
c
      INTEGER LIST(L), LPTR(L), LEND(N), I, 
     .        LCC(NCC), NODES(LWK)
      LOGICAL NUMBR, PRNTX
      REAL    X(NMAX),Y(NMAX),DS(NMAX)
      REAL    PLTSIZ, WX1, WX2, WY1, WY2
c
c
      CHARACTER*80 TITLE      
c
c TRASH is a hidden variable 
c
      CHARACTER*20 TRASH, MYFILENAME
      INTEGER NVAL
      INTEGER LVAL 
      INTEGER LWKVAL
      INTEGER NCCVAL
c
c Constraint curve starting indices
c
      DATA LCC / 120 , 127 /
c      
      NVAL=N
      LVAL=L
      LWKVAL=LWK
      NCCVAL=NCC
C
C Store a plot title.  It must be enclosed in parentheses.
C
      TITLE = '(Triangulation created by EXAM3)'
C
C Plot size for the triangulation plot.
C
      DATA    PLTSIZ/7.5/
c
c Read coordinates on logical unit 8 for the file '.dat' 
c avoiding the third coordinate by putting in the variable 'trash'
c
      MYFILENAME='exam3.dat'
      OPEN(8, FILE=MYFILENAME, err=200, status='old')

      I=1
 10   READ(8,210,end=20) X(I),Y(I),TRASH
      I=I+1
      GOTO 10
 20   CLOSE(8)
c
c FROM HERE TO LABEL 40 THE CODE IS USEFUL TO CHECK FOR DATA READ AND
c CONSTRAINTS READ: COMMENT AND/OR UNCOMMENT WHEN NEEDED.
c
c      DO 30 i=1,N
c      write (*,'(f20.10,1x,f20.10)') x(i),y(i)
c 30   CONTINUE
c      write (*,*)
c      write (*,*) ncc
c      DO 40 i=1,ncc
c      write (*,'(i6)') lcc(i)
c 40   CONTINUE
c 
cc Logical unit number for output the triangulation file 
c and the Encapsulated PostScript of the triangulation
c
      DATA LOUT/10/, LPLT/4/
      OPEN (LOUT,FILE='exam3.rk')
      OPEN (LPLT,FILE='exam3.eps')

c
c Create the triangulation and test the error flag
c
       CALL TRMESH (N,X,Y, LIST,LPTR,LEND,LNEW,NODES,
     .             NODES(N+1),DS,IER)
       IF (IER .EQ. -2) THEN
        WRITE (LOUT,211)
        STOP
       ELSEIF (IER .EQ. -4) THEN
        WRITE (*,212)
        STOP
      ELSEIF (IER .GT. 0) THEN
        WRITE (*,213)
        STOP
      ENDIF
      WRITE (*,*) '    TRMESH: end '
211   FORMAT (//5X,'*** Error in TRMESH:  the first three ',
     .        'nodes are collinear ***'/)
212   FORMAT (//5X,'*** Error in TRMESH:  invalid ',
     .        'triangulation ***'/)
213   FORMAT (//5X,'*** Error in TRMESH:  duplicate nodes ',
     .        'encountered ***'/)
c
c Force the presence of the constraint arcs.
c The LWK=2N integer work space locations is more than
c sufficient
c
      LW = LWKVAL
      CALL ADDCST (NCC,LCC,N,X,Y,LW,NODES,LIST,LPTR,
     .             LEND, IER)
      IF (IER .NE. 0) THEN
        WRITE (LOUT,110) IER
110     FORMAT (10X,'ERROR IN ADDCST: IER=',I2)
        STOP
      ENDIF
      WRITE (*,*) '    ADDCST: end '
c
c Print the data structure on logical unit LOUT
c PRNTX=.TRUE. indicates that the nodal coordinates are to
c be printed along with the adjacency lists.
c
      PRNTX=.TRUE.
      CALL TRPRNT(NCCVAL,LCC,NVAL,X,Y,LIST,LPTR,LEND,LOUT,PRNTX) 
C
C
C   Set the plot window [WX1,WX2] X [WY1,WY2] to the
C   smallest rectangle that contains the nodes.
C   NUMBR = TRUE iff nodal indexes are to be displayed.
C
      WX1 = X(1)
      WX2 = WX1
      WY1 = Y(1)
      WY2 = WY1
      DO 1 K = 2,N
        IF (X(K) .LT. WX1) WX1 = X(K)
        IF (X(K) .GT. WX2) WX2 = X(K)
        IF (Y(K) .LT. WY1) WY1 = Y(K)
        IF (Y(K) .GT. WY2) WY2 = Y(K)
    1   CONTINUE
      NUMBR = N .LE. 200
      CALL TRPLOT (LPLT,PLTSIZ,WX1,WX2,WY1,WY2,NCC,LCC,N,
     .             X,Y,LIST,LPTR,LEND,TITLE,NUMBR, IER)
      IF (IER .EQ. 0) THEN
        WRITE (*,470)
      ELSE
        WRITE (*,270) IER
      ENDIF
270   FORMAT (//5X,'*** Error in TRPLOT:  IER = ',I1,
     .        ' ***'/)
470   FORMAT (/5X,'A triangulation plot file was ',
     .             'successfully created.'/)
C
      STOP
200   WRITE (*,*) 'Error in opening file or input file does not exist'
210   FORMAT (2x,e21.14,3x,e21.14,a)
      END

