/*
** DO_DER_A.C 
**
** AUTHORS: 
**
**         Damiano FASOLI and Maria MORANDI CECCHI
**         University of Padua, Italy
**         
**         Stefano DE MARCHI,
**         University of Udine, Italy
**
**
** REVISION DATE : May, 1999  
**
** MODULES CALLED: None 
**
** -------------------------------------------------------------------------
**
** SUBROUTINES AND FUNCTIONS DESCRIPTION:
**
** >>>>>>>>>>>>>>>>>>
**
** double derivecptq18_v(int i,int j,int s)
**
** GLOBAL VARIABLES USED: e1x,e1y,e2x,e2y,e3x,e3y,t1,t2,t3
**
** t1,t2,t3 must be computed externally as:
**
**	 t1=-(e1x*e3x+e1y*e3y)/(pow(e1x,2.)+pow(e1y,2.));
**	 t2=-(e2x*e1x+e2y*e1y)/(pow(e2x,2.)+pow(e2y,2.));
**	 t3=-(e3x*e2x+e3y*e2y)/(pow(e3x,2.)+pow(e3y,2.));
**
** The function computes the derivative of the control points 
** d_{ijk} (with k=5-i-j) of the Q18 element as a function 
** of the partial derivatives
**
** q1x,q1y,q1xx,q1xy,q1yy,q2x,q2y,q2xx,q2xy,q2yy,q3x,q3y,q3xx,q3xy,q3yy
**
** with respect to the s-th partial derivative in the above order from
** 0 to 14. 
** The triangle over which the function operates is described
** by the edges (eix,eiy)=V_{i-1}-V_{i+1} where 'i' varies from 1 to 3 
** (assuming that 1-1=3 and 3+1=1) and V_i (i=1,2,3) are the vertices 
** of the triangle.
**
**
** >>>>>>>>>>>>>>>>>>
**
** double compute_d_rst_Q18(int r,int s,int i)
** 
** GLOBAL VARIABLES USED: q1,q2,q3,e1x,e1y,e2x,e2y,e3x,e3y,t1,t2,t3
** 
** t1,t2,t3 must be computed externally as:
**
**	 t1=-(e1x*e3x+e1y*e3y)/(pow(e1x,2.)+pow(e1y,2.));
**	 t2=-(e2x*e1x+e2y*e1y)/(pow(e2x,2.)+pow(e2y,2.));
**	 t3=-(e3x*e2x+e3y*e2y)/(pow(e3x,2.)+pow(e3y,2.));
**
** This function computes the control points d_{rst} (with r+s+t=5),
** assigning to the unknown parameters
**
** q1x q1y q1xx q1xy q1yy q2x q2y q2xx q2xy q2yy q3x q3y q3xx q3xy q3yy
**
** the value given by the i-th vector of the canonical basis of R^15.
** Note that in the function the vectors of the canonical basis 
** are called e0,e1, ..., e14. 
** 
** The triangle over which the function operates is described
** by the edges (eix,eiy)=V_(i-1)-V_(i+1) where i varies from 1 to 3 
** (assuming that 1-1=3 and 3+1=1) and V_i (i=1,2,3) are the vertices 
** of the triangle.
**
** The parameters q1,q2,q3 are the values of the triangular patch
** at the vertices V1,V2,V3, by using end-point interpolation, 
** these are the values of the control points d_{500},d_{050},d_{005}.
**
**
** >>>>>>>>>>>>>>>>>>
**
** double compute_d_rst_Q18_null(int r,int s)
**
** GLOBAL VARIABLES USED: q1,q2,q3,t1,t2,t3
**
** t1,t2,t3 must be computed externally as:
**
**	 t1=-(e1x*e3x+e1y*e3y)/(pow(e1x,2.)+pow(e1y,2.));
**	 t2=-(e2x*e1x+e2y*e1y)/(pow(e2x,2.)+pow(e2y,2.));
**	 t3=-(e3x*e2x+e3y*e2y)/(pow(e3x,2.)+pow(e3y,2.));
**
** This function computes the control points d_{rst} (with r+s+t=5)
** assigning to the unknown parameters 
*
** q1x q1y q1xx q1xy q1yy q2x q2y q2xx q2xy q2yy q3x q3y q3xx q3xy q3yy
** 
** the value 0. 
** The triangle over which the function operates is described
** by the edges (eix,eiy)=V_{i-1}-V_{i+1} where i varies from 1 to 3 
** (assuming that 1-1=3 and 3+1=1) and V_i (i=1,2,3) are the vertices 
** of the triangle.
**
** The parameters q1,q2,q3 are the values of the triangular patch
** relative to the vertices V1,V2,V3, by using end-point interpolation, 
** these are the values of the control points d_{500},d_{050},d_{005}.
** 
**
** >>>>>>>>>>>>>>>>>>
**
** double sum_cpt3_prod(double b[],double c[])
**
** This function computes the sum of the control points of the product of
** two cubic triangular polynomial patches. Their control points are stored
** in the arrays 'b' and 'c' using the indexes from 0 to 9 according to the
** way used to visit the corresponding tridimensional indexes rst
** (used as b_{rst} and c_{rst}) ordered first with respect to r and, later,
** with respect to s (that is 003,012,021,030,102,111,120,201,210,300).
**
** In the function the symbol 'a' is used as the product patch.
**
**
** ------------------------------------------------------------------------
*/

#include<math.h>

/* Global variables declared in other files */
extern double q1,q2,q3,e1x,e1y,e2x,e2y,e3x,e3y,t1,t2,t3;

double derivecptq18_v(i,j,s)
int i,j,s;
{
 /* beginning of derivation by lookup-table */
 if((i==0) && (j==1))                   /* d_{014} */
 {
  if(s==10) return(-e1x/5);
  if(s==11) return(-e1y/5);
 }
 else if((i==0) && (j==2))              /* d_{023} */
 {
  if(s==10) return(-2*e1x/5);
  if(s==11) return(-2*e1y/5);
  if(s==12) return(pow(e1x,2.)/20);
  if(s==13) return(e1x*e1y/10);
  if(s==14) return(pow(e1y,2.)/20);
 }
 else if((i==0) && (j==3))              /* d_{032} */
 {
  if(s==5) return(2*e1x/5);
  if(s==6) return(2*e1y/5);
  if(s==7) return(pow(e1x,2.)/20);
  if(s==8) return(e1x*e1y/10);
  if(s==9) return(pow(e1y,2.)/20);
 }
 else if((i==0) && (j==4))              /* d_{041} */
 {
  if(s==5) return(e1x/5);
  if(s==6) return(e1y/5);
 }
 else if((i==1) && (j==0))              /* d_{104} */
 {
  if(s==10) return(e2x/5);
  if(s==11) return(e2y/5);
 }
 else if((i==1) && (j==1))              /* d_{113} */
 {
  if(s==10) return((e2x-e1x)/5);
  if(s==11) return((e2y-e1y)/5);
  if(s==12) return(-e1x*e2x/20);
  if(s==13) return(-(e1x*e2y+e1y*e2x)/20);
  if(s==14) return(-e1y*e2y/20);
 }
 else if((i==1) && (j==2))              /* d_{122} */
 {
  if(s==5) return(-(e1x*(5*t1-4)+e3x)/10);
  if(s==6) return(-(e1y*(5*t1-4)+e3y)/10);
  if(s==7) return(-e1x*(e1x*(5*t1-3)+2*e3x)/60);
  if(s==8) return(-(e1x*(e1y*(5*t1-3)+e3y)+e1y*e3x)/30);
  if(s==9) return(-e1y*(e1y*(5*t1-3)+2*e3y)/60);
  if(s==10) return((e2x-e1x*(5*t1-1))/10);
  if(s==11) return((e2y-e1y*(5*t1-1))/10);
  if(s==12) return(e1x*(e1x*(5*t1-2)-2*e2x)/60);
  if(s==13) return((e1x*(e1y*(5*t1-2)-e2y)-e1y*e2x)/30);
  if(s==14) return(e1y*(e1y*(5*t1-2)-2*e2y)/60);
 }
 else if((i==1) && (j==3))              /* d_{131} */
 {
  if(s==5) return((e1x-e3x)/5);
  if(s==6) return((e1y-e3y)/5);
  if(s==7) return(-e1x*e3x/20);
  if(s==8) return(-(e1x*e3y+e1y*e3x)/20);
  if(s==9) return(-e1y*e3y/20);
 }
 else if((i==1) && (j==4))              /* d_{140} */
 {
  if(s==5) return(-e3x/5);
  if(s==6) return(-e3y/5);
 }
 else if((i==2) && (j==0))              /* d_{203} */
 {
  if(s==10) return(2*e2x/5);
  if(s==11) return(2*e2y/5);
  if(s==12) return(pow(e2x,2.)/20);
  if(s==13) return(e2x*e2y/10);
  if(s==14) return(pow(e2y,2.)/20);
 }
 else if((i==2) && (j==1))              /* d_{212} */
 {
  if(s==0) return((e3x-e2x*(5*t2-1))/10);
  if(s==1) return((e3y-e2y*(5*t2-1))/10);
  if(s==2) return(e2x*(e2x*(5*t2-2)-2*e3x)/60);
  if(s==3) return((e2x*(e2y*(5*t2-2)-e3y)-e2y*e3x)/30);
  if(s==4) return(e2y*(e2y*(5*t2-2)-2*e3y)/60);
  if(s==10) return(-(e1x+e2x*(5*t2-4))/10);
  if(s==11) return(-(e1y+e2y*(5*t2-4))/10);
  if(s==12) return(-e2x*(2*e1x+e2x*(5*t2-3))/60);
  if(s==13) return(-(e1x*e2y+e1y*e2x+e2x*e2y*(5*t2-3))/30);
  if(s==14) return(-e2y*(2*e1y+e2y*(5*t2-3))/60);
 }
 else if((i==2) && (j==2))              /* d_{221} */
 {
  if(s==0) return(-(e2x+e3x*(5*t3-4))/10);
  if(s==1) return(-(e2y+e3y*(5*t3-4))/10);
  if(s==2) return(-e3x*(2*e2x+e3x*(5*t3-3))/60);
  if(s==3) return(-(e2x*e3y+e2y*e3x+e3x*e3y*(5*t3-3))/30);
  if(s==4) return(-e3y*(2*e2y+e3y*(5*t3-3))/60);
  if(s==5) return((e1x+e3x*(1-5*t3))/10);
  if(s==6) return((e1y+e3y*(1-5*t3))/10);
  if(s==7) return(-e3x*(2*e1x+e3x*(2-5*t3))/60);
  if(s==8) return(-(e1x*e3y+e1y*e3x+e3x*e3y*(2-5*t3))/30);
  if(s==9) return(-e3y*(2*e1y+e3y*(2-5*t3))/60);
 }
 else if((i==2) && (j==3))              /* d_{230} */
 {
  if(s==5) return(-2*e3x/5);
  if(s==6) return(-2*e3y/5);
  if(s==7) return(pow(e3x,2.)/20);
  if(s==8) return(e3x*e3y/10);
  if(s==9) return(pow(e3y,2.)/20);
 }
 else if((i==3) && (j==0))              /* d_{302} */
 {
  if(s==0) return(-2*e2x/5);
  if(s==1) return(-2*e2y/5);
  if(s==2) return(pow(e2x,2.)/20);
  if(s==3) return(e2x*e2y/10);
  if(s==4) return(pow(e2y,2.)/20);
 }
 else if((i==3) && (j==1))              /* d_{311} */
 {
  if(s==0) return((e3x-e2x)/5);
  if(s==1) return((e3y-e2y)/5);
  if(s==2) return(-e2x*e3x/20);
  if(s==3) return(-(e2x*e3y+e2y*e3x)/20);
  if(s==4) return(-e2y*e3y/20);
 }
 else if((i==3) && (j==2))              /* d_{320} */
 {
  if(s==0) return(2*e3x/5);
  if(s==1) return(2*e3y/5);
  if(s==2) return(pow(e3x,2.)/20);
  if(s==3) return(e3x*e3y/10);
  if(s==4) return(pow(e3y,2.)/20);
 }
 else if((i==4) && (j==0))              /* d_{401} */
 {
  if(s==0) return(-e2x/5);
  if(s==1) return(-e2y/5);
 }
 else if((i==4) && (j==1))              /* d_{410} */
 {
  if(s==0) return(e3x/5);
  if(s==1) return(e3y/5);
 }
 /* Security */
 return(0.);
}

double compute_d_rst_Q18(r,s,i)
int r,s,i;
{
 /* Beginning of answers by lookup table */
 if(i==0) /* Computation of d_{rst}(e0) */
 {
  if((r==0) && (s==0)) return(q3);
  if((r==0) && (s==1)) return(q3);
  if((r==0) && (s==2)) return(q3);
  if((r==0) && (s==3)) return(q2);
  if((r==0) && (s==4)) return(q2);
  if((r==0) && (s==5)) return(q2);
  if((r==1) && (s==0)) return(q3);
  if((r==1) && (s==1)) return(q3);
  if((r==1) && (s==2)) return(q2*(1-t1)+q3*t1);
  if((r==1) && (s==3)) return(q2);
  if((r==1) && (s==4)) return(q2);
  if((r==2) && (s==0)) return(q3);
  if((r==2) && (s==1)) return(-(e2x*(5*t2-1)-e3x-10*(q1*t2+q3*(1-t2)))/10);
  if((r==2) && (s==2)) return(-(e2x+e3x*(5*t3-4)+10*(q1*(t3-1)-q2*t3))/10);
  if((r==2) && (s==3)) return(q2);
  if((r==3) && (s==0)) return((5*q1-2*e2x)/5);
  if((r==3) && (s==1)) return(-(e2x-e3x-5*q1)/5);
  if((r==3) && (s==2)) return((2*e3x+5*q1)/5);
  if((r==4) && (s==0)) return((5*q1-e2x)/5);
  if((r==4) && (s==1)) return((e3x+5*q1)/5);
  if((r==5) && (s==0)) return(q1);
 }
 if(i==1) /* Computation of d_{rst}(e1) */
 {
  if((r==0) && (s==0)) return(q3);
  if((r==0) && (s==1)) return(q3);
  if((r==0) && (s==2)) return(q3);
  if((r==0) && (s==3)) return(q2);
  if((r==0) && (s==4)) return(q2);
  if((r==0) && (s==5)) return(q2);
  if((r==1) && (s==0)) return(q3);
  if((r==1) && (s==1)) return(q3);
  if((r==1) && (s==2)) return(q2*(1-t1)+q3*t1);
  if((r==1) && (s==3)) return(q2);
  if((r==1) && (s==4)) return(q2);
  if((r==2) && (s==0)) return(q3);
  if((r==2) && (s==1)) return(-(e2y*(5*t2-1)-e3y-10*(q1*t2+q3*(1-t2)))/10);
  if((r==2) && (s==2)) return(-(e2y+e3y*(5*t3-4)+10*(q1*(t3-1)-q2*t3))/10);
  if((r==2) && (s==3)) return(q2);
  if((r==3) && (s==0)) return((5*q1-2*e2y)/5);
  if((r==3) && (s==1)) return(-(e2y-e3y-5*q1)/5);
  if((r==3) && (s==2)) return((2*e3y+5*q1)/5);
  if((r==4) && (s==0)) return((5*q1-e2y)/5);
  if((r==4) && (s==1)) return((e3y+5*q1)/5);
  if((r==5) && (s==0)) return(q1);
 }
 if(i==2) /* Computation of d_{rst}(e2) */
 {
  if((r==0) && (s==0)) return(q3);
  if((r==0) && (s==1)) return(q3);
  if((r==0) && (s==2)) return(q3);
  if((r==0) && (s==3)) return(q2);
  if((r==0) && (s==4)) return(q2);
  if((r==0) && (s==5)) return(q2);
  if((r==1) && (s==0)) return(q3);
  if((r==1) && (s==1)) return(q3);
  if((r==1) && (s==2)) return(q2*(1-t1)+q3*t1);
  if((r==1) && (s==3)) return(q2);
  if((r==1) && (s==4)) return(q2);
  if((r==2) && (s==0)) return(q3);
  if((r==2) && (s==1)) return((pow(e2x,2.)*(5*t2-2)-2*e2x*e3x
			       +60*(q1*t2+q3*(1-t2)))/60);
  if((r==2) && (s==2)) return(-(2*e2x*e3x+pow(e3x,2.)*(5*t3-3)
				+60*(q1*(t3-1)-q2*t3))/60);
  if((r==2) && (s==3)) return(q2);
  if((r==3) && (s==0)) return((pow(e2x,2.)+20*q1)/20);
  if((r==3) && (s==1)) return((20*q1-e2x*e3x)/20);
  if((r==3) && (s==2)) return((pow(e3x,2.)+20*q1)/20);
  if((r==4) && (s==0)) return(q1);
  if((r==4) && (s==1)) return(q1);
  if((r==5) && (s==0)) return(q1);
 }
 if(i==3) /* Computation of d_{rst}(e3) */
 {
  if((r==0) && (s==0)) return(q3);
  if((r==0) && (s==1)) return(q3);
  if((r==0) && (s==2)) return(q3);
  if((r==0) && (s==3)) return(q2);
  if((r==0) && (s==4)) return(q2);
  if((r==0) && (s==5)) return(q2);
  if((r==1) && (s==0)) return(q3);
  if((r==1) && (s==1)) return(q3);
  if((r==1) && (s==2)) return(q2*(1-t1)+q3*t1);
  if((r==1) && (s==3)) return(q2);
  if((r==1) && (s==4)) return(q2);
  if((r==2) && (s==0)) return(q3);
  if((r==2) && (s==1)) return((e2x*(e2y*(5*t2-2)-e3y)-e2y*e3x
			       +30*(q1*t2+q3*(1-t2)))/30);
  if((r==2) && (s==2)) return(-(e2x*e3y+e2y*e3x+e3x*e3y*(5*t3-3)
				+30*(q1*(t3-1)-q2*t3))/30);
  if((r==2) && (s==3)) return(q2);
  if((r==3) && (s==0)) return((e2x*e2y+10*q1)/10);
  if((r==3) && (s==1)) return(-(e2x*e3y+e2y*e3x-20*q1)/20);
  if((r==3) && (s==2)) return((e3x*e3y+10*q1)/10);
  if((r==4) && (s==0)) return(q1);
  if((r==4) && (s==1)) return(q1);
  if((r==5) && (s==0)) return(q1);
 }
 if(i==4) /*  Computation of d_{rst}(e4) */
 {
  if((r==0) && (s==0)) return(q3);
  if((r==0) && (s==1)) return(q3);
  if((r==0) && (s==2)) return(q3);
  if((r==0) && (s==3)) return(q2);
  if((r==0) && (s==4)) return(q2);
  if((r==0) && (s==5)) return(q2);
  if((r==1) && (s==0)) return(q3);
  if((r==1) && (s==1)) return(q3);
  if((r==1) && (s==2)) return(q2*(1-t1)+q3*t1);
  if((r==1) && (s==3)) return(q2);
  if((r==1) && (s==4)) return(q2);
  if((r==2) && (s==0)) return(q3);
  if((r==2) && (s==1)) return((pow(e2y,2.)*(5*t2-2)-2*e2y*e3y
			       +60*(q1*t2+q3*(1-t2)))/60);
  if((r==2) && (s==2)) return(-(2*e2y*e3y+pow(e3y,2.)*(5*t3-3)
				+60*(q1*(t3-1)-q2*t3))/60);
  if((r==2) && (s==3)) return(q2);
  if((r==3) && (s==0)) return((pow(e2y,2.)+20*q1)/20);
  if((r==3) && (s==1)) return((20*q1-e2y*e3y)/20);
  if((r==3) && (s==2)) return((pow(e3y,2.)+20*q1)/20);
  if((r==4) && (s==0)) return(q1);
  if((r==4) && (s==1)) return(q1);
  if((r==5) && (s==0)) return(q1);
 }
 if(i==5) /* Computation of d_{rst}(e5) */
 {
  if((r==0) && (s==0)) return(q3);
  if((r==0) && (s==1)) return(q3);
  if((r==0) && (s==2)) return(q3);
  if((r==0) && (s==3)) return((2*e1x+5*q2)/5);
  if((r==0) && (s==4)) return((e1x+5*q2)/5);
  if((r==0) && (s==5)) return(q2);
  if((r==1) && (s==0)) return(q3);
  if((r==1) && (s==1)) return(q3);
  if((r==1) && (s==2)) return(-(e1x*(5*t1-4)+e3x+10*(q2*(t1-1)-q3*t1))/10);
  if((r==1) && (s==3)) return((e1x-e3x+5*q2)/5);
  if((r==1) && (s==4)) return((5*q2-e3x)/5);
  if((r==2) && (s==0)) return(q3);
  if((r==2) && (s==1)) return(q1*t2+q3*(1-t2));
  if((r==2) && (s==2)) return((e1x+e3x*(1-5*t3)+10*(q2*t3-q1*(t3-1)))/10);
  if((r==2) && (s==3)) return((5*q2-2*e3x)/5);
  if((r==3) && (s==0)) return(q1);
  if((r==3) && (s==1)) return(q1);
  if((r==3) && (s==2)) return(q1);
  if((r==4) && (s==0)) return(q1);
  if((r==4) && (s==1)) return(q1);
  if((r==5) && (s==0)) return(q1);
 }
 if(i==6) /* Computation of d_{rst}(e6) */
 {
  if((r==0) && (s==0)) return(q3);
  if((r==0) && (s==1)) return(q3);
  if((r==0) && (s==2)) return(q3);
  if((r==0) && (s==3)) return((2*e1y+5*q2)/5);
  if((r==0) && (s==4)) return((e1y+5*q2)/5);
  if((r==0) && (s==5)) return(q2);
  if((r==1) && (s==0)) return(q3);
  if((r==1) && (s==1)) return(q3);
  if((r==1) && (s==2)) return(-(e1y*(5*t1-4)+e3y+10*(q2*(t1-1)-q3*t1))/10);
  if((r==1) && (s==3)) return((e1y-e3y+5*q2)/5);
  if((r==1) && (s==4)) return((5*q2-e3y)/5);
  if((r==2) && (s==0)) return(q3);
  if((r==2) && (s==1)) return(q1*t2+q3*(1-t2));
  if((r==2) && (s==2)) return((e1y+e3y*(1-5*t3)+10*(q2*t3-q1*(t3-1)))/10);
  if((r==2) && (s==3)) return((5*q2-2*e3y)/5);
  if((r==3) && (s==0)) return(q1);
  if((r==3) && (s==1)) return(q1);
  if((r==3) && (s==2)) return(q1);
  if((r==4) && (s==0)) return(q1);
  if((r==4) && (s==1)) return(q1);
  if((r==5) && (s==0)) return(q1);
 }
 if(i==7) /* Computation of d_{rst}(e7) */
 {
  if((r==0) && (s==0)) return(q3);
  if((r==0) && (s==1)) return(q3);
  if((r==0) && (s==2)) return(q3);
  if((r==0) && (s==3)) return((pow(e1x,2.)+20*q2)/20);
  if((r==0) && (s==4)) return(q2);
  if((r==0) && (s==5)) return(q2);
  if((r==1) && (s==0)) return(q3);
  if((r==1) && (s==1)) return(q3);
  if((r==1) && (s==2)) return(-(pow(e1x,2.)*(5*t1-3)+2*e1x*e3x
				+60*(q2*(t1-1)-q3*t1))/60);
  if((r==1) && (s==3)) return((20*q2-e1x*e3x)/20);
  if((r==1) && (s==4)) return(q2);
  if((r==2) && (s==0)) return(q3);
  if((r==2) && (s==1)) return(q1*t2+q3*(1-t2));
  if((r==2) && (s==2)) return(-(2*e1x*e3x+pow(e3x,2.)*(2-5*t3)
				+60*(q1*(t3-1)-q2*t3))/60);
  if((r==2) && (s==3)) return((pow(e3x,2.)+20*q2)/20);
  if((r==3) && (s==0)) return(q1);
  if((r==3) && (s==1)) return(q1);
  if((r==3) && (s==2)) return(q1);
  if((r==4) && (s==0)) return(q1);
  if((r==4) && (s==1)) return(q1);
  if((r==5) && (s==0)) return(q1);
 }
 if(i==8) /* Computation of d_{rst}(e8) */
 {
  if((r==0) && (s==0)) return(q3);
  if((r==0) && (s==1)) return(q3);
  if((r==0) && (s==2)) return(q3);
  if((r==0) && (s==3)) return((e1x*e1y+10*q2)/10);
  if((r==0) && (s==4)) return(q2);
  if((r==0) && (s==5)) return(q2);
  if((r==1) && (s==0)) return(q3);
  if((r==1) && (s==1)) return(q3);
  if((r==1) && (s==2)) return(-(e1x*(e1y*(5*t1-3)+e3y)+e1y*e3x
				+30*(q2*(t1-1)-q3*t1))/30);
  if((r==1) && (s==3)) return(-(e1x*e3y+e1y*e3x-20*q2)/20);
  if((r==1) && (s==4)) return(q2);
  if((r==2) && (s==0)) return(q3);
  if((r==2) && (s==1)) return(q1*t2+q3*(1-t2));
  if((r==2) && (s==2)) return(-(e1x*e3y+e1y*e3x+e3x*e3y*(2-5*t3)
				+30*(q1*(t3-1)-q2*t3))/30);
  if((r==2) && (s==3)) return((e3x*e3y+10*q2)/10);
  if((r==3) && (s==0)) return(q1);
  if((r==3) && (s==1)) return(q1);
  if((r==3) && (s==2)) return(q1);
  if((r==4) && (s==0)) return(q1);
  if((r==4) && (s==1)) return(q1);
  if((r==5) && (s==0)) return(q1);
 }
 if(i==9) /* Computation of d_{rst}(e9) */
 {
  if((r==0) && (s==0)) return(q3);
  if((r==0) && (s==1)) return(q3);
  if((r==0) && (s==2)) return(q3);
  if((r==0) && (s==3)) return((pow(e1y,2.)+20*q2)/20);
  if((r==0) && (s==4)) return(q2);
  if((r==0) && (s==5)) return(q2);
  if((r==1) && (s==0)) return(q3);
  if((r==1) && (s==1)) return(q3);
  if((r==1) && (s==2)) return(-(pow(e1y,2.)*(5*t1-3)+2*e1y*e3y
				+60*(q2*(t1-1)-q3*t1))/60);
  if((r==1) && (s==3)) return((20*q2-e1y*e3y)/20);
  if((r==1) && (s==4)) return(q2);
  if((r==2) && (s==0)) return(q3);
  if((r==2) && (s==1)) return(q1*t2+q3*(1-t2));
  if((r==2) && (s==2)) return(-(2*e1y*e3y+pow(e3y,2.)*(2-5*t3)
				+60*(q1*(t3-1)-q2*t3))/60);
  if((r==2) && (s==3)) return((pow(e3y,2.)+20*q2)/20);
  if((r==3) && (s==0)) return(q1);
  if((r==3) && (s==1)) return(q1);
  if((r==3) && (s==2)) return(q1);
  if((r==4) && (s==0)) return(q1);
  if((r==4) && (s==1)) return(q1);
  if((r==5) && (s==0)) return(q1);
 }
 if(i==10) /* Computation of d_{rst}(e10) */
 {
  if((r==0) && (s==0)) return(q3);
  if((r==0) && (s==1)) return((5*q3-e1x)/5);
  if((r==0) && (s==2)) return((5*q3-2*e1x)/5);
  if((r==0) && (s==3)) return(q2);
  if((r==0) && (s==4)) return(q2);
  if((r==0) && (s==5)) return(q2);
  if((r==1) && (s==0)) return((e2x+5*q3)/5);
  if((r==1) && (s==1)) return(-(e1x-e2x-5*q3)/5);
  if((r==1) && (s==2)) return(-(e1x*(5*t1-1)-e2x+10*(q2*(t1-1)-q3*t1))/10);
  if((r==1) && (s==3)) return(q2);
  if((r==1) && (s==4)) return(q2);
  if((r==2) && (s==0)) return((2*e2x+5*q3)/5);
  if((r==2) && (s==1)) return(-(e1x+e2x*(5*t2-4)-10*(q1*t2+q3*(1-t2)))/10);
  if((r==2) && (s==2)) return(q1*(1-t3)+q2*t3);
  if((r==2) && (s==3)) return(q2);
  if((r==3) && (s==0)) return(q1);
  if((r==3) && (s==1)) return(q1);
  if((r==3) && (s==2)) return(q1);
  if((r==4) && (s==0)) return(q1);
  if((r==4) && (s==1)) return(q1);
  if((r==5) && (s==0)) return(q1);
 }
 if(i==11) /* Computation of d_{rst}(e11) */
 {
  if((r==0) && (s==0)) return(q3);
  if((r==0) && (s==1)) return((5*q3-e1y)/5);
  if((r==0) && (s==2)) return((5*q3-2*e1y)/5);
  if((r==0) && (s==3)) return(q2);
  if((r==0) && (s==4)) return(q2);
  if((r==0) && (s==5)) return(q2);
  if((r==1) && (s==0)) return((e2y+5*q3)/5);
  if((r==1) && (s==1)) return(-(e1y-e2y-5*q3)/5);
  if((r==1) && (s==2)) return(-(e1y*(5*t1-1)-e2y+10*(q2*(t1-1)-q3*t1))/10);
  if((r==1) && (s==3)) return(q2);
  if((r==1) && (s==4)) return(q2);
  if((r==2) && (s==0)) return((2*e2y+5*q3)/5);
  if((r==2) && (s==1)) return(-(e1y+e2y*(5*t2-4)-10*(q1*t2+q3*(1-t2)))/10);
  if((r==2) && (s==2)) return(q1*(1-t3)+q2*t3);
  if((r==2) && (s==3)) return(q2);
  if((r==3) && (s==0)) return(q1);
  if((r==3) && (s==1)) return(q1);
  if((r==3) && (s==2)) return(q1);
  if((r==4) && (s==0)) return(q1);
  if((r==4) && (s==1)) return(q1);
  if((r==5) && (s==0)) return(q1);
 }
 if(i==12) /* Computation of d_{rst}(e12) */
 {
  if((r==0) && (s==0)) return(q3);
  if((r==0) && (s==1)) return(q3);
  if((r==0) && (s==2)) return((pow(e1x,2.)+20*q3)/20);
  if((r==0) && (s==3)) return(q2);
  if((r==0) && (s==4)) return(q2);
  if((r==0) && (s==5)) return(q2);
  if((r==1) && (s==0)) return(q3);
  if((r==1) && (s==1)) return((20*q3-e1x*e2x)/20);
  if((r==1) && (s==2)) return((pow(e1x,2.)*(5*t1-2)-2*e1x*e2x
			       +60*(q3*t1-q2*(t1-1)))/60);
  if((r==1) && (s==3)) return(q2);
  if((r==1) && (s==4)) return(q2);
  if((r==2) && (s==0)) return((pow(e2x,2.)+20*q3)/20);
  if((r==2) && (s==1)) return(-(2*e1x*e2x+pow(e2x,2.)*(5*t2-3)
				-60*(q1*t2+q3*(1-t2)))/60);
  if((r==2) && (s==2)) return(q1*(1-t3)+q2*t3);
  if((r==2) && (s==3)) return(q2);
  if((r==3) && (s==0)) return(q1);
  if((r==3) && (s==1)) return(q1);
  if((r==3) && (s==2)) return(q1);
  if((r==4) && (s==0)) return(q1);
  if((r==4) && (s==1)) return(q1);
  if((r==5) && (s==0)) return(q1);
 }
 if(i==13) /* Computation of d_{rst}(e13) */
 {
  if((r==0) && (s==0)) return(q3);
  if((r==0) && (s==1)) return(q3);
  if((r==0) && (s==2)) return((e1x*e1y+10*q3)/10);
  if((r==0) && (s==3)) return(q2);
  if((r==0) && (s==4)) return(q2);
  if((r==0) && (s==5)) return(q2);
  if((r==1) && (s==0)) return(q3);
  if((r==1) && (s==1)) return(-(e1x*e2y+e1y*e2x-20*q3)/20);
  if((r==1) && (s==2)) return((e1x*(e1y*(5*t1-2)-e2y)-e1y*e2x
			       +30*(q3*t1-q2*(t1-1)))/30);
  if((r==1) && (s==3)) return(q2);
  if((r==1) && (s==4)) return(q2);
  if((r==2) && (s==0)) return((e2x*e2y+10*q3)/10);
  if((r==2) && (s==1)) return(-(e1x*e2y+e1y*e2x+e2x*e2y*(5*t2-3)
				-30*(q1*t2+q3*(1-t2)))/30);
  if((r==2) && (s==2)) return(q1*(1-t3)+q2*t3);
  if((r==2) && (s==3)) return(q2);
  if((r==3) && (s==0)) return(q1);
  if((r==3) && (s==1)) return(q1);
  if((r==3) && (s==2)) return(q1);
  if((r==4) && (s==0)) return(q1);
  if((r==4) && (s==1)) return(q1);
  if((r==5) && (s==0)) return(q1);
 }
 if(i==14) /* Computation of d_{rst}(e14) */
 {
  if((r==0) && (s==0)) return(q3);
  if((r==0) && (s==1)) return(q3);
  if((r==0) && (s==2)) return((pow(e1y,2.)+20*q3)/20);
  if((r==0) && (s==3)) return(q2);
  if((r==0) && (s==4)) return(q2);
  if((r==0) && (s==5)) return(q2);
  if((r==1) && (s==0)) return(q3);
  if((r==1) && (s==1)) return((20*q3-e1y*e2y)/20);
  if((r==1) && (s==2)) return((pow(e1y,2.)*(5*t1-2)-2*e1y*e2y
			       +60*(q3*t1-q2*(t1-1)))/60);
  if((r==1) && (s==3)) return(q2);
  if((r==1) && (s==4)) return(q2);
  if((r==2) && (s==0)) return((pow(e2y,2.)+20*q3)/20);
  if((r==2) && (s==1)) return(-(2*e1y*e2y+pow(e2y,2.)*(5*t2-3)
				-60*(q1*t2+q3*(1-t2)))/60);
  if((r==2) && (s==2)) return(q1*(1-t3)+q2*t3);
  if((r==2) && (s==3)) return(q2);
  if((r==3) && (s==0)) return(q1);
  if((r==3) && (s==1)) return(q1);
  if((r==3) && (s==2)) return(q1);
  if((r==4) && (s==0)) return(q1);
  if((r==4) && (s==1)) return(q1);
  if((r==5) && (s==0)) return(q1);
 }
 /* sercurity */
 return(0.);
}

double compute_d_rst_Q18_null(r,s)
int r,s;
{
 /* Computation by lookup table */
  if((r==0) && (s==0)) return(q3);
  if((r==0) && (s==1)) return(q3);
  if((r==0) && (s==2)) return(q3);
  if((r==0) && (s==3)) return(q2);
  if((r==0) && (s==4)) return(q2);
  if((r==0) && (s==5)) return(q2);
  if((r==1) && (s==0)) return(q3);
  if((r==1) && (s==1)) return(q3);
  if((r==1) && (s==2)) return(q2*(1-t1)+q3*t1);
  if((r==1) && (s==3)) return(q2);
  if((r==1) && (s==4)) return(q2);
  if((r==2) && (s==0)) return(q3);
  if((r==2) && (s==1)) return(q1*t2+q3*(1-t2));
  if((r==2) && (s==2)) return(q1*(1-t3)+q2*t3);
  if((r==2) && (s==3)) return(q2);
  if((r==3) && (s==0)) return(q1);
  if((r==3) && (s==1)) return(q1);
  if((r==3) && (s==2)) return(q1);
  if((r==4) && (s==0)) return(q1);
  if((r==4) && (s==1)) return(q1);
  if((r==5) && (s==0)) return(q1);
 /* security */
 return(0.);
}

double sum_cpt3_prod(b,c)
double b[],c[];
{
 double temp=0.;

 /* adding a_006 */
 temp=temp+b[0]*c[0];
 /* adding a_015 */
 temp=temp+(b[0]*c[1]+b[1]*c[0])/2;
 /* adding a_024 */
 temp=temp+(b[0]*c[2]+3*b[1]*c[1]+b[2]*c[0])/5;
 /* adding a_033 */
 temp=temp+(b[0]*c[3]+9*b[1]*c[2]+9*b[2]*c[1]+b[3]*c[0])/20;
 /* adding a_042 */
 temp=temp+(b[1]*c[3]+3*b[2]*c[2]+b[3]*c[1])/5;
 /* adding a_051 */
 temp=temp+(b[2]*c[3]+b[3]*c[2])/2;
 /* adding a_060 */
 temp=temp+b[3]*c[3];
 /* adding a_105 */
 temp=temp+(b[0]*c[4]+b[4]*c[0])/2;
 /* adding a_114 */
 temp=temp+(2*b[0]*c[5]+3*b[1]*c[4]+3*b[4]*c[1]+2*b[5]*c[0])/10;
 /* adding a_123 */
 temp=temp+(b[0]*c[6]+6*b[1]*c[5]+3*b[2]*c[4]
	    +3*b[4]*c[2]+6*b[5]*c[1]+b[6]*c[0])/20;
 /* adding a_132 */
 temp=temp+(3*b[1]*c[6]+6*b[2]*c[5]+b[3]*c[4]
	    +b[4]*c[3]+3*(2*b[5]*c[2]+b[6]*c[1]))/20;
 /* adding a_141 */
 temp=temp+(3*b[2]*c[6]+2*b[3]*c[5]+2*b[5]*c[3]+3*b[6]*c[2])/10;
 /* adding a_150 */
 temp=temp+(b[3]*c[6]+b[6]*c[3])/2;
 /* adding a_204 */
 temp=temp+(b[0]*c[7]+3*b[4]*c[4]+b[7]*c[0])/5;
 /* adding a_213 */
 temp=temp+(b[0]*c[8]+3*b[1]*c[7]+6*b[4]*c[5]
	    +6*b[5]*c[4]+3*b[7]*c[1]+b[8]*c[0])/20;
 /* adding a_222 */
 temp=temp+(b[1]*c[8]+b[2]*c[7]+b[4]*c[6]+4*b[5]*c[5]
	    +b[6]*c[4]+b[7]*c[2]+b[8]*c[1])/10;
 /* adding a_231 */
 temp=temp+(3*b[2]*c[8]+b[3]*c[7]+6*b[5]*c[6]
	    +6*b[6]*c[5]+b[7]*c[3]+3*b[8]*c[2])/20;
 /* adding a_240 */
 temp=temp+(b[3]*c[8]+3*b[6]*c[6]+b[8]*c[3])/5;
 /* adding a_303 */
 temp=temp+(b[0]*c[9]+b[9]*c[0]+9*(b[4]*c[7]+b[7]*c[4]))/20;
 /* adding a_312 */
 temp=temp+(b[9]*c[1]+b[1]*c[9]+3*(b[4]*c[8]
	    +2*b[5]*c[7]+2*b[7]*c[5]+b[8]*c[4]))/20;
 /* adding a_321 */
 temp=temp+(b[9]*c[2]+b[2]*c[9]+3*(2*b[5]*c[8]
	    +b[6]*c[7]+b[7]*c[6]+2*b[8]*c[5]))/20;
 /* adding a_330 */
 temp=temp+(b[9]*c[3]+b[3]*c[9]+9*(b[6]*c[8]+b[8]*c[6]))/20;
 /* adding a_402 */
 temp=temp+(b[9]*c[4]+b[4]*c[9]+3*b[7]*c[7])/5;
 /* adding a_411 */
 temp=temp+(2*b[9]*c[5]+2*b[5]*c[9]+3*(b[7]*c[8]+b[8]*c[7]))/10;
 /* adding a_420 */
 temp=temp+(b[9]*c[6]+b[6]*c[9]+3*b[8]*c[8])/5;
 /* adding a_501 */
 temp=temp+(b[9]*c[7]+b[7]*c[9])/2;
 /* adding a_510 */
 temp=temp+(b[9]*c[8]+b[8]*c[9])/2;
 /* adding a_600 */
 temp=temp+b[9]*c[9];
 return(temp);
}
