/*****************************************************************/
/*      netsolveproblems.c                                       */
/*      Henri Casanova          			   	 */
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "proxyjobdesc.h"
#include "proxy.h"

/*
 * Displays the list of available problems
 */
int main(int argc, char **argv)
{
  NS_ProblemDesc **problem_list;
  int nb_problems;
  int i;
  int proxy_pid=0;

  if (argc != 2)
  {
    fprintf(stderr,"Usage: %s <agent hostname>\n",argv[0]);
    exit(-1);
  }
   
  /* start the proxy */
  if (startProxy("NetSolve",argv[1],&proxy_pid,&proxy_port) == -1)
  {
    fprintf(stderr,"Error while starting the proxy.\n");
    exit(-1);
  }

  nb_problems = getAllProblems(&problem_list);

  /* Error */
  if (nb_problems == -1)
  {
    netsolvePerror("getAllProblems()");
    exit(-1);
  }

  /* sorting the list */
  qsort(problem_list,nb_problems,sizeof(NS_ProblemDesc *),problemOrder);

  /* Printing the list */
  for (i=0;i<nb_problems;i++)
  {
    fprintf(stdout,"%s\n",problem_list[i]->name);
  }

  for (i=0;i<nb_problems;i++)
    freeProblemDesc(problem_list[i]);
  free(problem_list);

  exit(0);
}
