/*****************************************************************/
/*      netsolvekillagent.c                                      */
/*      Henri Casanova, Dorian Arnold           			   	 */
/*****************************************************************/

#include "core.h"
#include "client.h"

/*
 * Kill an agent
 */
int main(int argc, char **argv)
{
  int sock;
  NS_Communicator *comm;
  char *username;
  int status;
  char * hostname;

  if (argc != 2)
  {
    fprintf(stderr,"Usage: %s <agent hostname>\n",argv[0]);
    exit(-1);
  }

  username = getUserName();
  if (username == NULL)
  {
    exit(-1);
  }

  hostname = getHostName();
  if (hostname == NULL)
  {
    exit(-1);
  }

  sock = connectToSocket(argv[1],0,AGENT_PORT);
  if (sock == -1 )
  {
    netsolvePerror("connectToSocket()");
    free(username);
    exit(-1);
  }

  comm = initTransaction(sock,DATA_XDR);
  if (comm == NULL)
  {
    netsolvePerror("initTransaction()");
    free(username);
    exit(-1);
  }

  if (sendInt(comm,NS_PROT_KILL_AGENT) == -1)
  {
    netsolvePerror("sendInt()");
    free(username);
    exit(-1);
  }
  if (sendString(comm,username) == -1)
  {
    netsolvePerror("sendString()");
    free(username);
    exit(-1);
  }
  free(username);

  if (sendString(comm,hostname) == -1)
  {
    netsolvePerror("sendString()");
    free(hostname);
    exit(-1);
  }
  free(hostname);

  if (recvInt(comm,&status) == -1)
  {
    netsolvePerror("recvInt()");
    free(username);
    exit(-1);
  }

  switch(status)
  {
    case NS_PROT_KILLED:
      fprintf(stderr,"Agent on %s : killed\n",argv[1]);
      break;
    case NS_PROT_NOT_ALLOWED:
      fprintf(stderr,"Agent on %s : no permission to kill\n",argv[1]);
      break;
    default:
      fprintf(stderr,"Agent on %s : failure\n",argv[1]);
      break;
  }
  exit(0);
}
