/*
 * Test dgemm 
 * 2000 - Jakob Ostergaard
 *
 * $Id: test_dgemm.c,v 1.2 2000/12/14 16:11:42 darnold Exp $
 */

#include "regression.h"
#include "netsolve.h"

#define MEDIUM 200
#define LARGE 300

double * A, * B, * Q, * C, * C2;
double alpha, beta;

int main(int argc, char** argv)
{
  test_init("dgemm");

  netslmajor("col");

  /*
   * A :  SMALL x MEDIUM random
   * B :  MEDIUM x LARGE random
   * Q :  LARGE x LARGE random
   * C :  copy of Q
   */
  A = tgen_matrix_random(LARGE, MEDIUM);
  B = tgen_matrix_random(MEDIUM, LARGE);
  Q = tgen_matrix_random(LARGE, LARGE);
  C = tgen_matrix_copy(Q, LARGE, LARGE);
 
  /*
   * C  <-  42 * A * B + 86 * Q
   */
  subtest_submit("dgemm() C");
  alpha = 42; beta = 86;
  netsl("dgemm()", "N", "N",
	LARGE, LARGE, MEDIUM, &alpha, A, LARGE, B, MEDIUM, &beta, C, LARGE);
  subtest_complete();

  /*
   * We cannot check this result - we just assume all is ok for now 
   */
  subtest_unchecked();

  /*
   * C2 <- -42 / 86 * A * B + 1 / 86 * C
   *     = Q
   */
  C2 = tgen_matrix_copy(C, LARGE, LARGE);
  subtest_submit("dgemm() C2");
  alpha = (double)-42/86;  beta = (double)1/86;
  netsl("dgemm()", "N", "N",
	LARGE, LARGE, MEDIUM, &alpha, A, LARGE, B, MEDIUM, &beta, C2, LARGE);
  subtest_complete();

  /*
   * Compare Q and C2 - now we can actually check whether the
   * previous calculation and the one just completed actually
   * both worked, or if one or both failed (but we will never
   * know whether only one or both of them failed).
   */
  if(tgen_matrix_compare(C2, Q, LARGE, LARGE)) {
    subtest_fail("C2 != Q");
  } else {
    subtest_success();
  }

  test_exit();
  return 0;
}
