/******************************************************************/
/*                                                                */
/*    Testing the Sequencing routines                             */
/*                                                                */
/*    Author: Dieter Bachmann                                     */
/*                                                                */
/******************************************************************/


#include "netsolve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>


int vm_compare (int* v1, int *v2, int m, int n){
    int i;
    int j;
    
    for (i=0; i<m; i++){
	for (j =0 ; j< n; j++){
	    if (v1[j+n*i] != v2[j+n*i])
		return 0;
	}
    }
    return 1;
    
}



int main () {



int mA =1000;
int mB =200;
/*  int mC =300; */
/*  int mD =400; */
/*  int mE =400; */
/*  int mF =500; */
/*  int mG =600; */


/*  int nA =100; */
int nB =200;
/*  int nC =300; */
/*  int nD =400; */
/*  int nE =400; */
/*  int nF =500; */
/*  int nG =600; */

int *A= malloc(mA *sizeof(int));
int *B= malloc(mB * nB *sizeof(int));
int *C= malloc(mA *sizeof(int));
/*  int *D= malloc(sizeof(int)); */
/*  int *E= malloc(sizeof(int)); */
int *F= malloc(mB * nB *sizeof(int));
/*  int *G= malloc(sizeof(int)); */
/*  int *H= malloc(sizeof(int)); */
/*  int *I= malloc(sizeof(int)); */
/*  int *J= malloc(sizeof(int)); */


char *str;
int  number;
char *ostr;
int  onumber;

/*  int l = 0; */

int myStatus;

/*  int i = 10; */

A[50] = 100;
B[50] = 1000;


  printf("-----------------------------------\n");
  printf("Testing problems - no sequencing\n");
  myStatus = netsl("mpass()",B,mB,nB,-1,F);

  if (!(vm_compare(B,F,mB,nB))){
    printf("Matrix test error\n");
    printf( "\n%75s\n", "Result: Failure");
  } 
  else{
   printf("Matrix test passed\n");
   printf( "\n%75s\n", "Result: Success");
  }

  myStatus = netsl("vpass()",A,mA,C); 
  if (!(vm_compare(A,C,mA,1))){
    printf("Vector test not passed\n");
    printf( "\n%75s\n", "Result: Failure");
  }
  else{
    printf("Vector Test passed\n"); 
    printf( "\n%75s\n", "Result: Success");
  }


  myStatus = netsl("pass()",A,mA,B,mB, nB,-1,C,F);
  if (!(vm_compare(A,C,mA,1)) &&  !(vm_compare(B,F,mB,nB))){
    printf("Vector & matrix test not passed\n");
    printf( "\n%75s\n", "Result: Failure");
  }
  else{
    printf("Vector and Matrix test passed\n");
    printf( "\n%75s\n", "Result: Success");
  }


  number = 123456;

  str = strdup("this is a test"); 
  ostr = malloc(1000);  strcpy(ostr, "obviously wrong result");

  myStatus = netsl("multipass()",A,mA,B,mB, nB,-1,&number,str,C,F,&onumber,ostr);

  if(strcmp(str, ostr) || number != onumber) {
    printf("multipass test failed! str = \"%s\", ostr = \"%s\" number=%d onumber =%d\n",
           str, ostr, number, onumber);
    printf( "\n%75s\n", "Result: Failure");
  }
  else {
    printf("multipass string result ok\n");
    printf( "\n%75s\n", "Result: Success");
  }

  printf("-----------------------------------\n");
  printf("begin sequence test: passback all\n");
  A[50] = 5;
  B[50] = 20;

  netsl_sequence_begin(); 
  myStatus = netsl("mpass()",B,mB,nB,-1,F);
  myStatus = netsl("vpass()",A,mA,C); 
  myStatus = netsl("vpass()",A,mA,C);
  myStatus = netsl("pass()",A,mA,B,mB, nB,-1,C,F);

/*NETSL_END(A,B,F); */
  netsl_sequence_end(NS_NULL); 
  if (!(vm_compare(A,C,mA,1)) &&  !(vm_compare(B,F,mB,nB))){
    printf("Vector & matrix test not passed\n");
    printf( "\n%75s\n", "Result: Failure");
  }
  else{
    printf("Vector & matrix test passed\n");
    printf( "\n%75s\n", "Result: Success");
  }


  printf("-----------------------------------\n");
  printf("begin sequencs test passback matrix\n");
  A[50] = 25;
  B[50] = 11;

  netsl_sequence_begin(); 
  myStatus = netsl("mpass()",B,mB,nB,-1,F);
  myStatus = netsl("vpass()",A,mA,C); 
  myStatus = netsl("vpass()",A,mA,C);
  myStatus = netsl("pass()",A,mA,B,mB, nB,-1,C,F);

/*NETSL_END(A,B,F); */
  netsl_sequence_end(C, NS_NULL); 
  if (!(vm_compare(B,F,mB,nB))){
    printf("Matrix test error\n");
    printf( "\n%75s\n", "Result: Failure");
  }
  else{
    printf("Matrix test passed\n");
    printf( "\n%75s\n", "Result: Success");
  }


  printf("-----------------------------------\n");
  printf("begin sequencs test passback vector\n");

  A[50] = 33;
  B[50] = 44;

  netsl_sequence_begin(); 
  myStatus = netsl("mpass()",B,mB,nB,-1,F);
  myStatus = netsl("vpass()",A,mA,C); 
  myStatus = netsl("vpass()",A,mA,C);
  myStatus = netsl("pass()",A,mA,B,mB, nB,-1,C,F);

/*NETSL_END(A,B,F); */
  netsl_sequence_end(F,NS_NULL); 

  if (!(vm_compare(A,C,mA,1))){
    printf("Vector test not passed\n");
    printf( "\n%75s\n", "Result: Failure");
  }
  else{
    printf("Vector test passed\n");
    printf( "\n%75s\n", "Result: Success");
  }


  printf("--------------------------------------\n");
  printf("begin sequencs test multiple arguments\n");

  A[50] = 33;
  B[50] = 44;

  number = 123456;
  free(str); str = strdup("yet another test");
  strcpy(ostr, "this result is wrong");

  netsl_sequence_begin(); 
  myStatus = netsl("mpass()",B,mB,nB,-1,F);
  myStatus = netsl("vpass()",A,mA,C); 
  myStatus = netsl("vpass()",A,mA,C);
  myStatus = netsl("multipass()",A,mA,B,mB, nB,-1,&number,str,C,F,&onumber,ostr);

/*NETSL_END(A,B,F); */
  netsl_sequence_end(NS_NULL); 

  if (strcmp(str,ostr) || !(vm_compare(A,C,mA,1)) ||
      !(vm_compare(B,F,mB,nB)) || number != onumber){
    printf("multi test not passed\n");
    printf( "\n%75s\n", "Result: Failure");
  }
  else{
    printf("multi test passed\n");
    printf( "\n%75s\n", "Result: Success");
  }
  printf("End test\n");

  return 0; 
}
