fprintf(2, 'Testing the NetSolve MATLAB interface\n')
fprintf(2, '-------------------------------------\n')
fprintf(2, ' \n')
fprintf(2, ' This script will send several requests to NetSolve and\n')
fprintf(2, ' display the results of these requests. Make sure you have\n')
fprintf(2, ' read the README file and that you have set your environment\n')
fprintf(2, ' variables correctly. Depending on your location and on the \n')
fprintf(2, ' location of the NetSolve agent you are contacting - environment\n')
fprintf(2, ' variable NETSOLVE_AGENT - this test can last from 15 \n')
fprintf(2, ' seconds to a couple of minutes.\n')
fprintf(2, ' \n')
fprintf(2, ' ----------------------------------------------------\n')
dummy = input('Press Enter to proceed with the testing');
fprintf(2, ' ----------------------------------------------------\n')
m = input('Enter the size of the matrix and vector to be used : ');
fprintf(2, ' ----------------------------------------------------\n')
fprintf(2, 'Generating a %dx%d matrix ....\n',m,m)
a = rand(m);
fprintf(2, 'Generating a vector of size %d ...\n',m)
b = rand(m,1);
fprintf(2, '\n** Test #1 : Sending a blocking request for "linsol"\n\n')
fprintf(2, 'Sending the request :\n')
[x] = netsolve('linsol',a,b);
[e] = netsolve_err;
if (e == 0)
  fprintf(2, '***********\n')
  fprintf(2, '* Success *\n')
  fprintf(2, '************\n')
else
  fprintf(2,'%s\n',netsolve_errmsg(e))
  fprintf(2, '** Failure **')
end

fprintf(2, '\n** Test #2 : Sending a non-blocking request for "linsol"\n') 
fprintf(2,   '             and waiting\n\n') 
fprintf(2, 'Sending the request :\n')
[r] = netsolve_nb('send','linsol',a,b);
if (r == -1)
  e = netsolve_err;
  fprintf(2,'%s\n',netsolve_errmsg(e))
  fprintf(2, '** Failure **\n')
else
  fprintf(2, 'Waiting for completion\n')
  x = netsolve_nb('wait',r) ;
  e = netsolve_err;
  if (e == 0)
    fprintf(2, '***********\n')
    fprintf(2, '* Success *\n')
    fprintf(2, '************\n')
  else
    fprintf(2,'%s\n',netsolve_errmsg(e))
    fprintf(2, '** Failure **\n')
  end
end

fprintf(2, '\n** Test #3 : Sending a non-blocking request for "linsol"\n')
fprintf(2,   '             and probing\n\n')
fprintf(2, 'Sending the request :\n')
[r] = netsolve_nb('send','linsol',a,b);
if (r == -1)
  e = netsolve_err;
  fprintf(2,'%s\n',netsolve_errmsg(e))
  fprintf(2, '** Failure **\n')
else
  while (1)
    fprintf(2, 'probing....\n')
    x = netsolve_nb('probe',r) ;
    e = netsolve_err;
    if (e ~= -1)
      break;
    end
    pause(1)
  end
  if (e == 0)
      fprintf(2, '***********\n')
      fprintf(2, '* Success *\n')
      fprintf(2, '************\n')
  else
    fprintf(2,'%s\n',netsolve_errmsg(e))
    fprintf(2, '** Failure **\n')
  end
end


fprintf(2, '\n** Test #4 : Displaying the available servers and agents\n\n')
pause(2);
netsolve('?');
pause(1);

fprintf(2, '\n** Test #5 : Displaying the description of "linsol"\n\n')
pause(1);
netsolve('linsol');

fprintf(2, '       ** End of testing **\n\n');

pause(1);


