fprintf(2, '\n** Sending a blocking request for "SuperLU"\n\n')
clear
[A,rhs]=generate(1);
[x]=netsolve('sparse_direct_solve','SUPERLU',A,rhs,0.3,1);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  r=norm(full(A*x-rhs))/(norm(full(A))*norm(full(x))*eps);
  if ( r > 50.0 )
    fprintf(2, '** SuperLU Failure **')
    r
  else
    fprintf(2, '** SuperLU Passed Tests **\n')
  end
end
