fprintf(2, '\n** Sending a blocking request for "PETSc"\n\n')
clear
[A,rhs]=generate(1);
[x,its]=netsolve('sparse_iterative_solve','PETSC',A,rhs,1.e-6,500);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  seps=1.e-6;
  r=norm(full(A*x-rhs))/(norm(full(A))*norm(full(x))*seps);
  if ( r > 50.0 )
    fprintf(2, '** PETSc Failure **')
    r
  else
    fprintf(2, '** PETSc Passed Tests **\n')
  end
end
