fprintf(2, '\n** Sending a blocking request for "ma28"\n\n')
clear
[A,rhs]=generate(1);
[x]=netsolve('sparse_direct_solve','MA28',A,rhs,0.3,1);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  r=norm(full(A*x-rhs))/(norm(full(A))*norm(full(x))*eps);
  if ( r > 50.0 )
    fprintf(2, '** MA28 Failure **')
    r
  else
    fprintf(2, '** MA28 Passed Tests **\n')
  end
end
