%/*****************************************************************/
%/*      lapack_test.m                                            */
%/*      Susan Blackford and Tinghua Xu                           */
%/*---------------------------------------------------------------*/
%/*****************************************************************/

fprintf(2, '------------------------------------------------\n')
fprintf(2, 'Testing the NetSolve MATLAB LAPACK interfaces...\n')
fprintf(2, '------------------------------------------------\n')
fprintf(2, ' \n')
fprintf(2, '---------------------------------------------------\n')
fprintf(2, 'Testing Simple Driver routines for Linear Equations\n')
fprintf(2, '---------------------------------------------------\n')
fprintf(2, '\n** Sending a blocking request for "dgesv"\n\n')
count = 0;
failcount = 0;
n = 20;
a = rand(n);
b = rand(n,2);
[x,y,z,info]=netsolve('dgesv',a,b);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  r=norm(a*z-b)/(norm(a)*norm(z)*n*eps);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DGESV Failure **')
    r
    failcount = failcount + 1;
  end
end

fprintf(2, '\n** Sending a blocking request for "dgbsv"\n\n') 
clear ku kl B A C Ab IPIV X info r
C=rand(20);
ku=8;
kl=6;
B=rand(20,5);
for i=1:20
  for j=max(1,i-kl):min(20,i+ku)
        A(i,j)=C(i,j);
  end
end
for j=1:20
  for i=max(1,j-ku):min(20,j+kl)
        Ab(kl+ku+1+i-j,j)=A(i,j);
  end
end
[Ab,IPIV,X,info]=netsolve('dgbsv',kl,ku,Ab,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  r=norm(A*X-B)/(norm(A)*norm(X)*20*eps);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DGBSV Failure **')
    r
    failcount = failcount + 1;
  end
end

fprintf(2, '\n** Sending a blocking request for "dgtsv"\n\n') 
%clear
B=rand(5,1);
C=rand(5);
DL=diag(C,-1);
D=diag(C);
DU=diag(C,1);
A=diag(D)+diag(DL,-1)+diag(DU,1);
[DL,D,DU,X,info]=netsolve('dgtsv',DL,D,DU,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  r=norm(A*X-B)/(norm(A)*norm(X)*5*eps);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DGTSV Failure **')
    r
    failcount = failcount + 1;
  end
end

fprintf(2, '\n** Sending a blocking request for "dposv"\n\n') 
%clear
n=20;
c=rand(n);
b=rand(n,5);
a=c*c';
[a1,x,info]=netsolve('dposv','U',a,b);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  r1=norm(a*x-b)/(norm(a)*norm(x)*n*eps);
  if ( info ~= 0 | r1 > 50.0 )
    fprintf(2, '** DPOSV(U) Failure **')
    r1
    failcount = failcount + 1;
  end
end

[a1,x,info]=netsolve('dposv','L',a,b);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  r2=norm(a*x-b)/(norm(a)*norm(x)*n*eps);
  if ( info ~= 0 | r2 > 50.0 )
    fprintf(2, '** DPOSV(L) Failure **')
    r2
    failcount = failcount + 1;
  end
end

fprintf(2, '\n** Sending a blocking request for "dpbsv"\n\n') 
clear C1 KU KL B C2 A KD AB1 X info r1
C1=rand(20);
KU=4;
KL=3;
B=rand(20,5);
for i=1:20
  for j=max(1,i-KL):min(20,i+KU)
        C2(i,j)=C1(i,j);
  end
end
A=C2*C2';
KD=KU+KL;
for j=1:20
  for i=max(1,j-KD):j
        AB1(KD+1+i-j,j)=A(i,j);
  end
end
[AB1,X,info]=netsolve('dpbsv','U',KD,AB1,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  r1=norm(A*X-B)/(norm(A)*norm(X)*20*eps);
  if ( info ~= 0 | r1 > 50.0 )
    fprintf(2, '** DPBSV(U) Failure **')
    r1
    failcount = failcount + 1;
  end
end


for j=1:20
  for i=j:min(20,j+KD)
        AB2(1+i-j,j)=A(i,j);
  end
end
[AB2,X,info]=netsolve('dpbsv','L',KD,AB2,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  r2=norm(A*X-B)/(norm(A)*norm(X)*20*eps);
  if ( info ~= 0 | r2 > 50.0 )
    fprintf(2, '** DPBSV(L) Failure **')
    r2
    failcount = failcount + 1;
  end
end

fprintf(2, '\n** Sending a blocking request for "dptsv"\n\n') 
B=rand(20,5);
C1=rand(20);
DL1=diag(C1,-1);
D1=diag(C1);
%DU1=diag(C1,+1);
C2=diag(D1)+diag(DL1,-1);
A=C2*C2';
D=diag(A);
E=diag(A,-1);
[D,E,X,info]=netsolve('dptsv',D,E,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  r=norm(A*X-B)/(norm(A)*norm(X)*eps);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DPTSV Failure **')
    r
    failcount = failcount + 1;
  end
end

fprintf(2, '\n** Sending a blocking request for "dsysv"\n\n')
B=rand(20,5);
C=rand(20);
A=C+C';
[A1,IPIV,X,info]=netsolve('dsysv','U',A,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  r1=norm(A*X-B)/(norm(A)*norm(X)*eps);
  if ( info ~= 0 | r1 > 50.0 )
    fprintf(2, '** DSYSV(U) Failure **')
    r1
    failcount = failcount + 1;
  end
end

[A1,IPIV,X,info]=netsolve('dsysv','L',A,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  r2=norm(A*X-B)/(norm(A)*norm(X)*eps);
  if ( info ~= 0 | r2 > 50.0 )
    fprintf(2, '** DSYSV(L) Failure **')
    r2
    failcount = failcount + 1;
  end
end

fprintf(2, '---------------------------------------------------\n')
fprintf(2, 'Testing Simple Drivers for Standard and Generalized\n')
fprintf(2, 'Linear Least Squares Problems\n')
fprintf(2, '---------------------------------------------------\n')

fprintf(2, '\n** Sending a blocking request for "dgels"\n\n')
clear M N A B X X1 A0 info r
%M>N and Least Square
M=10;
N=5;
A=rand(M,N);
B=rand(M,2);
[A0,X,info]=netsolve('dgels','N',A,B);
X1=zeros(N,2);
X1=X(1:N,:);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
%r=norm(A*X1-B)/(norm(A)*norm(X1)*M*eps);
  r=0.0;
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DGELS(M>N) Failure **')
    r
    failcount = failcount + 1;
  end
end
%M=N
clear M N A B A0 X r
M=10;
N=10;
A=rand(M,N);
B=rand(M,2);
[A0,X,info]=netsolve('dgels','N',A,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  r=norm(A*X-B)/(norm(A)*norm(X)*N*eps);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DGELS(M=N) Failure **')
    r
    failcount = failcount + 1;
  end
end
clear M N A B X X1 A0 info r
%M<N and Least Square
M=20;
N=25;
A=rand(M,N);
B=rand(N,5);
[A0,X,info]=netsolve('dgels','N',A,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
%r=norm(A*X-B)/(norm(A)*norm(X)*N*eps);
  r=0.0;
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DGELS(M<N) Failure **')
    r
    failcount = failcount + 1;
  end
end

%fprintf(2, '\n** Sending a blocking request for "dgglse"\n\n')
%clear M N P A B C D E X info
%M=20;
%N=25;
%P=8;
%A=rand(M,N);
%B=rand(P,N);
%C=rand(M,1);
%D=rand(P,1);
%[C,X,info]=netsolve('dgglse',A,B,C,D);
%r = 0.0;
%[e] = netsolve_err;
%count = count + 1;
%
%if (e ~= 0 | info ~= 0 | r > 50.0 )
%  fprintf(2,'%s\n',netsolve_errmsg(e))
%  fprintf(2, '** DGGLSE Failure **')
%  r
%  failcount = failcount + 1;
%end

fprintf(2, '\n** Sending a blocking request for "dggglm"\n\n')
clear M N P A B D X Y info
M=20;
N=25;
P=8;
A=rand(N,M);
B=rand(N,P);
D=rand(N,1);
[A,B,D,X,Y,info]=netsolve('dggglm',A,B,D);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  r = 0.0;
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DGGGLM Failure **')
    r
    failcount = failcount + 1;
  end
end


fprintf(2, '-----------------------------------------------------------\n')
fprintf(2, 'Testing Simple, Divide and Conquer, Expert, and RRR\n')
fprintf(2, 'Drivers for Standard Eigenvalue and Singular Value Problems\n')
fprintf(2, '-----------------------------------------------------------\n')

fprintf(2, '\n** Sending a blocking request for "dsyev"\n\n')
N=20;
C=rand(N);
A=C+C';
[X,W,info]=netsolve('dsyev','V','U',A);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r1(k)=norm(A*X(:,k)-W(k)*X(:,k))/(norm(A)*norm(X(:,k))*eps);
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEV(U) Failure **')
    r
    failcount = failcount + 1;
  end
end

clear r X W info
[X,W,info]=netsolve('dsyev','V','L',A);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r2(k)=norm(A*X(:,k)-W(k)*X(:,k))/(norm(A)*norm(X(:,k))*eps);
  end
  r=max(r2);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEV(L) Failure **')
    r
    failcount = failcount + 1;
  end
end


fprintf(2, '\n** Sending a blocking request for "dsyevd"\n\n')
clear N C A X W info r1 r
N=20;
C=rand(N);
A=C+C';
[X,W,info]=netsolve('dsyevd','V','U',A);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r1(k)=norm(A*X(:,k)-W(k)*X(:,k))/(norm(A)*norm(X(:,k))*eps);
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEVD(U) Failure **')
    r
    failcount = failcount + 1;
  end
end

clear N C A r r2 X W info
N=20;
C=rand(N);
A=C+C';
[X,W,info]=netsolve('dsyevd','V','L',A);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r2(k)=norm(A*X(:,k)-W(k)*X(:,k))/(norm(A)*norm(X(:,k))*eps);
  end
  r=max(r2);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEVD(L) Failure **')
    r
    failcount = failcount + 1;
  end
end

fprintf(2, '\n** Sending a blocking request for "dsyevx"\n\n')
clear N C A vl vu il iu abstol r r2 m W Z isuppz info
N=20;
C=rand(N);
A=C+C';
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[m,W,Z,ifail,info]=netsolve('dsyevx','V','A','U',A,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r2(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  r=max(r2);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEVX(V,A,U) Failure **')
    r
    failcount = failcount + 1;
  end
end

clear N C A vl vu il iu abstol r r2 m W Z isuppz info
N=20;
C=rand(N);
A=C+C';
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[m,W,Z,ifail,info]=netsolve('dsyevx','V','A','L',A,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r2(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  r=max(r2);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEVX(V,A,L) Failure **')
    r
    failcount = failcount + 1;
  end
end

clear N C A vl vu il iu abstol r r2 m W Z isuppz info
N=20;
C=rand(N);
A=C+C';
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[m,W,Z,ifail,info]=netsolve('dsyevx','V','V','U',A,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r2(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  r=max(r2);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEVX(V,V,U) Failure **')
    r
    failcount = failcount + 1;
  end
end

clear N C A vl vu il iu abstol r r2 m W Z isuppz info
N=20;
C=rand(N);
A=C+C';
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[m,W,Z,ifail,info]=netsolve('dsyevx','V','V','L',A,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r2(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  r=max(r2);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEVX(V,V,L) Failure **')
    r
    failcount = failcount + 1;
  end
end

clear N C A vl vu il iu abstol r r2 m W Z isuppz info
N=20;
C=rand(N);
A=C+C';
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[m,W,Z,ifail,info]=netsolve('dsyevx','V','I','U',A,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r2(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  r=max(r2);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEVX(V,I,U) Failure **')
    r
    failcount = failcount + 1;
  end
end

clear N C A vl vu il iu abstol r r2 m W Z isuppz info
N=20;
C=rand(N);
A=C+C';
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[m,W,Z,ifail,info]=netsolve('dsyevx','V','I','L',A,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r2(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  r=max(r2);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEVX(V,I,L) Failure **')
    r
    failcount = failcount + 1;
  end
end

fprintf(2, '\n** Sending a blocking request for "dsyevr"\n\n')
clear N C A vl vu il iu abstol r r2 m W Z isuppz info
N=20;
C=rand(N);
A=C+C';
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[m,W,Z,isuppz,info]=netsolve('dsyevr','V','A','U',A,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r2(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  r=max(r2);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEVR(V,A,U) Failure **')
    r
    failcount = failcount + 1;
  end
end

clear N C A vl vu il iu abstol r r2 m W Z isuppz info
N=20;
C=rand(N);
A=C+C';
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[m,W,Z,isuppz,info]=netsolve('dsyevr','V','A','L',A,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r2(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  r=max(r2);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEVR(V,A,L) Failure **')
    r
    failcount = failcount + 1;
  end
end

clear N C A vl vu il iu abstol r r2 m W Z isuppz info
N=20;
C=rand(N);
A=C+C';
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[m,W,Z,isuppz,info]=netsolve('dsyevr','V','V','U',A,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r2(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  r=max(r2);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEVR(V,V,U) Failure **')
    r
    failcount = failcount + 1;
  end
end

clear N C A vl vu il iu abstol r r2 m W Z isuppz info
N=20;
C=rand(N);
A=C+C';
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[m,W,Z,isuppz,info]=netsolve('dsyevr','V','V','L',A,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r2(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  r=max(r2);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEVR(V,V,L) Failure **')
    r
    failcount = failcount + 1;
  end
end

% RANGE='I' is not yet supported in DSTEGR
%
%clear
%N=20;
%C=rand(N);
%A=C+C';
%vl=2.0;
%vu=5.0;
%il=1;
%iu=N;
%abstol=2*eps;
%[m,W,Z,isuppz,info]=netsolve('dsyevr','V','I','U',A,vl,vu,il,iu,abstol);
%  fprintf(2,'info = %s\n',info)
%for k=1:m
%    r5(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
%end
%r=max(r5);
%[e] = netsolve_err;
%
%if (e ~= 0 | info ~= 0 | r > 50.0 )
%  fprintf(2,'%s\n',netsolve_errmsg(e))
%  fprintf(2, '** DSYEVR(V,I,U) Failure **')
%  r
%else
%  fprintf(2, '** DSYEVR(V,I,U) Passed Tests **\n')
%end
%
%clear
%N=20;
%C=rand(N);
%A=C+C';
%vl=2.0;
%vu=5.0;
%il=1;
%iu=N;
%abstol=2*eps;
%[m,W,Z,isuppz,info]=netsolve('dsyevr','V','I','L',A,vl,vu,il,iu,abstol);
%[e] = netsolve_err;
%fprintf(2,'%s\n',netsolve_errmsg(e))
%for k=1:m
%    r6(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
%end
%r=max(r6);
%
%if (e ~= 0 | info ~= 0 | r > 50.0 )
%  fprintf(2,'%s\n',netsolve_errmsg(e))
%  fprintf(2, '** DSYEVR(V,I,L) Failure **')
%  r
%else
%  fprintf(2, '** DSYEVR(V,I,L) Passed Tests **\n')
%end

fprintf(2, '\n** Sending a blocking request for "dsbev"\n\n')
clear N C1 KL KU KD B C2 A AB1 W Z info
N=20;
C1=rand(N);
KL=4;
KU=3;
B=rand(N,5);
for i=1:N
  for j=max(1,i-KL):min(N,i+KU)
        C2(i,j)=C1(i,j);
  end
end
KD=KL+KU;
A=C2+C2';
for j=1:N
  for i=max(1,j-KD):j
        AB1(KD+1+i-j,j)=A(i,j);
  end
end
W=zeros(N,1);
Z=zeros(N,N);
[AB1,W,Z,info]=netsolve('dsbev','V','U',KD,AB1);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r1(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  rr=max(r1);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DSBEV(U) Failure **')
    rr
    failcount = failcount + 1;
  end
end

for j=1:N
  for i=j:min(N,j+KD)
        AB2(1+i-j,j)=A(i,j);
  end
end
[AB2,W,Z,info]=netsolve('dsbev','V','L',KD,AB2);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r2(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  clear rr
  rr=max(r2);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DSBEV(L) Failure **')
    rr
    failcount = failcount + 1;
  end
end


fprintf(2, '\n** Sending a blocking request for "dsbevd"\n\n')
clear N C1 KL KU KD B C2 A AB1 W Z info
N=20;
C1=rand(N);
KL=4;
KU=3;
B=rand(N,5);
for i=1:N
  for j=max(1,i-KL):min(N,i+KU)
        C2(i,j)=C1(i,j);
  end
end
A=C2+C2';
KD=KL+KU;
for j=1:N
  for i=max(1,j-KD):j
        AB1(KD+1+i-j,j)=A(i,j);
  end
end
W=zeros(N,1);
Z=zeros(N,N);
[AB1,W,Z,info]=netsolve('dsbevd','V','U',KD,AB1);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r1(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  rr=max(r1);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DSBEVD(U) Failure **')
    rr
    failcount = failcount + 1;
  end
end

for j=1:N
  for i=j:min(N,j+KD)
        AB2(1+i-j,j)=A(i,j);
  end
end
[AB2,W,Z,info]=netsolve('dsbevd','V','L',KD,AB2);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r2(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  clear rr
  rr=max(r2);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DSBEVD(L) Failure **')
    rr
    failcount = failcount + 1;
  end
end

fprintf(2, '\n** Sending a blocking request for "dsbevx"\n\n')
clear N C1 KL KU B C2 KD A AB1 W Z vl vu il iu abstol Q m W Z ifail info r rr
N=20;
C1=rand(N);
KL=4;
KU=3;
B=rand(N,5);
for i=1:N
  for j=max(1,i-KL):min(N,i+KU)
        C2(i,j)=C1(i,j);
  end
end
KD=KL+KU;
A=C2+C2';
for j=1:N
  for i=max(1,j-KD):j
        AB1(KD+1+i-j,j)=A(i,j);
  end
end
W=zeros(N,1);
Z=zeros(N,N);
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[AB1,Q,m,W,Z,ifail,info]=netsolve('dsbevx','V','A','U',KD,AB1,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  rr=max(r);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DSBEVX(V,A,U) Failure **')
    rr
    failcount = failcount + 1;
  end
end

clear Q m W Z ifail info r rr
for j=1:N
  for i=j:min(N,j+KD)
        AB2(1+i-j,j)=A(i,j);
  end
end
W=zeros(N,1);
Z=zeros(N,N);
[AB2,Q,m,W,Z,ifail,info]=netsolve('dsbevx','V','A','L',KD,AB2,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  clear rr
  rr=max(r);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DSBEVX(V,A,L) Failure **')
    rr
    failcount = failcount + 1;
  end
end

fprintf(2, '\n** Sending a blocking request for "dstev"\n\n')
clear N C1 DL1 DU1 C A D E1 E2 Z info r rr
N=20;
C1=rand(20);
DL1=diag(C1,-1);
D1=diag(C1);
DU1=diag(C1,+1);
C=diag(D1)+diag(DL1,-1)+diag(DU1,1);
A=C+C';
D=diag(A);
E1=diag(A,-1);
for i=1:N-1
  E2(i)=E1(i);
end
  E2(N)=0;
E=E2';
[D,E,Z,info]=netsolve('dstev','V',D,E);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r(k)=norm(A*Z(:,k)-D(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*N*eps);
  end
  rr=max(r);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DSTEV Failure **')
    rr
    failcount = failcount + 1;
  end
end


fprintf(2, '\n** Sending a blocking request for "dstevd"\n\n')
clear N C1 DL1 DU1 C A D E1 E2 Z info r rr
N=20;
C1=rand(20);
DL1=diag(C1,-1);
D1=diag(C1);
DU1=diag(C1,+1);
C=diag(D1)+diag(DL1,-1)+diag(DU1,1);
A=C+C';
D=diag(A);
E1=diag(A,-1);
for i=1:N-1
  E2(i)=E1(i);
end
  E2(N)=0;
E=E2';
[D,E,Z,info]=netsolve('dstevd','V',D,E);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r(k)=norm(A*Z(:,k)-D(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*N*eps);
  end
  rr=max(r);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DSTEVD Failure **')
    rr
    failcount = failcount + 1;
  end
end


fprintf(2, '\n** Sending a blocking request for "dstevx"\n\n')
clear N C1 DL1 D1 DU1 C A D E1 E2 E vl vu il iu abstol m W Z ifail info r rr
N=20;
C1=rand(20);
DL1=diag(C1,-1);
D1=diag(C1);
DU1=diag(C1,+1);
C=diag(D1)+diag(DL1,-1)+diag(DU1,1);
A=C+C';
D=diag(A);
E1=diag(A,-1);
for i=1:N-1
  E2(i)=E1(i);
end
  E2(N)=0;
E=E2';
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[m,W,Z,ifail,info]=netsolve('dstevx','V','A',D,E,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*m*eps);
  end
  rr=max(r);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DSTEVX(V,A) Failure **')
    rr
    failcount = failcount + 1;
  end
end

clear N C1 DL1 D1 DU1 C A D E1 E2 E vl vu il iu abstol m W Z ifail info r rr
N=20;
C1=rand(20);
DL1=diag(C1,-1);
D1=diag(C1);
DU1=diag(C1,+1);
C=diag(D1)+diag(DL1,-1)+diag(DU1,1);
A=C+C';
D=diag(A);
E1=diag(A,-1);
for i=1:N-1
  E2(i)=E1(i);
end
  E2(N)=0;
E=E2';
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[m,W,Z,ifail,info]=netsolve('dstevx','V','V',D,E,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*m*eps);
  end
  rr=max(r);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DSTEVX(V,V) Failure **')
    rr
    failcount = failcount + 1;
  end
end

clear N C1 DL1 D1 DU1 C A D E1 E2 E vl vu il iu abstol m W Z ifail info r rr
N=20;
C1=rand(20);
DL1=diag(C1,-1);
D1=diag(C1);
DU1=diag(C1,+1);
C=diag(D1)+diag(DL1,-1)+diag(DU1,1);
A=C+C';
D=diag(A);
E1=diag(A,-1);
for i=1:N-1
  E2(i)=E1(i);
end
  E2(N)=0;
E=E2';
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[m,W,Z,ifail,info]=netsolve('dstevx','V','I',D,E,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*m*eps);
  end
  rr=max(r);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DSTEVX(V,I) Failure **')
    rr
    failcount = failcount + 1;
  end
end


fprintf(2, '\n** Sending a blocking request for "dstevr"\n\n')
clear N C1 DL1 D1 DU1 C A D E1 E2 E vl vu il iu abstol m W Z isuppz info r rr
N=20;
C1=rand(20);
DL1=diag(C1,-1);
D1=diag(C1);
DU1=diag(C1,+1);
C=diag(D1)+diag(DL1,-1)+diag(DU1,1);
A=C+C';
D=diag(A);
E1=diag(A,-1);
for i=1:N-1
  E2(i)=E1(i);
end
  E2(N)=0;
E=E2';
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[m,W,Z,isuppz,info]=netsolve('dstevr','V','A',D,E,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*m*eps);
  end
  rr=max(r);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DSTEVR(V,A) Failure **')
    rr
    failcount = failcount + 1;
  end
end

clear N C1 DL1 D1 DU1 C A D E1 E2 E vl vu il iu abstol m W Z isuppz info r rr
N=20;
C1=rand(20);
DL1=diag(C1,-1);
D1=diag(C1);
DU1=diag(C1,+1);
C=diag(D1)+diag(DL1,-1)+diag(DU1,1);
A=C+C';
D=diag(A);
E1=diag(A,-1);
for i=1:N-1
  E2(i)=E1(i);
end
  E2(N)=0;
E=E2';
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[m,W,Z,isuppz,info]=netsolve('dstevr','V','V',D,E,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*m*eps);
  end
  rr=max(r);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DSTEVR(V,V) Failure **')
    rr
    failcount = failcount + 1;
  end
end

% RANGE='I' is not yet supported in DSTEGR
%
%clear
%N=20;
%C1=rand(20);
%DL1=diag(C1,-1);
%D1=diag(C1);
%DU1=diag(C1,+1);
%C=diag(D1)+diag(DL1,-1)+diag(DU1,1);
%A=C+C';
%D=diag(A);
%E1=diag(A,-1);
%for i=1:N-1
%  E2(i)=E1(i);
%end
%  E2(N)=0;
%E=E2';
%vl=2.0;
%vu=5.0;
%il=1;
%iu=N;
%abstol=2*eps;
%[m,W,Z,isuppz,info]=netsolve('dstevr','V','I',D,E,vl,vu,il,iu,abstol);
%for k=1:m
%    r3(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*m*eps);
%end
%rr=max(r3);
%[e] = netsolve_err;
%
%if (e ~= 0 | info ~= 0 | rr > 50.0 )
%  fprintf(2,'%s\n',netsolve_errmsg(e))
%  fprintf(2, '** DSTEVR(V,I) Failure **')
%  rr
%else
%  fprintf(2, '** DSTEVR(V,I) Passed Tests **\n')
%end

fprintf(2, '\n** Sending a blocking request for "dgeev"\n\n')
clear a wr wi vl vr info
a=rand(20);
[a,wr,wi,vl,vr,info]=netsolve('dgeev','N','V',a);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  r = 0.0;
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DGEEV Failure **')
    r
    failcount = failcount + 1;
  end
end

fprintf(2, '\n** Sending a blocking request for "dgesvd"\n\n')
clear M N A B S U VT info V r
M=25;
N=20;
A=rand(M,N);
[B,S,U,VT,info]=netsolve('dgesvd','A','A',A);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  V=VT';
  for i=1:N
    r(i)=norm(A*V(:,i)-S(i)*U(:,i))/(norm(A)*norm(V(:,i))*norm(U(:,i))*N*eps);
  end
  rr=max(r);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DGESVD Failure **')
    rr
    failcount = failcount + 1;
  end
end

fprintf(2, '\n** Sending a blocking request for "dgesdd"\n\n')
clear M N A B S U VT info V r rr
M=25;
N=20;
A=rand(M,N);
[B,S,U,VT,info]=netsolve('dgesdd','A',A);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  V=VT';
  for i=1:N
    r(i)=norm(A*V(:,i)-S(i)*U(:,i))/(norm(A)*norm(V(:,i))*norm(U(:,i))*N*eps);
  end
  rr=max(r);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DGESDD Failure **')
    rr
    failcount = failcount + 1;
  end
end

fprintf(2, '----------------------------------------------------------\n')
fprintf(2, 'Testing Simple, Divide and Conquer, and Expert Drivers for\n')
fprintf(2, 'Generalized Eigenvalue and Singular Value Problems\n')
fprintf(2, '----------------------------------------------------------\n')

fprintf(2, '\n** Sending a blocking request for "dsygv"\n\n')
clear N C1 A C2 B ITYPE A1 B1 W info r1 r
N=20;
C1=rand(N);
A=C1+C1';
C2=rand(N);
B=C2*C2';
ITYPE=1;
[A1,B1,W,info]=netsolve('dsygv',ITYPE,'N','U',A,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r1(k)=(norm(A*A1(:,k)-W(k)*B*A1(:,k)))/(norm(A)*norm(B)*norm(A1(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 250.0 )
    fprintf(2, '** DSYGV(ITYPE=1,UPLO=U) Failure **')
    r
    failcount = failcount + 1;
  end
end

clear A1 B1 W info r1 r
[A1,B1,W,info]=netsolve('dsygv',ITYPE,'N','L',A,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r1(k)=(norm(A*A1(:,k)-W(k)*B*A1(:,k)))/(norm(A)*norm(B)*norm(A1(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 250.0 )
    fprintf(2, '** DSYGV(ITYPE=1,UPLO=L) Failure **')
    r
    failcount = failcount + 1;
  end
end

ITYPE=2;
[A2,B2,W,info]=netsolve('dsygv',ITYPE,'V','U',A,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r1(k)=(norm(A*B*A2(:,k)-W(k)*A2(:,k)))/(norm(A*B)*norm(A2(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 250.0 )
    fprintf(2, '** DSYGV(ITYPE=2,UPLO=U) Failure **')
    r
    failcount = failcount + 1;
  end
end

clear A2 B2 W info r1 r
[A2,B2,W,info]=netsolve('dsygv',ITYPE,'V','L',A,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r1(k)=(norm(A*B*A2(:,k)-W(k)*A2(:,k)))/(norm(A*B)*norm(A2(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 250.0 )
    fprintf(2, '** DSYGV(ITYPE=2,UPLO=L) Failure **')
    r
    failcount = failcount + 1;
  end
end

ITYPE=3;
[A3,B3,W,info]=netsolve('dsygv',ITYPE,'V','U',A,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r1(k)=(norm(B*A*A3(:,k)-W(k)*A3(:,k)))/(norm(B*A)*norm(A3(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 250.0 )
    fprintf(2, '** DSYGV(ITYPE=3,UPLO=U) Failure **')
    r
    failcount = failcount + 1;
  end
end

clear A3 B3 W info r1 r
[A3,B3,W,info]=netsolve('dsygv',ITYPE,'V','L',A,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r1(k)=(norm(B*A*A3(:,k)-W(k)*A3(:,k)))/(norm(B*A)*norm(A3(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 250.0 )
    fprintf(2, '** DSYGV(ITYPE=3,UPLO=L) Failure **')
    r
    failcount = failcount + 1;
  end
end

fprintf(2, '\n** Sending a blocking request for "dsygvd"\n\n')
clear N C1 A C2 B ITYPE A1 B1 W info r1 r
N=20;
C1=rand(N);
A=C1+C1';
C2=rand(N);
B=C2*C2';
ITYPE=1;
[A1,B1,W,info]=netsolve('dsygvd',ITYPE,'N','U',A,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r1(k)=(norm(A*A1(:,k)-W(k)*B*A1(:,k)))/(norm(A)*norm(B)*norm(A1(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 100.0 )
    fprintf(2, '** DSYGVD(ITYPE=1,UPLO=U) Failure **')
    r
    failcount = failcount + 1;
  end
end

clear A1 B1 W info r1 r
[A1,B1,W,info]=netsolve('dsygvd',ITYPE,'N','L',A,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r1(k)=(norm(A*A1(:,k)-W(k)*B*A1(:,k)))/(norm(A)*norm(B)*norm(A1(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 100.0 )
    fprintf(2, '** DSYGVD(ITYPE=1,UPLO=L) Failure **')
    r
    failcount = failcount + 1;
  end
end

ITYPE=2;
[A2,B2,W,info]=netsolve('dsygvd',ITYPE,'V','U',A,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r1(k)=(norm(A*B*A2(:,k)-W(k)*A2(:,k)))/(norm(A*B)*norm(A2(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYGVD(ITYPE=2,UPLO=U) Failure **')
    r
    failcount = failcount + 1;
  end
end

clear A2 B2 W info r1 r
[A2,B2,W,info]=netsolve('dsygvd',ITYPE,'V','L',A,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r1(k)=(norm(A*B*A2(:,k)-W(k)*A2(:,k)))/(norm(A*B)*norm(A2(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYGVD(ITYPE=2,UPLO=L) Failure **')
    r
    failcount = failcount + 1;
  end
end

ITYPE=3;
[A3,B3,W,info]=netsolve('dsygvd',ITYPE,'V','U',A,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r1(k)=(norm(B*A*A3(:,k)-W(k)*A3(:,k)))/(norm(B*A)*norm(A3(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYGVD(ITYPE=3,UPLO=U) Failure **')
    r
    failcount = failcount + 1;
  end
end
clear A3 B3 W info r1 r
[A3,B3,W,info]=netsolve('dsygvd',ITYPE,'V','L',A,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r1(k)=(norm(B*A*A3(:,k)-W(k)*A3(:,k)))/(norm(B*A)*norm(A3(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYGVD(ITYPE=3,UPLO=L) Failure **')
    r
    failcount = failcount + 1;
  end
end

fprintf(2, '\n** Sending a blocking request for "dsygvx"\n\n')
clear N C1 A C2 B ITYPE info A1 B1 W r1 r
N=20;
C1=rand(N);
A=C1+C1';
C2=rand(N);
B=C2*C2';
ITYPE=1;
vl=1.0;
vu=5.0;
il=1;
iu=N;
abstol=0.5*eps;
[A1,B1,m,W,Z,ifail,info]=netsolve('dsygvx',ITYPE,'N','A','U',A,B,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
   r1(k)=(norm(A*A1(:,k)-W(k)*B*A1(:,k)))/(norm(A)*norm(B)*norm(A1(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 100.0 )
    fprintf(2, '** DSYGVX(ITYPE=1,UPLO=U) Failure **')
    r
    failcount = failcount + 1;
  end
end
clear A1 B1 W info r1 r
[A1,B1,m,W,Z,ifail,info]=netsolve('dsygvx',ITYPE,'N','A','L',A,B,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
   r1(k)=(norm(A*A1(:,k)-W(k)*B*A1(:,k)))/(norm(A)*norm(B)*norm(A1(:,k)));
  end
  r=max(r1);
  if (info ~= 0 | r > 100.0 )
    fprintf(2, '** DSYGVX(ITYPE=1,UPLO=L) Failure **')
    r
    failcount = failcount + 1;
  end
end


ITYPE=2;
[A2,B2,m,W,Z,ifail,info]=netsolve('dsygvx',ITYPE,'V','A','U',A,B,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r1(k)=(norm(A*B*A2(:,k)-W(k)*A2(:,k)))/(norm(A*B)*norm(A2(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYGVX(ITYPE=2,UPLO=U) Failure **')
    r
    failcount = failcount + 1;
  end
end

clear A2 B2 W info r1 r
[A2,B2,m,W,Z,ifail,info]=netsolve('dsygvx',ITYPE,'V','A','L',A,B,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r1(k)=(norm(A*B*A2(:,k)-W(k)*A2(:,k)))/(norm(A*B)*norm(A2(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYGVX(ITYPE=2,UPLO=L) Failure **')
    r
    failcount = failcount + 1;
  end
end

ITYPE=3;
[A3,B3,m,W,Z,ifail,info]=netsolve('dsygvx',ITYPE,'V','A','U',A,B,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r1(k)=(norm(B*A*A3(:,k)-W(k)*A3(:,k)))/(norm(B*A)*norm(A3(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYGVX(ITYPE=3,UPLO=U) Failure **')
    r
    failcount = failcount + 1;
  end
end

clear A3 B3 W info r1 r
[A3,B3,m,W,Z,ifail,info]=netsolve('dsygvx',ITYPE,'V','A','L',A,B,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r1(k)=(norm(B*A*A3(:,k)-W(k)*A3(:,k)))/(norm(B*A)*norm(A3(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYGVX(ITYPE=3,UPLO=L) Failure **')
    r
    failcount = failcount + 1;
  end
end

fprintf(2, '\n** Sending a blocking request for "dsbgv"\n\n')
clear N C1 C KA AB1 A C3 KU KL C4 B KB BB1 W Z info
N=20;
%Get band stored matrix A, upper triangle part of A,B is stored.
C1=rand(N);
C=C1+C1';
KA=4;
AB1=zeros(KA+1,N);
for i=1:N
  for j=max(1,i-KA):min(N,i+KA)
        A(i,j)=C(i,j);
  end
end
for j=1:N
  for i=max(1,j-KA):j
        AB1(KA+1+i-j,j)=A(i,j);
  end
end
%Get band stored matrix B.
C4=rand(N);
for i=1:N
  for j=1:N
      if (i==j) C4(i,j)=C4(i,j)*100;
      end
  end
end
B=C4*C4';
KB=4;
BB1=zeros(KB+1,N);
for j=1:N
  for i=max(1,j-KB):j
        BB1(KB+1+i-j,j)=B(i,j);
  end
end
[AB1,BB1,W,Z,info]=netsolve('dsbgv','V','U',KA,KB,AB1,BB1);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r1(k)=(norm(A*Z(:,k)-W(k)*B*Z(:,k)))/(norm(A)*norm(B)*norm(Z(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSBGV(UPLO=U) Failure **\n')
    r
    failcount = failcount + 1;
  end
end

clear C1 B KB BB1 W Z info r1 r
%Get band stored matrix B.
C1=rand(N);
for i=1:N
  for j=1:N
      if (i==j) C1(i,j)=C1(i,j)*100;
      end
  end
end
B=C1*C1';
KB=4;
BB1=zeros(KB+1,N);
for j=1:N
  for i=j:min(N,j+KB)
        BB1(1+i-j,j)=B(i,j);
  end
end

[AB1,BB1,W,Z,info]=netsolve('dsbgv','V','L',KA,KB,AB1,BB1);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r1(k)=(norm(A*Z(:,k)-W(k)*B*Z(:,k)))/(norm(A)*norm(B)*norm(Z(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSBGV(UPLO=L) Failure ** \n')
    r
    failcount = failcount + 1;
  end
end

fprintf(2, '\n** Sending a blocking request for "dsbgvd"\n\n')
clear N C1 C KA AB1 A C3 KU KL C4 B KB BB1 W Z info
N=20;
%Get band stored matrix A, upper triangle part of A,B is stored.
C1=rand(N);
C=C1+C1';
KA=4;
AB1=zeros(KA+1,N);
for i=1:N
  for j=max(1,i-KA):min(N,i+KA)
        A(i,j)=C(i,j);
  end
end
for j=1:N
  for i=max(1,j-KA):j
        AB1(KA+1+i-j,j)=A(i,j);
  end
end
%Get band stored matrix B.
C4=rand(N);
for i=1:N
  for j=1:N
      if (i==j) C4(i,j)=C4(i,j)*100;
      end
  end
end
B=C4*C4';
KB=4;
BB1=zeros(KB+1,N);
for j=1:N
  for i=max(1,j-KB):j
        BB1(KB+1+i-j,j)=B(i,j);
  end
end
[AB1,BB1,W,Z,info]=netsolve('dsbgvd','V','U',KA,KB,AB1,BB1);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r1(k)=(norm(A*Z(:,k)-W(k)*B*Z(:,k)))/(norm(A)*norm(B)*norm(Z(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSBGVD(UPLO=U) Failure **\n')
    r
    failcount = failcount + 1;
  end
end

clear C1 B KB BB1 W Z info r1 r
%Get band stored matrix B.
C1=rand(N);
for i=1:N
  for j=1:N
      if (i==j) C1(i,j)=C1(i,j)*100;
      end
  end
end
B=C1*C1';
KB=4;
BB1=zeros(KB+1,N);
for j=1:N
  for i=j:min(N,j+KB)
        BB1(1+i-j,j)=B(i,j);
  end
end

[AB1,BB1,W,Z,info]=netsolve('dsbgvd','V','L',KA,KB,AB1,BB1);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r1(k)=(norm(A*Z(:,k)-W(k)*B*Z(:,k)))/(norm(A)*norm(B)*norm(Z(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSBGVD(UPLO=L) Failure ** \n')
    r
    failcount = failcount + 1;
  end
end

fprintf(2, '\n** Sending a blocking request for "dsbgvx"\n\n')
clear N C1 C KA AB1 A C3 KU KL C4 B KB BB1 W Z info
N=20;
%Get band stored matrix A, upper triangle part of A,B is stored.
C1=rand(N);
C=C1+C1';
KA=4;
AB1=zeros(KA+1,N);
for i=1:N
  for j=max(1,i-KA):min(N,i+KA)
        A(i,j)=C(i,j);
  end
end
for j=1:N
  for i=max(1,j-KA):j
        AB1(KA+1+i-j,j)=A(i,j);
  end
end
%Get band stored matrix B.
C4=rand(N);
for i=1:N
  for j=1:N
      if (i==j) C4(i,j)=C4(i,j)*100;
      end
  end
end
B=C4*C4';
KB=4;
BB1=zeros(KB+1,N);
for j=1:N
  for i=max(1,j-KB):j
        BB1(KB+1+i-j,j)=B(i,j);
  end
end
vl=1.0;
vu=5.0;
il=1;
iu=N;
abstol=0.01*eps;
[AB1,BB1,Q,m,W,Z,ifail,info]=netsolve('dsbgvx','V','A','U',KA,KB,AB1,BB1,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r1(k)=(norm(A*Z(:,k)-W(k)*B*Z(:,k)))/(norm(A)*norm(B)*norm(Z(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSBGVX(UPLO=U) Failure **\n')
    r
    failcount = failcount + 1;
  end
end

clear C1 B KB BB1 Q m W Z ifail info
%Get band stored matrix B.
C1=rand(N);
for i=1:N
  for j=1:N
      if (i==j) C1(i,j)=C1(i,j)*100;
      end
  end
end
B=C1*C1';
KB=4;
BB1=zeros(KB+1,N);
for j=1:N
  for i=j:min(N,j+KB)
        BB1(1+i-j,j)=B(i,j);
  end
end
vl=1.0;
vu=2.0;
il=1;
iu=N;
abstol=0.01*eps;
[AB1,BB1,Q,m,W,Z,ifail,info]=netsolve('dsbgvx','V','A','L',KA,KB,AB1,BB1,vl,vu,il,iu,abstol);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:m
    r1(k)=(norm(A*Z(:,k)-W(k)*B*Z(:,k)))/(norm(A)*norm(B)*norm(Z(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSBGVX(UPLO=L) Failure ** \n')
    fprintf(2,'dsbgvx info = %d\n',info)
    r
    failcount = failcount + 1;
  end
end

fprintf(2, '\n** Sending a blocking request for "dggev"\n\n')
clear N A B ALPHAR ALPHAI BETA VL VR info r1 r2 rr1 rr2
N=20;
A=rand(N);
B=rand(N);
[ALPHAR,ALPHAI,BETA,VL,VR,info]=netsolve('dggev','V','V',A,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  for k=1:N
    r1(k)=(norm(BETA(k)*A*VR(:,k)-(ALPHAR(k)+j*ALPHAI(k))*B*VR(:,k)))/(norm(A)*norm(B)*norm(VR(:,k)));
  end
  rr1=max(r1);

  for k=1:N
    r2(k)=norm(BETA(k)*conj(VL(:,k)')*A-(ALPHAR(k)+j*ALPHAI(k))*conj(VL(:,k)')*B)/(norm(A)*norm(B)*norm(VL(:,k)));
  end
  rr2=max(r2);

  if ( info ~= 0 | rr1 > 50.0 | rr2 > 50.0 )
    fprintf(2, '** DGGEV(V,V) Failure **')
    rr1
    rr2
    failcount = failcount + 1;
  end
end


fprintf(2, '\n** Sending a blocking request for "dggsvd"\n\n')

fprintf(2, '---------------------------------------------------\n')
fprintf(2, 'Testing Divide and Conquer and Expert Drivers for\n')
fprintf(2, 'Linear Least Squares Problems\n')
fprintf(2, '---------------------------------------------------\n')

fprintf(2, '\n** Sending a blocking request for "dgelsy"\n\n')
%clear M N NRHS A B JPVT RCOND AA X RANK info r1
%M=25;
%N=20;
%NRHS=5;
%A=rand(M,N);
%if M>=N
%B=rand(M,NRHS);
%else
%B=rand(N,NRHS);
%end
%JPVT=zeros(N,1);
%RCOND=sqrt(eps)-(sqrt(eps)-eps)/2;
%
%[AA,X,JPVT,RANK,info]=netsolve('dgelsy',A,B,JPVT,RCOND);
%r1 = norm(A*X-B)/(norm(A)*norm(X)*M*eps);
%[e] = netsolve_err;
%count = count + 1;
%
%if (e ~= 0 | info ~= 0 | r1 > 50.0 )
%  fprintf(2,'%s\n',netsolve_errmsg(e))
%  fprintf(2, '** DGELSY(M>N) Failure **')
%  r1
%  failcount = failcount + 1;
%end

clear M N NRHS A B JPVT RCOND AA X RANK info r
M=20;
N=20;
NRHS=5;
A=rand(M,N);
if M>=N
B=rand(M,NRHS);
else
B=rand(N,NRHS);
end
JPVT=zeros(N,1);
RCOND=sqrt(eps)-(sqrt(eps)-eps)/2;

[AA,X,JPVT,RANK,info]=netsolve('dgelsy',A,B,JPVT,RCOND);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  r2 = norm(A*X-B)/(norm(A)*norm(X)*N*eps);
  if ( info ~= 0 | r2 > 50.0 )
    fprintf(2, '** DGELSY(M=N) Failure **')
    r2
    failcount = failcount + 1;
  end
end

fprintf(2, '\n** Sending a blocking request for "dgelss"\n\n')
clear M N A B RCOND S RANK info r
M=25;
N=20;
A=rand(M,N);
%A(:,20)=0;
B=rand(M,5);
RCOND=sqrt(eps)-(sqrt(eps)-eps)/2;
[A,B,S,RANK,info]=netsolve('dgelss',A,B,RCOND);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  r = 0.0;
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DGELSS Failure **')
    r
    failcount = failcount + 1;
  end
end

fprintf(2, '\n** Sending a blocking request for "dgelsd"\n\n')
%clear M N NRHS A B X S RCOND RANK info r1
%M=30;
%N=20;
%NRHS=5;
%A=rand(M,N);
%if M>=N
%B=rand(M,NRHS);
%else
%B=rand(N,NRHS);
%end
%RCOND=sqrt(eps)-(sqrt(eps)-eps)/2;
%
%[X,S,RANK,info]=netsolve('dgelsd',A,B,RCOND);
%r1 = norm(A*X-B)/(norm(A)*norm(X)*M*eps);
%[e] = netsolve_err;
%count = count + 1;
%
%if (e ~= 0 | info ~= 0 | r1 > 50.0 )
%  fprintf(2,'%s\n',netsolve_errmsg(e))
%  fprintf(2, '** DGELSD(M>N) Failure **')
%  r1
%  failcount = failcount + 1;
%end

clear M N NRHS A B X S RCOND RANK info r
M=30;
N=30;
NRHS=5;
A=rand(M,N);
if M>=N
B=rand(M,NRHS);
else
B=rand(N,NRHS);
end
RCOND=sqrt(eps)-(sqrt(eps)-eps)/2;

[X,S,RANK,info]=netsolve('dgelsd',A,B,RCOND);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  r2 = norm(A*X-B)/(norm(A)*norm(X)*N*eps);
  if ( info ~= 0 | r2 > 50.0 )
    fprintf(2, '** DGELSD(M=N) Failure **')
    r2
    failcount = failcount + 1;
  end
end


fprintf(2, '\n ** %d Tests were performed.\n', count)
fprintf(2, '\n ** %d tests failed to pass the threshold.\n\n', failcount)


fprintf(2, '       ** End of testing **\n\n');

pause(1);
