fprintf(2, '\n** Sending a blocking request for "dsyevr"\n\n')
clear
%
%  Construct a W__  Wilkinson matrix with N=42 and 10e-8 on split
%               21                                offdiagonal
%
N=42;
A=zeros(N,N);
for i=1:42
   A(i,i) = 11.0 - i;
end
for i=1:41
   A(i,i+1) = 1.0;
   A(i+1,i) = 1.0;
end
A(20,22)=10e-8;
A(22,20)=10e-8;
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=0.25*eps;
[m,W,Z,isuppz,info]=netsolve('dsyevr','V','A','U',A,vl,vu,il,iu,abstol);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:m
    r1(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEVR(V,A,U) Failure **')
    info
    r
  else
    fprintf(2, '** DSYEVR(V,A,U) residual r= %f \n',r)
  end
end

fprintf(2, '\n** Sending a blocking request for "dsyevd"\n\n')
clear
N=42;
A=zeros(N,N);
for i=1:42
   A(i,i) = 11.0 - i;
end
for i=1:41
   A(i,i+1) = 1.0;
   A(i+1,i) = 1.0;
end
A(20,22)=10e-8;
A(22,20)=10e-8;
[X,W,info]=netsolve('dsyevd','V','U',A);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:N
    r1(k)=norm(A*X(:,k)-W(k)*X(:,k))/(norm(A)*norm(X(:,k))*eps);
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEVD(U) Failure **')
    info
    r
  else
    fprintf(2, '** DSYEVD(V,U) residual r= %f \n',r)
  end
end

fprintf(2, '\n** Sending a blocking request for "dsyevx"\n\n')
clear
N=42;
A=zeros(N,N);
for i=1:42
   A(i,i) = 11.0 - i;
end
for i=1:41
   A(i,i+1) = 1.0;
   A(i+1,i) = 1.0;
end
A(20,22)=10e-8;
A(22,20)=10e-8;
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=0.25*eps;
[m,W,Z,ifail,info]=netsolve('dsyevx','V','A','U',A,vl,vu,il,iu,abstol);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:m
      r1(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEVX(V,A,U) Failure **')
    info
    r
  else
    fprintf(2, '** DSYEVX(V,A,U) residual r= %f \n',r)
  end
end

fprintf(2, '\n** Sending a blocking request for "dsyev"\n\n')
clear
N=42;
A=zeros(N,N);
for i=1:42
   A(i,i) = 11.0 - i;
end
for i=1:41
   A(i,i+1) = 1.0;
   A(i+1,i) = 1.0;
end
A(20,22)=10e-8;
A(22,20)=10e-8;
[X,W,info]=netsolve('dsyev','V','U',A);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:N
    r1(k)=norm(A*X(:,k)-W(k)*X(:,k))/(norm(A)*norm(X(:,k))*eps);
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEV(U) Failure **')
    info
    r
  else
    fprintf(2, '** DSYEV(V,U) residual r= %f \n',r)
  end
end
