fprintf(2, '\n** Sending a blocking request for "dsyevr"\n\n')
clear
N=20;
C=rand(N);
A=C+C';
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[m,W,Z,isuppz,info]=netsolve('dsyevr','V','A','U',A,vl,vu,il,iu,abstol);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:m
      r1(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEVR(V,A,U) Failure **')
    r
  else
    fprintf(2, '** DSYEVR(V,A,U) Passed Tests **\n')
  end
end

clear
N=20;
C=rand(N);
A=C+C';
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[m,W,Z,isuppz,info]=netsolve('dsyevr','V','A','L',A,vl,vu,il,iu,abstol);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:m
      r2(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  r=max(r2);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEVR(V,A,L) Failure **')
    r
  else
    fprintf(2, '** DSYEVR(V,A,L) Passed Tests **\n')
  end
end

clear
N=20;
C=rand(N);
A=C+C';
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[m,W,Z,isuppz,info]=netsolve('dsyevr','V','V','U',A,vl,vu,il,iu,abstol);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:m
    r3(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  r=max(r3);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEVR(V,V,U) Failure **')
    r
  else
    fprintf(2, '** DSYEVR(V,V,U) Passed Tests **\n')
  end
end

clear
N=20;
C=rand(N);
A=C+C';
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[m,W,Z,isuppz,info]=netsolve('dsyevr','V','V','L',A,vl,vu,il,iu,abstol);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:m
      r4(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  r=max(r4);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEVR(V,V,L) Failure **')
    r
  else
    fprintf(2, '** DSYEVR(V,V,L) Passed Tests **\n')
  end
end

% RANGE='I' is not yet supported in DSTEGR
%
%clear
%N=20;
%C=rand(N);
%A=C+C';
%vl=2.0;
%vu=5.0;
%il=1;
%iu=N;
%abstol=2*eps;
%[m,W,Z,isuppz,info]=netsolve('dsyevr','V','I','U',A,vl,vu,il,iu,abstol);
%  fprintf(2,'info = %s\n',info)
%for k=1:m
%    r5(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
%end
%r=max(r5);
%[e] = netsolve_err;
%
%if (e ~= 0 | info ~= 0 | r > 50.0 )
%  fprintf(2,'%s\n',netsolve_errmsg(e))
%  fprintf(2, '** DSYEVR(V,I,U) Failure **')
%  r
%else
%  fprintf(2, '** DSYEVR(V,I,U) Passed Tests **\n')
%end
%
%clear
%N=20;
%C=rand(N);
%A=C+C';
%vl=2.0;
%vu=5.0;
%il=1;
%iu=N;
%abstol=2*eps;
%[m,W,Z,isuppz,info]=netsolve('dsyevr','V','I','L',A,vl,vu,il,iu,abstol);
%[e] = netsolve_err;
%fprintf(2,'%s\n',netsolve_errmsg(e))
%for k=1:m
%    r6(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
%end
%r=max(r6);
%
%if (e ~= 0 | info ~= 0 | r > 50.0 )
%  fprintf(2,'%s\n',netsolve_errmsg(e))
%  fprintf(2, '** DSYEVR(V,I,L) Failure **')
%  r
%else
%  fprintf(2, '** DSYEVR(V,I,L) Passed Tests **\n')
%end
